/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.macwidgets.MacColorUtils;
import com.explodingpixels.painter.MacWidgetsPainter;
import com.explodingpixels.widgets.WindowUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacPainterFactory {
    public static MacWidgetsPainter<Component> createIAppUnpressedUnselectedHeaderPainter() {
        return new MacWidgetsPainter<Component>(){
            private Color TOP_GRADIENT_COLOR = new Color(0xDBDBDB);
            private Color BOTTOM_GRADIENT_COLOR = new Color(0xBBBBBB);

            @Override
            public void paint(Graphics2D graphics2D, Component component, int width, int height) {
                MacPainterFactory.paintLeopardGradientSelection(this.TOP_GRADIENT_COLOR, this.BOTTOM_GRADIENT_COLOR, this.TOP_GRADIENT_COLOR, this.BOTTOM_GRADIENT_COLOR, graphics2D, width, height);
            }
        };
    }

    public static MacWidgetsPainter<Component> createIAppPressedUnselectedHeaderPainter() {
        return new MacWidgetsPainter<Component>(){
            private Color TOP_GRADIENT_COLOR = new Color(0xC4C4C4);
            private Color BOTTOM_GRADIENT_COLOR = new Color(0x959595);

            @Override
            public void paint(Graphics2D graphics2D, Component component, int width, int height) {
                MacPainterFactory.paintLeopardGradientSelection(this.TOP_GRADIENT_COLOR, this.BOTTOM_GRADIENT_COLOR, this.TOP_GRADIENT_COLOR, this.BOTTOM_GRADIENT_COLOR, graphics2D, width, height);
            }
        };
    }

    public static MacWidgetsPainter<Component> createIAppUnpressedSelectedHeaderPainter() {
        return new MacWidgetsPainter<Component>(){
            private Color TOP_GRADIENT_COLOR = new Color(12767197);
            private Color BOTTOM_GRADIENT_COLOR = new Color(8229810);

            @Override
            public void paint(Graphics2D graphics2D, Component component, int width, int height) {
                MacPainterFactory.paintLeopardGradientSelection(this.TOP_GRADIENT_COLOR, MacColorUtils.LEOPARD_BORDER_COLOR, this.TOP_GRADIENT_COLOR, this.BOTTOM_GRADIENT_COLOR, graphics2D, width, height);
            }
        };
    }

    public static MacWidgetsPainter<Component> createIAppPressedSelectedHeaderPainter() {
        return new MacWidgetsPainter<Component>(){
            private Color TOP_GRADIENT_COLOR = new Color(10926027);
            private Color BOTTOM_GRADIENT_COLOR = new Color(5467024);

            @Override
            public void paint(Graphics2D graphics2D, Component component, int width, int height) {
                MacPainterFactory.paintLeopardGradientSelection(this.TOP_GRADIENT_COLOR, MacColorUtils.LEOPARD_BORDER_COLOR, this.TOP_GRADIENT_COLOR, this.BOTTOM_GRADIENT_COLOR, graphics2D, width, height);
            }
        };
    }

    private static void paintLeopardGradientSelection(Color topLineColor, Color bottomLineColor, Color topGradientColor, Color bottomGradientColor, Graphics2D graphics2D, int width, int height) {
        GradientPaint paint = new GradientPaint(0.0f, 1.0f, topGradientColor, 0.0f, height - 2, bottomGradientColor);
        graphics2D.setPaint(paint);
        graphics2D.fillRect(0, 0, width, height);
        graphics2D.setColor(topLineColor);
        graphics2D.drawLine(0, 0, width, 0);
        graphics2D.setColor(bottomLineColor);
        graphics2D.drawLine(0, height - 1, width, height - 1);
    }

    public static MacWidgetsPainter<Component> createTexturedWindowWorkaroundPainter() {
        return new MacWidgetsPainter<Component>(){
            private Color ACTIVE_TOP_GRADIENT_COLOR = new Color(0xBCBCBC);
            private Color ACTIVE_BOTTOM_GRADIENT_COLOR = new Color(0x9A9A9A);
            private Color INACTIVE_TOP_GRADIENT_COLOR = new Color(0xE4E4E4);
            private Color INACTIVE_BOTTOM_GRADIENT_COLOR = new Color(0xD1D1D1);

            @Override
            public void paint(Graphics2D graphics2D, Component component, int width, int height) {
                boolean containedInActiveWindow = WindowUtils.isParentWindowFocused(component);
                Color topColor = containedInActiveWindow ? this.ACTIVE_TOP_GRADIENT_COLOR : this.INACTIVE_TOP_GRADIENT_COLOR;
                Color bottomColor = containedInActiveWindow ? this.ACTIVE_BOTTOM_GRADIENT_COLOR : this.INACTIVE_BOTTOM_GRADIENT_COLOR;
                GradientPaint paint = new GradientPaint(0.0f, 1.0f, topColor, 0.0f, height, bottomColor);
                graphics2D.setPaint(paint);
                graphics2D.fillRect(0, 0, width, height);
            }
        };
    }
}

