/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.widgets;

import com.explodingpixels.util.PlatformUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class WindowUtils {
    public static void makeWindowNonOpaque(Window window) {
        window.setBackground(new Color(0, 0, 0, 0));
        if (!PlatformUtils.isMac()) {
            WindowUtils.quietlyTryToMakeWindowNonOqaque(window);
        }
    }

    private static void quietlyTryToMakeWindowNonOqaque(Window window) {
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Method method = clazz.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
            method.invoke(clazz, window, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deprecated
    public static WindowFocusListener createAndInstallRepaintWindowFocusListener(Window window) {
        WindowFocusListener windowFocusListener = new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent e) {
                e.getWindow().repaint();
            }

            public void windowLostFocus(WindowEvent e) {
                e.getWindow().repaint();
            }
        };
        window.addWindowFocusListener(windowFocusListener);
        return windowFocusListener;
    }

    public static boolean isParentWindowFocused(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        return window != null && window.isFocused();
    }

    public static void installWeakWindowFocusListener(JComponent component, WindowFocusListener focusListener) {
        AncestorListener ancestorListener = WindowUtils.createAncestorListener(component, focusListener);
        component.addAncestorListener(ancestorListener);
    }

    public static void installJComponentRepainterOnWindowFocusChanged(JComponent component) {
        WindowFocusListener windowListener = WindowUtils.createRepaintWindowListener(component);
        AncestorListener ancestorListener = WindowUtils.createAncestorListener(component, windowListener);
        component.addAncestorListener(ancestorListener);
    }

    private static AncestorListener createAncestorListener(JComponent component, final WindowFocusListener windowListener) {
        final WeakReference<JComponent> weakReference = new WeakReference<JComponent>(component);
        return new AncestorListener(){

            public void ancestorAdded(AncestorEvent event) {
                Window window;
                Window window2 = window = weakReference.get() == null ? null : SwingUtilities.getWindowAncestor((Component)weakReference.get());
                if (window != null) {
                    window.removeWindowFocusListener(windowListener);
                    window.addWindowFocusListener(windowListener);
                    this.fireInitialFocusEvent(windowListener, window);
                }
            }

            private void fireInitialFocusEvent(WindowFocusListener windowListener2, Window window) {
                Window focusedWindow = FocusManager.getCurrentManager().getFocusedWindow();
                if (window == focusedWindow) {
                    windowListener2.windowGainedFocus(new WindowEvent(window, 207));
                } else {
                    windowListener2.windowGainedFocus(new WindowEvent(window, 208));
                }
            }

            public void ancestorRemoved(AncestorEvent event) {
                Window window;
                Window window2 = window = weakReference.get() == null ? null : SwingUtilities.getWindowAncestor((Component)weakReference.get());
                if (window != null) {
                    window.removeWindowFocusListener(windowListener);
                }
            }

            public void ancestorMoved(AncestorEvent event) {
            }
        };
    }

    private static WindowFocusListener createRepaintWindowListener(final JComponent component) {
        return new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent e) {
                component.repaint();
            }

            public void windowLostFocus(WindowEvent e) {
                component.repaint();
            }
        };
    }
}

