/*
 * Decompiled with CFR 0.152.
 */
package org.ccil.cowan.tagsoup;

import java.util.HashMap;
import org.ccil.cowan.tagsoup.ElementType;

public abstract class Schema {
    public static final int M_ANY = -1;
    public static final int M_EMPTY = 0;
    public static final int M_PCDATA = 0x40000000;
    public static final int M_ROOT = Integer.MIN_VALUE;
    public static final int F_RESTART = 1;
    public static final int F_CDATA = 2;
    public static final int F_NOFORCE = 4;
    private HashMap theEntities = new HashMap();
    private HashMap theElementTypes = new HashMap();
    private String theURI = "";
    private String thePrefix = "";

    public void elementType(String name, int model, int memberOf, int flags) {
        ElementType e = new ElementType(name, model, memberOf, flags, this);
        this.theElementTypes.put(name, e);
    }

    public void attribute(String elemName, String attrName, String type, String value) {
        ElementType e = this.getElementType(elemName);
        if (e == null) {
            throw new Error("Attribute " + attrName + " specified for unknown element type " + elemName);
        }
        e.setAttribute(attrName, type, value);
    }

    public void parent(String name, String parentName) {
        ElementType child = this.getElementType(name);
        ElementType parent = this.getElementType(parentName);
        if (child == null) {
            throw new Error("No child " + name + " for parent " + parentName);
        }
        if (parent == null) {
            throw new Error("No parent " + parentName + " for child " + name);
        }
        child.setParent(parent);
    }

    public void entity(String name, char value) {
        this.theEntities.put(name, new Character(value));
    }

    public ElementType getElementType(String name) {
        return (ElementType)this.theElementTypes.get(name);
    }

    public char getEntity(String name) {
        if (name.length() == 0) {
            return '\u0000';
        }
        if (name.charAt(0) == '#') {
            if (name.length() > 1 && (name.charAt(1) == 'x' || name.charAt(1) == 'X')) {
                try {
                    return (char)Integer.parseInt(name.substring(2), 16);
                }
                catch (NumberFormatException e) {
                    return '\u0000';
                }
            }
            try {
                return (char)Integer.parseInt(name.substring(1));
            }
            catch (NumberFormatException e) {
                return '\u0000';
            }
        }
        Character c = (Character)this.theEntities.get(name);
        if (c == null) {
            return '\u0000';
        }
        return c.charValue();
    }

    public String getURI() {
        return this.theURI;
    }

    public String getPrefix() {
        return this.thePrefix;
    }

    public void setURI(String uri) {
        this.theURI = uri;
    }

    public void setPrefix(String prefix) {
        this.thePrefix = prefix;
    }
}

