/*
 * Decompiled with CFR 0.152.
 */
package de.java2html;

import de.java2html.Java2Html;
import de.java2html.Java2HtmlOptionsPanel;
import de.java2html.converter.JavaSourceConverter;
import de.java2html.gui.GBorderedPanel;
import de.java2html.gui.Gap;
import de.java2html.gui.InfoDialog;
import de.java2html.javasource.JavaSource;
import de.java2html.javasource.JavaSourceParser;
import de.java2html.options.Java2HtmlConversionOptions;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;

public class Java2HtmlApplication
extends Frame
implements ActionListener,
ItemListener {
    private List list;
    private Button bAdd;
    private Button bRemove;
    private Button bConvert;
    private Button bClear;
    private Button bExit;
    private String currentDirectory;
    private Java2HtmlOptionsPanel optionsPanel;

    public Java2HtmlApplication() {
        super("Java2Html Converter V4.1");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.list = new List(6, true);
        this.list.addItemListener(this);
        this.bAdd = new Button("Add");
        this.bAdd.addActionListener(this);
        this.bRemove = new Button("Remove");
        this.bRemove.addActionListener(this);
        this.bRemove.setEnabled(false);
        this.bClear = new Button("Clear");
        this.bClear.addActionListener(this);
        this.bClear.setEnabled(false);
        this.bConvert = new Button("Convert");
        this.bConvert.addActionListener(this);
        this.bConvert.setEnabled(false);
        this.bExit = new Button("Exit");
        this.bExit.addActionListener(this);
        Panel pb = new Panel();
        pb.setLayout(new GridLayout(0, 1, 2, 2));
        pb.add(this.bAdd);
        pb.add(this.bRemove);
        pb.add(this.bClear);
        pb.add(new Gap());
        pb.add(this.bExit);
        GBorderedPanel pc = new GBorderedPanel("Files to convert");
        pc.setLayout(new BorderLayout(4, 4));
        pc.add((Component)this.list, "Center");
        pc.add((Component)pb, "East");
        this.optionsPanel = new Java2HtmlOptionsPanel();
        GBorderedPanel pOptions = new GBorderedPanel("Options");
        pOptions.setLayout(new BorderLayout());
        pOptions.add((Component)this.optionsPanel, "Center");
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)pOptions, "East");
        this.add((Component)pc, "Center");
        this.add((Component)this.bConvert, "South");
        this.pack();
    }

    protected void add() {
        FileDialog fd = new FileDialog((Frame)this, "Open Java Source", 0);
        fd.setFile("*.java");
        if (this.currentDirectory != null) {
            fd.setDirectory(this.currentDirectory);
        }
        fd.show();
        String filename = fd.getFile();
        String directory = fd.getDirectory();
        if (filename == null) {
            return;
        }
        this.currentDirectory = directory;
        this.list.add(String.valueOf(directory) + filename);
        this.bClear.setEnabled(true);
        this.bConvert.setEnabled(true);
    }

    protected void remove() {
        String[] o = this.list.getSelectedItems();
        int i = 0;
        while (i < o.length) {
            this.list.remove(o[i]);
            ++i;
        }
        this.bRemove.setEnabled(false);
        this.bClear.setEnabled(this.list.getItemCount() > 0);
        this.bConvert.setEnabled(this.list.getItemCount() > 0);
    }

    protected void clear() {
        this.list.removeAll();
        this.bRemove.setEnabled(false);
        this.bClear.setEnabled(false);
        this.bConvert.setEnabled(false);
    }

    protected void convert() {
        Java2HtmlConversionOptions options = this.optionsPanel.getConversionOptions();
        options.setShowJava2HtmlLink(true);
        StringBuffer report = new StringBuffer();
        StringWriter writer = new StringWriter();
        JavaSourceConverter converter = this.optionsPanel.getConverter();
        converter.setConversionOptions(options);
        writer.write(converter.getDocumentHeader());
        String[] fileNames = this.list.getItems();
        int count = 0;
        while (count < fileNames.length) {
            report.append("File " + (count + 1) + ": " + fileNames[count] + "\n");
            if (count > 0) {
                writer.write(converter.getBlockSeparator());
            }
            try {
                JavaSourceParser parser = new JavaSourceParser(options);
                JavaSource source = parser.parse(new File(fileNames[count]));
                converter.convert(source, writer);
                writer.write(10);
                report.append(String.valueOf(source.getStatisticsString()) + "\n");
            }
            catch (IOException e) {
                System.err.println("Error converting " + fileNames[count] + ": " + e);
            }
            ++count;
        }
        writer.write(converter.getDocumentFooter());
        StringSelection sel = new StringSelection(writer.getBuffer().toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(sel, sel);
        report.append("\n - The converted source code has been copied the system clipboard - ");
        String plural = "";
        if (fileNames.length > 1) {
            plural = "s";
        }
        new InfoDialog((Frame)this, "File" + plural + " converted", String.valueOf(fileNames.length) + " File" + plural + " successfully converted to the system clipboard.", report.toString()).show();
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.bAdd) {
            this.add();
        } else if (source == this.bRemove) {
            this.remove();
        } else if (source == this.bClear) {
            this.clear();
        } else if (source == this.bExit) {
            System.exit(0);
        } else {
            this.convert();
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        this.bRemove.setEnabled(this.list.getSelectedIndexes().length > 0);
    }

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            Java2Html.main(args);
            return;
        }
        Java2HtmlApplication j = new Java2HtmlApplication();
        j.setSize(480, 270);
        j.show();
    }
}

