/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkEventMotion;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    String text;
    TextLayout layout;
    Color linkColor;
    Color disabledColor;
    Point[] offsets;
    Point selection;
    String[] ids;
    int[] mnemonics;
    int focusIndex;
    static final RGB LINK_FOREGROUND = new RGB(0, 51, 153);
    static final RGB LINK_DISABLED_FOREGROUND = new RGB(172, 168, 153);

    public Link(Composite composite, int n) {
        super(composite, n);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        int n4;
        Rectangle rectangle;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int n5 = this.layout.getWidth();
        if (n == 0) {
            this.layout.setWidth(1);
            rectangle = this.layout.getBounds();
            n4 = 0;
            n3 = rectangle.height;
        } else {
            this.layout.setWidth(n);
            rectangle = this.layout.getBounds();
            n4 = rectangle.width;
            n3 = rectangle.height;
        }
        this.layout.setWidth(n5);
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n3 = n2;
        }
        int n6 = this.getBorderWidth();
        return new Point(n4 += n6 * 2, n3 += n6 * 2);
    }

    void createHandle(int n) {
        this.state |= 0x10008;
        this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.handle == 0) {
            SWT.error(2);
        }
        OS.gtk_fixed_set_has_window(this.handle, true);
        OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        this.layout = new TextLayout(this.display);
        this.layout.setOrientation((this.style & 0x4000000) != 0 ? 0x4000000 : 0x2000000);
        this.linkColor = new Color(this.display, LINK_FOREGROUND);
        this.disabledColor = new Color(this.display, LINK_DISABLED_FOREGROUND);
        this.offsets = new Point[0];
        this.ids = new String[0];
        this.mnemonics = new int[0];
        this.selection = new Point(-1, -1);
        this.focusIndex = -1;
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.layout.setFont(this.getFont());
        this.text = "";
        this.initAccessible();
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        if (this.isDisposed()) {
            return;
        }
        TextStyle textStyle = new TextStyle(null, bl ? this.linkColor : this.disabledColor, null);
        textStyle.underline = true;
        int n = 0;
        while (n < this.offsets.length) {
            Point point = this.offsets[n];
            this.layout.setStyle(textStyle, point.x, point.y);
            ++n;
        }
        this.redraw();
    }

    void fixStyle() {
        this.fixStyle(this.handle);
    }

    void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = Link.this.parse(Link.this.text);
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.childID = -1;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = Link.this.display.map((Control)Link.this.getParent(), null, Link.this.getBounds());
                accessibleControlEvent.x = rectangle.x;
                accessibleControlEvent.y = rectangle.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 30;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0x100000;
                if (Link.this.hasFocus()) {
                    accessibleControlEvent.detail |= 4;
                }
            }

            public void getDefaultAction(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = SWT.getMessage("SWT_Press");
            }

            public void getSelection(AccessibleControlEvent accessibleControlEvent) {
                if (Link.this.hasFocus()) {
                    accessibleControlEvent.childID = -1;
                }
            }

            public void getFocus(AccessibleControlEvent accessibleControlEvent) {
                if (Link.this.hasFocus()) {
                    accessibleControlEvent.childID = -1;
                }
            }
        });
    }

    String getNameText() {
        return this.getText();
    }

    Rectangle[] getRectangles(int n) {
        int n2 = this.layout.getLineCount();
        Rectangle[] rectangleArray = new Rectangle[n2];
        int[] nArray = this.layout.getLineOffsets();
        Point point = this.offsets[n];
        int n3 = 1;
        while (point.x > nArray[n3]) {
            ++n3;
        }
        int n4 = 1;
        while (point.y > nArray[n4]) {
            ++n4;
        }
        int n5 = 0;
        if (n3 == n4) {
            rectangleArray[n5++] = this.layout.getBounds(point.x, point.y);
        } else {
            rectangleArray[n5++] = this.layout.getBounds(point.x, nArray[n3] - 1);
            rectangleArray[n5++] = this.layout.getBounds(nArray[n4 - 1], point.y);
            if (n4 - n3 > 1) {
                int n6 = n3;
                while (n6 < n4 - 1) {
                    rectangleArray[n5++] = this.layout.getLineBounds(n6);
                    ++n6;
                }
            }
        }
        if (rectangleArray.length != n5) {
            Rectangle[] rectangleArray2 = new Rectangle[n5];
            System.arraycopy(rectangleArray, 0, rectangleArray2, 0, n5);
            rectangleArray = rectangleArray2;
        }
        return rectangleArray;
    }

    int getClientWidth() {
        return (this.state & 0x200) != 0 ? 0 : OS.GTK_WIDGET_WIDTH(this.handle);
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    int gtk_button_press_event(int n, int n2) {
        int n3 = super.gtk_button_press_event(n, n2);
        if (n3 != 0) {
            return n3;
        }
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
        if (gdkEventButton.button == 1 && gdkEventButton.type == 4) {
            if (this.focusIndex != -1) {
                this.setFocus();
            }
            int n4 = (int)gdkEventButton.x;
            int n5 = (int)gdkEventButton.y;
            if ((this.style & 0x8000000) != 0) {
                n4 = this.getClientWidth() - n4;
            }
            int n6 = this.layout.getOffset(n4, n5, null);
            int n7 = this.selection.x;
            int n8 = this.selection.y;
            this.selection.x = n6;
            this.selection.y = -1;
            if (n7 != -1 && n8 != -1) {
                if (n7 > n8) {
                    int n9 = n7;
                    n7 = n8;
                    n8 = n9;
                }
                Rectangle rectangle = this.layout.getBounds(n7, n8);
                this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            }
            int n10 = 0;
            while (n10 < this.offsets.length) {
                Rectangle[] rectangleArray = this.getRectangles(n10);
                int n11 = 0;
                while (n11 < rectangleArray.length) {
                    Rectangle rectangle = rectangleArray[n11];
                    if (rectangle.contains(n4, n5)) {
                        this.focusIndex = n10;
                        this.redraw();
                        return n3;
                    }
                    ++n11;
                }
                ++n10;
            }
        }
        return n3;
    }

    int gtk_button_release_event(int n, int n2) {
        int n3 = super.gtk_button_release_event(n, n2);
        if (n3 != 0) {
            return n3;
        }
        if (this.focusIndex == -1) {
            return n3;
        }
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
        if (gdkEventButton.button == 1) {
            int n4 = (int)gdkEventButton.x;
            int n5 = (int)gdkEventButton.y;
            if ((this.style & 0x8000000) != 0) {
                n4 = this.getClientWidth() - n4;
            }
            Rectangle[] rectangleArray = this.getRectangles(this.focusIndex);
            int n6 = 0;
            while (n6 < rectangleArray.length) {
                Rectangle rectangle = rectangleArray[n6];
                if (rectangle.contains(n4, n5)) {
                    Event event = new Event();
                    event.text = this.ids[this.focusIndex];
                    this.sendSelectionEvent(13, event, true);
                    return n3;
                }
                ++n6;
            }
        }
        return n3;
    }

    int gtk_event_after(int n, int n2) {
        int n3 = super.gtk_event_after(n, n2);
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, n2, GdkEvent.sizeof);
        switch (gdkEvent.type) {
            case 12: {
                this.redraw();
            }
        }
        return n3;
    }

    int gtk_expose_event(int n, int n2) {
        Rectangle[] rectangleArray;
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        GdkEventExpose gdkEventExpose = new GdkEventExpose();
        OS.memmove(gdkEventExpose, n2, GdkEventExpose.sizeof);
        GCData gCData = new GCData();
        gCData.damageRgn = gdkEventExpose.region;
        GC gC = GC.gtk_new(this, gCData);
        OS.gdk_gc_set_clip_region(gC.handle, gdkEventExpose.region);
        int n3 = this.selection.x;
        int n4 = this.selection.y;
        if (n3 > n4) {
            n3 = this.selection.y;
            n4 = this.selection.x;
        }
        n4 = -1;
        n3 = -1;
        if ((this.state & 0x10) != 0) {
            gC.setForeground(this.disabledColor);
        }
        this.layout.draw(gC, 0, 0, n3, n4, null, null);
        if (this.hasFocus() && this.focusIndex != -1) {
            rectangleArray = this.getRectangles(this.focusIndex);
            int n5 = 0;
            while (n5 < rectangleArray.length) {
                Rectangle rectangle = rectangleArray[n5];
                gC.drawFocus(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                ++n5;
            }
        }
        if (this.hooks(9) || this.filters(9)) {
            rectangleArray = new Event();
            rectangleArray.count = gdkEventExpose.count;
            rectangleArray.x = gdkEventExpose.area_x;
            rectangleArray.y = gdkEventExpose.area_y;
            rectangleArray.width = gdkEventExpose.area_width;
            rectangleArray.height = gdkEventExpose.area_height;
            if ((this.style & 0x8000000) != 0) {
                rectangleArray.x = this.getClientWidth() - rectangleArray.width - rectangleArray.x;
            }
            rectangleArray.gc = gC;
            this.sendEvent(9, (Event)rectangleArray);
            rectangleArray.gc = null;
        }
        gC.dispose();
        return 0;
    }

    int gtk_key_press_event(int n, int n2) {
        int n3 = super.gtk_key_press_event(n, n2);
        if (n3 != 0) {
            return n3;
        }
        if (this.focusIndex == -1) {
            return n3;
        }
        GdkEventKey gdkEventKey = new GdkEventKey();
        OS.memmove(gdkEventKey, n2, GdkEventKey.sizeof);
        switch (gdkEventKey.keyval) {
            case 32: 
            case 65293: 
            case 65421: {
                Event event = new Event();
                event.text = this.ids[this.focusIndex];
                this.sendSelectionEvent(13, event, true);
                break;
            }
            case 65289: {
                if (this.focusIndex >= this.offsets.length - 1) break;
                ++this.focusIndex;
                this.redraw();
                break;
            }
            case 65056: {
                if (this.focusIndex <= 0) break;
                --this.focusIndex;
                this.redraw();
            }
        }
        return n3;
    }

    int gtk_motion_notify_event(int n, int n2) {
        int n3 = super.gtk_motion_notify_event(n, n2);
        if (n3 != 0) {
            return n3;
        }
        GdkEventMotion gdkEventMotion = new GdkEventMotion();
        OS.memmove(gdkEventMotion, n2, GdkEventMotion.sizeof);
        int n4 = (int)gdkEventMotion.x;
        int n5 = (int)gdkEventMotion.y;
        if ((this.style & 0x8000000) != 0) {
            n4 = this.getClientWidth() - n4;
        }
        if ((gdkEventMotion.state & 0x100) != 0) {
            int n6 = this.selection.y;
            this.selection.y = this.layout.getOffset(n4, n5, null);
            if (this.selection.y != n6) {
                int n7 = this.selection.y;
                if (n6 > n7) {
                    int n8 = n6;
                    n6 = n7;
                    n7 = n8;
                }
                Rectangle rectangle = this.layout.getBounds(n6, n7);
                this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            }
        } else {
            int n9 = 0;
            while (n9 < this.offsets.length) {
                Rectangle[] rectangleArray = this.getRectangles(n9);
                int n10 = 0;
                while (n10 < rectangleArray.length) {
                    Rectangle rectangle = rectangleArray[n10];
                    if (rectangle.contains(n4, n5)) {
                        this.setCursor(this.display.getSystemCursor(21));
                        return n3;
                    }
                    ++n10;
                }
                ++n9;
            }
            this.setCursor(null);
        }
        return n3;
    }

    boolean mnemonicHit(char c) {
        char c2 = Character.toUpperCase(c);
        String string = this.layout.getText();
        int n = 0;
        while (n < this.mnemonics.length - 1) {
            char c3;
            if (this.mnemonics[n] != -1 && c2 == Character.toUpperCase(c3 = string.charAt(this.mnemonics[n]))) {
                if (!this.setFocus()) {
                    return false;
                }
                this.focusIndex = n;
                this.redraw();
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean mnemonicMatch(char c) {
        char c2 = Character.toUpperCase(c);
        String string = this.layout.getText();
        int n = 0;
        while (n < this.mnemonics.length - 1) {
            char c3;
            if (this.mnemonics[n] != -1 && c2 == Character.toUpperCase(c3 = string.charAt(this.mnemonics[n]))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.layout != null) {
            this.layout.dispose();
        }
        this.layout = null;
        if (this.linkColor != null) {
            this.linkColor.dispose();
        }
        this.linkColor = null;
        if (this.disabledColor != null) {
            this.disabledColor.dispose();
        }
        this.disabledColor = null;
        this.offsets = null;
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    String parse(String string) {
        int n;
        int n2;
        int n3 = string.length();
        this.offsets = new Point[n3 / 4];
        this.ids = new String[n3 / 4];
        this.mnemonics = new int[n3 / 4 + 1];
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[n3];
        string.getChars(0, string.length(), cArray, 0);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n4 < n3) {
            n2 = Character.toLowerCase(cArray[n4]);
            block0 : switch (n5) {
                case 0: {
                    if (n2 != 60) break;
                    n8 = n4;
                    ++n5;
                    break;
                }
                case 1: {
                    if (n2 != 97) break;
                    ++n5;
                    break;
                }
                case 2: {
                    switch (n2) {
                        case 104: {
                            n5 = 7;
                            break block0;
                        }
                        case 62: {
                            n9 = n4 + 1;
                            ++n5;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace((char)n2)) break;
                    n5 = 13;
                    break;
                }
                case 3: {
                    if (n2 != 60) break;
                    n10 = n4;
                    ++n5;
                    break;
                }
                case 4: {
                    n5 = n2 == 47 ? n5 + 1 : 3;
                    break;
                }
                case 5: {
                    n5 = n2 == 97 ? n5 + 1 : 3;
                    break;
                }
                case 6: {
                    if (n2 == 62) {
                        this.mnemonics[n6] = this.parseMnemonics(cArray, n7, n8, stringBuffer);
                        n = stringBuffer.length();
                        this.parseMnemonics(cArray, n9, n10, stringBuffer);
                        this.offsets[n6] = new Point(n, stringBuffer.length() - 1);
                        if (this.ids[n6] == null) {
                            this.ids[n6] = new String(cArray, n9, n10 - n9);
                        }
                        ++n6;
                        n10 = n11 = n4 + 1;
                        n9 = n11;
                        n8 = n11;
                        n7 = n11;
                        n5 = 0;
                        break;
                    }
                    n5 = 3;
                    break;
                }
                case 7: {
                    n5 = n2 == 114 ? n5 + 1 : 0;
                    break;
                }
                case 8: {
                    n5 = n2 == 101 ? n5 + 1 : 0;
                    break;
                }
                case 9: {
                    n5 = n2 == 102 ? n5 + 1 : 0;
                    break;
                }
                case 10: {
                    n5 = n2 == 61 ? n5 + 1 : 0;
                    break;
                }
                case 11: {
                    if (n2 == 34) {
                        ++n5;
                        n11 = n4 + 1;
                        break;
                    }
                    n5 = 0;
                    break;
                }
                case 12: {
                    if (n2 != 34) break;
                    this.ids[n6] = new String(cArray, n11, n4 - n11);
                    n5 = 2;
                    break;
                }
                case 13: {
                    if (Character.isWhitespace((char)n2)) {
                        n5 = 0;
                        break;
                    }
                    if (n2 != 61) break;
                    ++n5;
                    break;
                }
                case 14: {
                    n5 = n2 == 34 ? n5 + 1 : 0;
                    break;
                }
                case 15: {
                    if (n2 != 34) break;
                    n5 = 2;
                    break;
                }
                default: {
                    n5 = 0;
                }
            }
            ++n4;
        }
        if (n7 < n3) {
            n2 = this.parseMnemonics(cArray, n7, n8, stringBuffer);
            n = this.parseMnemonics(cArray, Math.max(n8, n9), n3, stringBuffer);
            if (n == -1) {
                n = n2;
            }
            this.mnemonics[n6] = n;
        } else {
            this.mnemonics[n6] = -1;
        }
        if (this.offsets.length != n6) {
            Point[] pointArray = new Point[n6];
            System.arraycopy(this.offsets, 0, pointArray, 0, n6);
            this.offsets = pointArray;
            String[] stringArray = new String[n6];
            System.arraycopy(this.ids, 0, stringArray, 0, n6);
            this.ids = stringArray;
            int[] nArray = new int[n6 + 1];
            System.arraycopy(this.mnemonics, 0, nArray, 0, n6 + 1);
            this.mnemonics = nArray;
        }
        return stringBuffer.toString();
    }

    int parseMnemonics(char[] cArray, int n, int n2, StringBuffer stringBuffer) {
        int n3 = -1;
        int n4 = n;
        while (n4 < n2) {
            if (cArray[n4] == '&') {
                if (n4 + 1 < n2 && cArray[n4 + 1] == '&') {
                    stringBuffer.append(cArray[n4]);
                    ++n4;
                } else {
                    n3 = stringBuffer.length();
                }
            } else {
                stringBuffer.append(cArray[n4]);
            }
            ++n4;
        }
        return n3;
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if ((n5 & 0x100) != 0) {
            this.layout.setWidth(n3 > 0 ? n3 : -1);
            this.redraw();
        }
        return n5;
    }

    void setFontDescription(int n) {
        super.setFontDescription(n);
        this.layout.setFont(Font.gtk_new(this.display, n));
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        this.layout.setText(this.parse(string));
        this.focusIndex = this.offsets.length > 0 ? 0 : -1;
        this.selection.y = -1;
        this.selection.x = -1;
        boolean bl = (this.state & 0x10) == 0;
        TextStyle textStyle = new TextStyle(null, bl ? this.linkColor : this.disabledColor, null);
        textStyle.underline = true;
        int[] nArray = new int[this.offsets.length * 2];
        int n = 0;
        while (n < this.offsets.length) {
            Point point = this.offsets[n];
            this.layout.setStyle(textStyle, point.x, point.y);
            nArray[n * 2] = point.x;
            nArray[n * 2 + 1] = point.y + 1;
            ++n;
        }
        this.layout.setSegments(nArray);
        TextStyle textStyle2 = new TextStyle(null, null, null);
        textStyle2.underline = true;
        int n2 = 0;
        while (n2 < this.mnemonics.length) {
            int n3 = this.mnemonics[n2];
            if (n3 != -1) {
                this.layout.setStyle(textStyle2, n3, n3);
            }
            ++n2;
        }
        this.redraw();
    }

    void showWidget() {
        super.showWidget();
        this.fixStyle(this.handle);
    }

    int traversalCode(int n, GdkEventKey gdkEventKey) {
        if (this.offsets.length == 0) {
            return 0;
        }
        int n2 = super.traversalCode(n, gdkEventKey);
        if (n == 65289 && this.focusIndex < this.offsets.length - 1) {
            return n2 & 0xFFFFFFEF;
        }
        if (n == 65056 && this.focusIndex > 0) {
            return n2 & 0xFFFFFFF7;
        }
        return n2;
    }
}

