/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSCalendarDate;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSDate;
import org.eclipse.swt.internal.cocoa.NSDatePicker;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTDatePicker;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    static final int MIN_YEAR = 1752;
    static final int MAX_YEAR = 9999;

    public DateTime(Composite composite, int n) {
        super(composite, DateTime.checkStyle(n));
    }

    static int checkStyle(int n) {
        n &= 0xFFFFFCFF;
        n = DateTime.checkBits(n, 65536, 32768, 0x10000000, 0, 0, 0);
        return DateTime.checkBits(n, 32, 128, 1024, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        NSControl nSControl = (NSControl)this.view;
        NSSize nSSize = nSControl.cell().cellSize();
        n3 = (int)Math.ceil(nSSize.width);
        n4 = (int)Math.ceil(nSSize.height);
        if (n3 == 0) {
            n3 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        int n5 = this.getBorderWidth();
        return new Point(n3 += n5 * 2, n4 += n5 * 2);
    }

    void createHandle() {
        NSDatePicker nSDatePicker = (NSDatePicker)new SWTDatePicker().alloc();
        nSDatePicker.init();
        int n = 0;
        int n2 = 0;
        if ((this.style & 0x400) != 0) {
            n = 1;
            n2 = 224;
        } else {
            if ((this.style & 0x80) != 0) {
                int n3 = n2 = (this.style & 0x8000) != 0 ? 12 : 14;
            }
            if ((this.style & 0x20) != 0) {
                n2 = (this.style & 0x8000) != 0 ? 192 : 224;
            }
        }
        nSDatePicker.setDrawsBackground(true);
        nSDatePicker.setDatePickerStyle(n);
        nSDatePicker.setDatePickerElements(n2);
        NSCalendarDate nSCalendarDate = NSCalendarDate.calendarDate();
        nSDatePicker.setDateValue(nSCalendarDate);
        nSDatePicker.setTarget(nSDatePicker);
        nSDatePicker.setAction(OS.sel_sendSelection);
        this.view = nSDatePicker;
    }

    NSFont defaultNSFont() {
        return this.display.datePickerFont;
    }

    void drawBackground(long l, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (l != this.view.id) {
            return;
        }
        this.fillBackground(this.view, nSGraphicsContext, nSRect, -1);
    }

    NSCalendarDate getCalendarDate() {
        NSDate nSDate = ((NSDatePicker)this.view).dateValue();
        return nSDate.dateWithCalendarFormat(null, null);
    }

    public int getDay() {
        this.checkWidget();
        return (int)this.getCalendarDate().dayOfMonth();
    }

    public int getHours() {
        this.checkWidget();
        return (int)this.getCalendarDate().hourOfDay();
    }

    public int getMinutes() {
        this.checkWidget();
        return (int)this.getCalendarDate().minuteOfHour();
    }

    public int getMonth() {
        this.checkWidget();
        return (int)this.getCalendarDate().monthOfYear() - 1;
    }

    String getNameText() {
        return (this.style & 0x80) != 0 ? String.valueOf(this.getHours()) + ":" + this.getMinutes() + ":" + this.getSeconds() : String.valueOf(this.getMonth() + 1) + "/" + this.getDay() + "/" + this.getYear();
    }

    public int getSeconds() {
        this.checkWidget();
        return (int)this.getCalendarDate().secondOfMinute();
    }

    public int getYear() {
        this.checkWidget();
        return (int)this.getCalendarDate().yearOfCommonEra();
    }

    boolean isEventView(long l) {
        return true;
    }

    boolean isFlipped(long l, long l2) {
        if ((this.style & 0x400) != 0) {
            return super.isFlipped(l, l2);
        }
        return true;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n) {
        boolean bl = super.sendKeyEvent(nSEvent, n);
        if (!bl) {
            return bl;
        }
        if (n != 1) {
            return bl;
        }
        if ((this.style & 0x400) == 0) {
            short s = nSEvent.keyCode();
            switch (s) {
                case 36: 
                case 76: {
                    this.sendSelectionEvent(14);
                }
            }
        }
        return bl;
    }

    void sendSelection() {
        NSEvent nSEvent = NSApplication.sharedApplication().currentEvent();
        if (nSEvent != null && (this.style & 0x400) != 0) {
            if (nSEvent.clickCount() == 2L) {
                this.sendSelectionEvent(14);
            } else if (nSEvent.type() == 2L) {
                this.sendSelectionEvent(13);
            }
        } else {
            this.sendSelectionEvent(13);
        }
    }

    void setBackgroundColor(NSColor nSColor) {
        ((NSDatePicker)this.view).setBackgroundColor(nSColor);
    }

    void setBackgroundImage(NSImage nSImage) {
        ((NSDatePicker)this.view).setDrawsBackground(nSImage == null);
    }

    public void setDate(int n, int n2, int n3) {
        this.checkWidget();
        if (n < 1752 || n > 9999) {
            return;
        }
        NSCalendarDate nSCalendarDate = this.getCalendarDate();
        NSCalendarDate nSCalendarDate2 = NSCalendarDate.dateWithYear(n, n2 + 1, n3, nSCalendarDate.hourOfDay(), nSCalendarDate.minuteOfHour(), nSCalendarDate.secondOfMinute(), nSCalendarDate.timeZone());
        if (nSCalendarDate2.yearOfCommonEra() == (long)n && nSCalendarDate2.monthOfYear() == (long)(n2 + 1) && nSCalendarDate2.dayOfMonth() == (long)n3) {
            ((NSDatePicker)this.view).setDateValue(nSCalendarDate2);
        }
    }

    public void setDay(int n) {
        this.checkWidget();
        NSCalendarDate nSCalendarDate = this.getCalendarDate();
        NSCalendarDate nSCalendarDate2 = NSCalendarDate.dateWithYear(nSCalendarDate.yearOfCommonEra(), nSCalendarDate.monthOfYear(), n, nSCalendarDate.hourOfDay(), nSCalendarDate.minuteOfHour(), nSCalendarDate.secondOfMinute(), nSCalendarDate.timeZone());
        if (nSCalendarDate2.yearOfCommonEra() == nSCalendarDate.yearOfCommonEra() && nSCalendarDate2.monthOfYear() == nSCalendarDate.monthOfYear() && nSCalendarDate2.dayOfMonth() == (long)n) {
            ((NSDatePicker)this.view).setDateValue(nSCalendarDate2);
        }
    }

    void setForeground(double[] dArray) {
        NSColor nSColor = dArray == null ? ((this.style & 0x400) != 0 ? NSColor.controlTextColor() : NSColor.textColor()) : NSColor.colorWithDeviceRed(dArray[0], dArray[1], dArray[2], 1.0);
        ((NSDatePicker)this.view).setTextColor(nSColor);
    }

    public void setHours(int n) {
        this.checkWidget();
        if (n < 0 || n > 23) {
            return;
        }
        NSCalendarDate nSCalendarDate = this.getCalendarDate();
        NSCalendarDate nSCalendarDate2 = NSCalendarDate.dateWithYear(nSCalendarDate.yearOfCommonEra(), nSCalendarDate.monthOfYear(), nSCalendarDate.dayOfMonth(), n, nSCalendarDate.minuteOfHour(), nSCalendarDate.secondOfMinute(), nSCalendarDate.timeZone());
        ((NSDatePicker)this.view).setDateValue(nSCalendarDate2);
    }

    public void setMinutes(int n) {
        this.checkWidget();
        if (n < 0 || n > 59) {
            return;
        }
        NSCalendarDate nSCalendarDate = this.getCalendarDate();
        NSCalendarDate nSCalendarDate2 = NSCalendarDate.dateWithYear(nSCalendarDate.yearOfCommonEra(), nSCalendarDate.monthOfYear(), nSCalendarDate.dayOfMonth(), nSCalendarDate.hourOfDay(), n, nSCalendarDate.secondOfMinute(), nSCalendarDate.timeZone());
        ((NSDatePicker)this.view).setDateValue(nSCalendarDate2);
    }

    public void setMonth(int n) {
        this.checkWidget();
        NSCalendarDate nSCalendarDate = this.getCalendarDate();
        NSCalendarDate nSCalendarDate2 = NSCalendarDate.dateWithYear(nSCalendarDate.yearOfCommonEra(), n + 1, nSCalendarDate.dayOfMonth(), nSCalendarDate.hourOfDay(), nSCalendarDate.minuteOfHour(), nSCalendarDate.secondOfMinute(), nSCalendarDate.timeZone());
        if (nSCalendarDate2.yearOfCommonEra() == nSCalendarDate.yearOfCommonEra() && nSCalendarDate2.monthOfYear() == (long)(n + 1) && nSCalendarDate2.dayOfMonth() == nSCalendarDate.dayOfMonth()) {
            ((NSDatePicker)this.view).setDateValue(nSCalendarDate2);
        }
    }

    public void setSeconds(int n) {
        this.checkWidget();
        if (n < 0 || n > 59) {
            return;
        }
        NSCalendarDate nSCalendarDate = this.getCalendarDate();
        NSCalendarDate nSCalendarDate2 = NSCalendarDate.dateWithYear(nSCalendarDate.yearOfCommonEra(), nSCalendarDate.monthOfYear(), nSCalendarDate.dayOfMonth(), nSCalendarDate.hourOfDay(), nSCalendarDate.minuteOfHour(), n, nSCalendarDate.timeZone());
        ((NSDatePicker)this.view).setDateValue(nSCalendarDate2);
    }

    public void setTime(int n, int n2, int n3) {
        this.checkWidget();
        if (n < 0 || n > 23 || n2 < 0 || n2 > 59 || n3 < 0 || n3 > 59) {
            return;
        }
        NSCalendarDate nSCalendarDate = this.getCalendarDate();
        NSCalendarDate nSCalendarDate2 = NSCalendarDate.dateWithYear(nSCalendarDate.yearOfCommonEra(), nSCalendarDate.monthOfYear(), nSCalendarDate.dayOfMonth(), n, n2, n3, nSCalendarDate.timeZone());
        ((NSDatePicker)this.view).setDateValue(nSCalendarDate2);
    }

    public void setYear(int n) {
        this.checkWidget();
        if (n < 1752 || n > 9999) {
            return;
        }
        NSCalendarDate nSCalendarDate = this.getCalendarDate();
        NSCalendarDate nSCalendarDate2 = NSCalendarDate.dateWithYear(n, nSCalendarDate.monthOfYear(), nSCalendarDate.dayOfMonth(), nSCalendarDate.hourOfDay(), nSCalendarDate.minuteOfHour(), nSCalendarDate.secondOfMinute(), nSCalendarDate.timeZone());
        if (nSCalendarDate2.yearOfCommonEra() == (long)n && nSCalendarDate2.monthOfYear() == nSCalendarDate.monthOfYear() && nSCalendarDate2.dayOfMonth() == nSCalendarDate.dayOfMonth()) {
            ((NSDatePicker)this.view).setDateValue(nSCalendarDate2);
        }
    }
}

