/*
 * Decompiled with CFR 0.152.
 */
package javasrc.symtab;

import java.io.Externalizable;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Vector;
import javasrc.symtab.ClassDef;
import javasrc.symtab.ClassDefProxy;
import javasrc.symtab.Definition;
import javasrc.symtab.DummyClass;
import javasrc.symtab.HTMLTag;
import javasrc.symtab.HTMLTagContainer;
import javasrc.symtab.JavaHashtable;
import javasrc.symtab.JavaVector;
import javasrc.symtab.Occurrence;
import javasrc.symtab.ScopedDef;
import javasrc.symtab.SymbolTable;
import javasrc.symtab.TypedDef;
import javasrc.symtab.VariableDef;
import javasrc.symtab.Visitor;

public class MethodDef
extends ScopedDef
implements TypedDef,
Externalizable {
    private ClassDef type = null;
    private JavaVector parameters;
    private JavaVector exceptions;
    private String className;
    private String _uniqueMethodString;

    public Vector getParameters() {
        return this.parameters;
    }

    public Vector getExceptions() {
        return this.exceptions;
    }

    public String getClassName() {
        return this.className;
    }

    void add(ClassDef classDef) {
        if (this.exceptions == null) {
            this.exceptions = new JavaVector();
        }
        this.exceptions.addElement(classDef);
    }

    void add(VariableDef variableDef) {
        if (this.parameters == null) {
            this.parameters = new JavaVector();
        }
        this.parameters.addElement(variableDef);
    }

    String getFullName() {
        if (this._uniqueMethodString != null) {
            return this._uniqueMethodString;
        }
        this._uniqueMethodString = this.getName() + "(";
        if (this.parameters != null) {
            Enumeration enumeration = this.parameters.elements();
            while (enumeration.hasMoreElements()) {
                VariableDef variableDef = (VariableDef)enumeration.nextElement();
                this._uniqueMethodString = this._uniqueMethodString + variableDef.getType().getName();
                if (!enumeration.hasMoreElements()) continue;
                this._uniqueMethodString = this._uniqueMethodString + ",";
            }
        }
        this._uniqueMethodString = this._uniqueMethodString + ")";
        return this._uniqueMethodString;
    }

    int getParamCount() {
        if (this.parameters == null) {
            return 0;
        }
        return this.parameters.size();
    }

    public Definition getType() {
        return this.type;
    }

    Definition lookup(String string, int n, Class clazz) {
        if (n == -1) {
            Definition definition = super.lookup(string, n, clazz);
            if (definition != null) {
                return definition;
            }
            if (this.parameters != null) {
                Enumeration enumeration = this.parameters.elements();
                while (enumeration.hasMoreElements()) {
                    definition = (Definition)enumeration.nextElement();
                    if (!definition.getName().equals(string) || !definition.isA(clazz)) continue;
                    return definition;
                }
            }
        }
        return null;
    }

    public void generateReferences(FileWriter fileWriter) {
        String string = this.getName();
        if (string != null && string.indexOf("~constructor~") >= 0) {
            string = this.className;
        }
        try {
            fileWriter.write("<p class=\"methodReflist\">");
            String string2 = "<p class=\"methodReflistHeader\">Method: <a name=" + this.getFullName() + " href=" + this.getSourceName() + "#" + this.getClassScopeName() + ">" + this.getFullName() + "</a></p>";
            fileWriter.write(string2);
            JavaVector javaVector = this.getReferences();
            Enumeration enumeration = javaVector.elements();
            while (enumeration.hasMoreElements()) {
                Occurrence occurrence = (Occurrence)enumeration.nextElement();
                if (occurrence == null) continue;
                String string3 = this.getOccurrencePath(occurrence) + occurrence.getLinkReference();
                String string4 = "<p class=\"methodRefItem\"><a href=" + string3 + ">" + this.getName() + " in " + occurrence.getPackageName() + "." + occurrence.getClassName() + "." + occurrence.getMethodName() + " (" + occurrence.getFile().getName() + ":" + Integer.toString(occurrence.getLine()) + ")</a></p>\n";
                fileWriter.write(string4);
            }
            fileWriter.write("</p>");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void generateTags(HTMLTagContainer hTMLTagContainer) {
        String string = this.getName();
        if (string != null && string.indexOf("~constructor~") >= 0) {
            string = this.className;
        }
        if (string != null && string.indexOf("~class-init~") >= 0) {
            string = "";
        }
        String string2 = "<a class=\"methodDef\" name=" + this.getClassScopeName() + " href=" + this.getRefName() + "#" + this.getClassScopeName() + ">" + string + "</a>";
        if (this.getOccurrence() == null) {
            return;
        }
        HTMLTag hTMLTag = new HTMLTag(this.getOccurrence(), string, string2);
        hTMLTagContainer.addElement(hTMLTag);
        String string3 = this.getOccurrence().getClassName();
    }

    public HTMLTag getOccurrenceTag(Occurrence occurrence) {
        String string = this.getName();
        if (string != null && string.indexOf("~constructor~") >= 0) {
            string = this.className;
        }
        if (string != null && string.indexOf("~class-init~") >= 0) {
            string = "";
        }
        String string2 = this.getOccurrence().getClassName();
        String string3 = this.getRelativePath(occurrence) + this.getSourceName();
        String string4 = "<a class=\"methodRef\" title=\"" + string2 + "\" " + "href=" + string3 + "#" + this.getClassScopeName() + ">" + string + "</a>";
        HTMLTag hTMLTag = new HTMLTag(occurrence, string, string4);
        return hTMLTag;
    }

    void resolveTypes(SymbolTable symbolTable) {
        ClassDef classDef;
        if (this.parameters != null) {
            this.parameters.resolveTypes(symbolTable);
        }
        if (this.exceptions != null) {
            this.exceptions.resolveTypes(symbolTable);
        }
        if (this.type != null && this.type instanceof DummyClass && (classDef = symbolTable.lookupDummy(this.type)) != null) {
            classDef.addReference(this.type.getOccurrence());
            this.type = classDef;
        }
        super.resolveTypes(symbolTable);
    }

    void setExceptions(JavaVector javaVector) {
        this.exceptions = javaVector;
    }

    String getClassScopeName() {
        ScopedDef scopedDef = this.getParentScope();
        ScopedDef scopedDef2 = scopedDef.getParentScope();
        String string = scopedDef2 instanceof ClassDef ? scopedDef2.getName() + "." + scopedDef.getName() : scopedDef.getName();
        string = string + "." + this.getFullName();
        return string;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getName());
        objectOutput.writeObject(this.getParentScope());
        objectOutput.writeObject(this.getOccurrence());
        ClassDef classDef = this.type;
        if (this.type != null && !(this.type instanceof DummyClass)) {
            classDef = new ClassDefProxy(this.type);
        }
        objectOutput.writeObject(classDef);
        objectOutput.writeObject(this.exceptions);
        objectOutput.writeObject(this.parameters);
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this.setName((String)objectInput.readObject());
        SymbolTable.startReadExternal("MethodDef " + this.getName());
        this.setParentScope((ScopedDef)objectInput.readObject());
        this.setOccurrence((Occurrence)objectInput.readObject());
        this.type = (ClassDef)objectInput.readObject();
        this.exceptions = (JavaVector)objectInput.readObject();
        this.parameters = (JavaVector)objectInput.readObject();
        this.setupFileNames();
        SymbolTable.endReadExternal();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
        this.elements.accept(visitor);
    }

    public String toString() {
        String string = this.getClass().getName() + " [" + this.getQualifiedName() + "]";
        JavaHashtable javaHashtable = this.getElements();
        Enumeration enumeration = javaHashtable.elements();
        while (enumeration.hasMoreElements()) {
            Definition definition = (Definition)enumeration.nextElement();
            string = string + "\n        " + definition;
        }
        return string;
    }

    public MethodDef() {
    }

    MethodDef(String string, Occurrence occurrence, ClassDef classDef, ScopedDef scopedDef) {
        super(string, occurrence, scopedDef);
        this.type = classDef;
    }

    MethodDef(String string, String string2, Occurrence occurrence, ClassDef classDef, ScopedDef scopedDef) {
        this(string, occurrence, classDef, scopedDef);
        this.className = string2 != null ? string2.intern() : string2;
    }
}

