/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import com.centeredwork.xilize.Block;
import com.centeredwork.xilize.Key;
import com.centeredwork.xilize.Modifiers;
import com.centeredwork.xilize.Signature;
import com.centeredwork.xilize.Task;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SigTable
extends Signature {
    private Task task;
    private Block block;
    boolean headerClosed;
    private ArrayList<StringBuilder> headerRows;
    private ArrayList<StringBuilder> rows;
    private ArrayList<StringBuilder> footerRows;
    private static final String ROW_REGEX = "^ *((?:\\(((\\w|[#,-]|\\d)+)\\)|\\{([\\S &&[^}]]+)\\}|\\[([a-zA-Z0-9-]+)\\]|\\{\\{([\\S &&[^}]]+)\\}\\}|\\\\(\\d+)|/(\\d+)|_|-|\\^|~|>|<|=|\\(+|\\)+)*)(\\|.*)$";
    private static final Pattern ROW_PATTERN = Pattern.compile("^ *((?:\\(((\\w|[#,-]|\\d)+)\\)|\\{([\\S &&[^}]]+)\\}|\\[([a-zA-Z0-9-]+)\\]|\\{\\{([\\S &&[^}]]+)\\}\\}|\\\\(\\d+)|/(\\d+)|_|-|\\^|~|>|<|=|\\(+|\\)+)*)(\\|.*)$");
    private static final String CELL_REGEX = "\\|((?:\\(((\\w|[#,-]|\\d)+)\\)|\\{([\\S &&[^}]]+)\\}|\\[([a-zA-Z0-9-]+)\\]|\\{\\{([\\S &&[^}]]+)\\}\\}|\\\\(\\d+)|/(\\d+)|_|-|\\^|~|>|<|=|\\(+|\\)+)* )? *([^\\|]*)";
    private static final Pattern CELL_PATTERN = Pattern.compile("\\|((?:\\(((\\w|[#,-]|\\d)+)\\)|\\{([\\S &&[^}]]+)\\}|\\[([a-zA-Z0-9-]+)\\]|\\{\\{([\\S &&[^}]]+)\\}\\}|\\\\(\\d+)|/(\\d+)|_|-|\\^|~|>|<|=|\\(+|\\)+)* )? *([^\\|]*)");
    private static final String CHILD_CELL_REGEX = "(?:\\|((?:\\(((\\w|[#,-]|\\d)+)\\)|\\{([\\S &&[^}]]+)\\}|\\[([a-zA-Z0-9-]+)\\]|\\{\\{([\\S &&[^}]]+)\\}\\}|\\\\(\\d+)|/(\\d+)|_|-|\\^|~|>|<|=|\\(+|\\)+)* )? *)?(.*)";
    private static final Pattern CHILD_CELL_PATTERN = Pattern.compile("(?:\\|((?:\\(((\\w|[#,-]|\\d)+)\\)|\\{([\\S &&[^}]]+)\\}|\\[([a-zA-Z0-9-]+)\\]|\\{\\{([\\S &&[^}]]+)\\}\\}|\\\\(\\d+)|/(\\d+)|_|-|\\^|~|>|<|=|\\(+|\\)+)* )? *)?(.*)");
    private static String WIDTH_REGEX = "(\\d+(\\*|%)?)|\\*";
    private static Pattern WIDTH_PATTERN = Pattern.compile(" +(" + WIDTH_REGEX + ")\\z");

    SigTable() {
        super("table");
    }

    void setMods(Task task, String string) {
        this.mods = new Modifiers.Table(task, string);
    }

    public String translate(Task task, Block block) {
        this.headerRows = new ArrayList();
        this.rows = new ArrayList();
        this.footerRows = new ArrayList();
        this.task = task;
        this.block = block;
        block.setWriteChildren(false);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table" + this.tagAttributes() + ">" + this.colSpec(block) + "\n");
        if (block.isParent()) {
            for (Block object : block.getChildren()) {
                if (object.isParent()) {
                    this.row(object);
                    continue;
                }
                this.row(object.getLine(0));
            }
        } else {
            for (String string : block.getLines()) {
                this.row(string);
            }
        }
        if (!this.headerRows.isEmpty()) {
            stringBuilder.append("<thead>\n");
            for (StringBuilder stringBuilder2 : this.headerRows) {
                stringBuilder.append((CharSequence)stringBuilder2);
            }
            stringBuilder.append("</thead>\n");
        }
        if (!this.footerRows.isEmpty()) {
            stringBuilder.append("<tfoot>\n");
            for (StringBuilder stringBuilder3 : this.footerRows) {
                stringBuilder.append((CharSequence)stringBuilder3);
            }
            stringBuilder.append("</tfoot>\n");
        }
        if (!this.rows.isEmpty()) {
            stringBuilder.append("<tbody>\n");
            for (StringBuilder stringBuilder4 : this.rows) {
                stringBuilder.append((CharSequence)stringBuilder4);
            }
            stringBuilder.append("</tbody>\n");
        }
        stringBuilder.append("</table>");
        return stringBuilder.toString();
    }

    private void row(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Matcher matcher = ROW_PATTERN.matcher(string);
        if (!matcher.matches()) {
            this.task.warning(this.block.getLineNumber(string), "expeciting a table row");
            return;
        }
        Modifiers.Sig sig = new Modifiers.Sig(this.task, matcher.group(1));
        stringBuilder.append("  <tr" + sig.tagAttributes() + ">\n");
        this.cells(stringBuilder, matcher.group(9));
        stringBuilder.append("  </tr>\n");
        this.addRow(sig, stringBuilder);
    }

    private void addRow(Modifiers modifiers, StringBuilder stringBuilder) {
        if (modifiers.isHeader()) {
            if (this.headerClosed) {
                this.footerRows.add(stringBuilder);
            } else {
                this.headerRows.add(stringBuilder);
            }
        } else {
            this.headerClosed = true;
            this.rows.add(stringBuilder);
        }
    }

    private void row(Block block) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("  <tr" + block.getSignature().getMods().tagAttributes() + ">\n");
        for (Block block2 : block.getChildren()) {
            this.cell(stringBuilder, block2);
        }
        stringBuilder.append("  </tr>\n");
        this.addRow(block.getSignature().getMods(), stringBuilder);
    }

    private void cells(StringBuilder stringBuilder, String string) {
        Matcher matcher = CELL_PATTERN.matcher(string);
        while (matcher.find()) {
            Modifiers.Cell cell = new Modifiers.Cell(this.task, matcher.group(1));
            this.writeCell(stringBuilder, cell.tagAttributes(), matcher.group(9));
        }
    }

    private void writeCell(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append("    <td" + string + ">");
        stringBuilder.append(this.task.markup(string2.trim()));
        stringBuilder.append("</td>\n");
    }

    private void cell(StringBuilder stringBuilder, Block block) {
        if (block.isParent()) {
            stringBuilder.append("    <td" + block.getSignature().tagAttributes() + ">");
            stringBuilder.append('\n');
            for (Block block2 : block.getChildren()) {
                block2.translate();
                stringBuilder.append(block2.getTranslation());
                stringBuilder.append('\n');
            }
            stringBuilder.append("    </td>\n");
        } else {
            if (block.getSignature().getName().equals(this.task.value(Key._UnsignedBlockSigName_))) {
                Signature signature = this.task.getSignature("imo");
                block.setSignature(signature);
            }
            stringBuilder.append("    <td" + block.getSignature().tagAttributes() + ">");
            stringBuilder.append('\n');
            block.translate();
            stringBuilder.append(block.getTranslation());
            stringBuilder.append('\n');
            stringBuilder.append("    </td>\n");
        }
    }

    private String colSpec(Block block) {
        if (block.getLines().isEmpty() || !block.getLine(0).startsWith("&{columns:")) {
            return "";
        }
        ArrayList<String> arrayList = block.getLines();
        StringBuilder stringBuilder = new StringBuilder();
        block.removeLine(0);
        int n = 1;
        while (n < arrayList.size()) {
            String string = arrayList.get(0);
            block.removeLine(0);
            if (string.matches(" *\\} *")) break;
            if (string.indexOf(124) == -1) {
                stringBuilder.append("\n<colgroup");
                stringBuilder.append(SigTable.getColMods(this.task, string));
                stringBuilder.append(" />");
                continue;
            }
            stringBuilder.append("\n<colgroup");
            int n2 = string.indexOf(124);
            if (n2 > 0) {
                stringBuilder.append(SigTable.getColMods(this.task, string.substring(0, n2)));
            }
            stringBuilder.append(">\n");
            n2 = n2 == -1 ? 1 : n2 + 1;
            string = string + " ";
            String[] stringArray = string.substring(n2).split("\\|");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append("  <col");
                if (!stringArray[i].matches(" *")) {
                    stringBuilder.append(SigTable.getColMods(this.task, stringArray[i]));
                }
                stringBuilder.append(" />\n");
            }
            stringBuilder.append("</colgroup>");
        }
        return stringBuilder.toString();
    }

    private static String getColMods(Task task, String string) {
        Object object;
        if ((string = string.trim()).equals("")) {
            return "";
        }
        String string2 = null;
        String string3 = null;
        if (string.matches(WIDTH_REGEX)) {
            string2 = string;
        } else {
            object = WIDTH_PATTERN.matcher(string);
            if (((Matcher)object).find()) {
                string2 = ((Matcher)object).group(1);
                string3 = string.substring(0, ((Matcher)object).start()).trim();
            } else {
                string3 = string;
            }
        }
        object = new Modifiers.TableCol(task, string3, string2);
        return ((Modifiers)object).tagAttributes();
    }
}

