/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import com.centeredwork.xilize.BeanShell;
import com.centeredwork.xilize.Block;
import com.centeredwork.xilize.BlockAssembler;
import com.centeredwork.xilize.BlockReader;
import com.centeredwork.xilize.Files;
import com.centeredwork.xilize.Key;
import com.centeredwork.xilize.Reporter;
import com.centeredwork.xilize.Task;
import com.centeredwork.xilize.TaskDir;
import com.centeredwork.xilize.TaskFile;
import com.centeredwork.xilize.XilizeException;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xilize2
extends TaskFile
implements Runnable {
    private static TaskFile.Master masterTask;
    private Task subtask;
    private ExitCode resultCode = ExitCode.Okay;

    public static void startup(Reporter reporter, BeanShell beanShell, HashMap<String, String> hashMap) {
        if (reporter == null) {
            throw new IllegalArgumentException("reporter is null");
        }
        File file = null;
        if (hashMap != null && hashMap.containsKey(Key._XilizeConfigFile_.name())) {
            file = new File(hashMap.get((Object)Key._XilizeConfigFile_));
        }
        masterTask = new TaskFile.Master(file, reporter, beanShell);
        if (file != null) {
            try {
                masterTask.xilize();
            }
            catch (XilizeException xilizeException) {
                masterTask.error("master task configuration file error, trying to continue", xilizeException);
            }
        }
        masterTask.define(hashMap);
        masterTask.loadSystemProperties();
    }

    public static void shutdown() {
        masterTask = null;
    }

    public static String[] signatureNames() {
        if (masterTask == null) {
            throw new IllegalStateException("master task is null, was startup() called first?");
        }
        return masterTask.sigNames();
    }

    public Xilize2() {
        super(masterTask, null);
        if (masterTask == null) {
            throw new IllegalStateException("master task may not be null, call Xilize2.startup() first");
        }
        this.env = masterTask.getEnv();
        this.env.reset();
    }

    @Override
    public void run() {
        this.resultCode = this.translate();
    }

    public ExitCode translate() {
        File file;
        if (this.subtask == null) {
            this.createTask();
        }
        if (this.getResultCode() != ExitCode.Okay) {
            this.error("aborting");
            return this.getResultCode();
        }
        if (this.subtask == null) {
            this.error("no task defined, aborting");
            return ExitCode.Fatal;
        }
        if (this.subtask instanceof TaskDir && (file = ((TaskDir)this.subtask).getLocalFile("root.xilconfig")) != null) {
            try {
                this.include(0, file);
            }
            catch (XilizeException xilizeException) {
                this.error("problem in root.xilconfig", xilizeException);
                return ExitCode.Fatal;
            }
        }
        try {
            this.subtask.xilize();
        }
        catch (XilizeException xilizeException) {
            this.resultCode = xilizeException.getCode();
        }
        this.subtask = null;
        return this.getResultCode();
    }

    private void createTask() {
        if (this.isDefined(Key._TargetFile_)) {
            this.xilizeFile(this.value(Key._TargetRoot_), this.value(Key._TargetDir_), this.value(Key._TargetFile_));
        } else if (this.isDefined(Key._TargetDir_)) {
            this.xilizeDirectory(this.value(Key._TargetRoot_), this.value(Key._TargetDir_));
        } else if (this.isDefined(Key._TargetBranch_)) {
            this.xilizeBranch(this.value(Key._TargetRoot_), this.value(Key._TargetBranch_));
        } else if (this.isDefined(Key._TargetRoot_)) {
            this.xilizeProject(this.value(Key._TargetRoot_));
        } else {
            this.error("coding error in Xilize2.createTask()");
        }
    }

    public String xilizePhrase(String string) {
        return this.markup(string);
    }

    public String xilizePhrase(String string, String string2, String string3) {
        return null;
    }

    public String xilizeBlocks(String string, String string2, String string3) {
        return null;
    }

    public String xilizeBlocks(String string) {
        BlockReader blockReader = new BlockReader(this, new StringReader(string));
        try {
            this.getRawBlocks(blockReader);
            Block block = new Block();
            new BlockAssembler(this, this.rawBlocks).assemble(block);
            for (Block object2 : block.getChildren()) {
                object2.exec();
            }
            for (Block block2 : block.getChildren()) {
                block2.translate();
            }
            for (Block block3 : block.getChildren()) {
                block3.translateLast();
            }
            StringWriter stringWriter = new StringWriter(string.length() * 2);
            PrintWriter printWriter = new PrintWriter(stringWriter);
            for (Block block4 : block.getChildren()) {
                block4.write(printWriter);
                printWriter.println();
            }
            printWriter.close();
            return stringWriter.toString();
        }
        catch (XilizeException xilizeException) {
            this.error(0, xilizeException.getMessage());
            return null;
        }
    }

    public void xilizeFile(File file, File file2) {
        this.xilizeFile(file.getAbsolutePath(), file2.getParent(), file2.getAbsolutePath());
    }

    public void xilizeFile(String string, String string2, String string3) {
        File file = Files.localFile(string2, string);
        if (!(file = Files.localFile(string3, file.getAbsolutePath())).exists()) {
            this.error("file " + file.getAbsolutePath() + " does not exist");
        }
        this.subtask = this.xilDir(string, string2, false);
        if (this.subtask == null) {
            return;
        }
        TaskDir taskDir = ((TaskDir)this.subtask).getSubDirTask(file.getParentFile());
        if (taskDir != null) {
            taskDir.oneFile(file);
        }
    }

    public void xilizeBranch(File file, File file2) {
        this.xilizeBranch(file.getAbsolutePath(), file2.getAbsolutePath());
    }

    public void xilizeBranch(String string, String string2) {
        this.subtask = this.xilDir(string, string2, true);
    }

    public void xilizeDirectory(File file, File file2) {
        this.xilizeDirectory(file.getAbsolutePath(), file2.getAbsolutePath());
    }

    public void xilizeDirectory(String string, String string2) {
        this.subtask = this.xilDir(string, string2, false);
    }

    public void xilizeProject(File file) {
        this.xilizeProject(file.getAbsolutePath());
    }

    public void xilizeProject(String string) {
        this.xilizeBranch(string, string);
    }

    @Override
    public String getDescription() {
        return "xilize task";
    }

    @Override
    public void xilize() throws XilizeException {
        throw new IllegalStateException("use one of the xilizeXXXX() methods");
    }

    private TaskDir xilDir(String string, String string2, boolean bl) {
        Object object;
        File file = new File(string);
        this.define(Key._Root_, file.getAbsolutePath());
        if (!file.exists()) {
            this.error("directory " + string + " does not exist");
            this.resultCode = ExitCode.Fatal;
            return null;
        }
        if (!file.isDirectory()) {
            this.error(string + " is not a directory");
            this.resultCode = ExitCode.Fatal;
            return null;
        }
        File file2 = Files.localFile(string2, string);
        if (!file2.exists()) {
            this.error("directory " + string2 + " does not exist");
            this.resultCode = ExitCode.Fatal;
            return null;
        }
        if (!file2.isDirectory()) {
            this.error(string2 + " is not a directory");
            this.resultCode = ExitCode.Fatal;
            return null;
        }
        if (!Files.isSubDir(file, file2)) {
            this.error(string2 + " is not a subdirectory of " + string + "");
            this.resultCode = ExitCode.Fatal;
            return null;
        }
        String string3 = Files.trimDirPath(file2);
        String string4 = Files.trimDirPath(file);
        String[] stringArray = null;
        int n = 0;
        if (string4.equals(string3) && bl) {
            n = -1;
        } else if (!string4.equals(string3)) {
            object = string3.substring(string4.length() + 1);
            stringArray = ((String)object).split(Pattern.quote(File.separator));
            n = bl ? -1 : stringArray.length;
        }
        object = new TaskDir(this, file);
        ((TaskDir)object).makeTree(0, n, stringArray);
        return object;
    }

    public ExitCode getResultCode() {
        return this.resultCode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExitCode {
        Okay(0),
        Error(1),
        Usage(2),
        Fatal(3),
        UserHalt(4),
        Io(5);

        private int value;

        public int getExitCode() {
            return this.value;
        }

        private ExitCode(int n2) {
            this.value = n2;
        }
    }
}

