/*
 * Decompiled with CFR 0.152.
 */
package de.java2html;

import de.java2html.converter.JavaSourceConverter;
import de.java2html.converter.JavaSourceConverterProvider;
import de.java2html.options.HorizontalAlignment;
import de.java2html.options.Java2HtmlConversionOptions;
import de.java2html.options.JavaSourceStyleTable;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class Java2HtmlOptionsPanel
extends Panel
implements ItemListener {
    private static final String[] TABS = new String[]{"2", "4", "6", "8"};
    private static final JavaSourceStyleTable[] styles = JavaSourceStyleTable.getPredefinedTables();
    private static final HorizontalAlignment[] alignments = new HorizontalAlignment[]{HorizontalAlignment.LEFT, HorizontalAlignment.CENTER, HorizontalAlignment.RIGHT};
    private Choice chTab = this.createChoice(TABS);
    private Choice chTarget;
    private Choice chStyle;
    private Choice chAlignment;
    private Checkbox cbShowLineNumbers;
    private Checkbox cbShowTableBorder;

    public Java2HtmlOptionsPanel() {
        this.chTab.addItemListener(this);
        Panel pTabs = new Panel();
        pTabs.setLayout(new FlowLayout(0, 2, 2));
        pTabs.add(new Label("Tab-space:", 2));
        pTabs.add(this.chTab);
        this.chTarget = this.createChoice(JavaSourceConverterProvider.getAllConverterNames());
        this.chTarget.addItemListener(this);
        Panel pTarget = new Panel();
        pTarget.setLayout(new FlowLayout(0, 2, 2));
        pTarget.add(new Label("Target:", 2));
        pTarget.add(this.chTarget);
        String[] styleNames = new String[styles.length];
        int i = 0;
        while (i < styles.length) {
            styleNames[i] = styles[i].getName();
            ++i;
        }
        this.chStyle = this.createChoice(styleNames);
        this.chStyle.addItemListener(this);
        String[] alignmentNames = new String[alignments.length];
        int i2 = 0;
        while (i2 < alignments.length) {
            alignmentNames[i2] = alignments[i2].getName();
            ++i2;
        }
        this.chAlignment = this.createChoice(alignmentNames);
        this.chAlignment.addItemListener(this);
        Panel pStyle = new Panel(new FlowLayout(0, 2, 2));
        pStyle.add(new Label("Style:", 2));
        pStyle.add(this.chStyle);
        Panel pAlignment = new Panel(new FlowLayout(0, 2, 2));
        pAlignment.add(new Label("Alignment:", 2));
        pAlignment.add(this.chAlignment);
        this.cbShowLineNumbers = new Checkbox("Line numbers", true);
        this.cbShowLineNumbers.addItemListener(this);
        this.cbShowTableBorder = new Checkbox("Table border", true);
        this.cbShowTableBorder.addItemListener(this);
        this.setLayout(new GridLayout(0, 1, 2, 2));
        this.add(pTarget);
        this.add(pStyle);
        this.add(pTabs);
        this.add(pAlignment);
        this.add(this.cbShowLineNumbers);
        this.add(this.cbShowTableBorder);
        this.initDefaultOptions();
    }

    private void initDefaultOptions() {
        Java2HtmlConversionOptions options = Java2HtmlConversionOptions.getDefault();
        this.setSelectedItem(this.chTab, String.valueOf(options.getTabSize()));
        this.setSelectedItem(this.chStyle, options.getStyleTable().getName());
        this.cbShowLineNumbers.setState(options.isShowLineNumbers());
        this.cbShowTableBorder.setState(options.isShowTableBorder());
        this.setSelectedItem(this.chAlignment, options.getHorizontalAlignment().getName());
    }

    private void setSelectedItem(Choice choice, String value) {
        int i = 0;
        while (i < choice.getItemCount()) {
            if (value.equals(choice.getItem(i))) {
                choice.select(i);
                return;
            }
            ++i;
        }
    }

    private Choice createChoice(String[] values) {
        Choice choice = new Choice();
        int i = 0;
        while (i < values.length) {
            choice.addItem(values[i]);
            ++i;
        }
        return choice;
    }

    public JavaSourceConverter getConverter() {
        String target = this.chTarget.getSelectedItem();
        return JavaSourceConverterProvider.getJavaSourceConverterByName(target);
    }

    public Java2HtmlConversionOptions getConversionOptions() {
        int tabs = 2;
        try {
            tabs = Integer.parseInt(this.chTab.getSelectedItem());
        }
        catch (Exception exception) {}
        Java2HtmlConversionOptions options = Java2HtmlConversionOptions.getDefault();
        options.setTabSize(tabs);
        options.setStyleTable(styles[this.chStyle.getSelectedIndex()]);
        options.setShowLineNumbers(this.cbShowLineNumbers.getState());
        options.setShowTableBorder(this.cbShowTableBorder.getState());
        options.setHorizontalAlignment(alignments[this.chAlignment.getSelectedIndex()]);
        return options;
    }

    public void itemStateChanged(ItemEvent e) {
        this.firePropertyChange(null, null, null);
    }
}

