/*
 * Decompiled with CFR 0.152.
 */
package de.java2html.commandline.test;

import de.java2html.commandline.CommandlineArguments;
import de.java2html.commandline.IllegalCommandlineParametersException;
import de.java2html.test.BasicTestCase;
import junit.framework.Assert;

public class CommandlineArgumentsTest
extends BasicTestCase {
    static /* synthetic */ Class class$0;

    public void testIsFlagSet() throws IllegalCommandlineParametersException {
        CommandlineArguments emptyArguments = new CommandlineArguments(new String[0]);
        Assert.assertFalse((boolean)emptyArguments.isFlagSet("flag"));
        CommandlineArguments arguments = new CommandlineArguments(new String[]{"-parameter", "value", "-flag"});
        Assert.assertTrue((boolean)arguments.isFlagSet("flag"));
        Assert.assertTrue((boolean)arguments.isFlagSet("FLAG"));
        Assert.assertFalse((boolean)arguments.isFlagSet("-flag"));
        Assert.assertFalse((boolean)arguments.isFlagSet("value"));
        Assert.assertFalse((boolean)arguments.isFlagSet("parameter"));
    }

    public void testIsParameterSet() throws IllegalCommandlineParametersException {
        CommandlineArguments emptyArguments = new CommandlineArguments(new String[0]);
        Assert.assertFalse((boolean)emptyArguments.isParameterSet("flag"));
        CommandlineArguments arguments = new CommandlineArguments(new String[]{"-parameter", "value", "-flag"});
        Assert.assertFalse((boolean)arguments.isParameterSet("flag"));
        Assert.assertFalse((boolean)arguments.isParameterSet("FLAG"));
        Assert.assertFalse((boolean)arguments.isParameterSet("-flag"));
        Assert.assertFalse((boolean)arguments.isParameterSet("value"));
        Assert.assertTrue((boolean)arguments.isParameterSet("parameter"));
        Assert.assertTrue((boolean)arguments.isParameterSet("pArAmEtEr"));
    }

    public void testNumbersAreNotFlags() throws IllegalCommandlineParametersException {
        CommandlineArguments arguments = new CommandlineArguments(new String[]{"-flag", "-10"});
        Assert.assertFalse((boolean)arguments.isFlagSet("10"));
        Assert.assertFalse((boolean)arguments.isFlagSet("flag"));
        Assert.assertTrue((boolean)arguments.isParameterSet("flag"));
    }

    public void testDuplicateFlagDefinitionThrowsException() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.java2html.commandline.IllegalCommandlineParametersException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertThrowsException(clazz, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1", "-flag1"});
            }
        });
    }

    public void testDuplicateParameterDefinitionThrowsException() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.java2html.commandline.IllegalCommandlineParametersException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertThrowsException(clazz, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1", "value1", "-flag1", "value1"});
            }
        });
    }

    public void testDuplicateMixedDefinitionThrowsException() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.java2html.commandline.IllegalCommandlineParametersException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertThrowsException(clazz, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1", "-flag1", "value"});
            }
        });
    }

    public void testGetArgumentStringValue() throws IllegalCommandlineParametersException {
        Assert.assertEquals((String)"value", (String)new CommandlineArguments(new String[]{"-flag1", "value"}).getParameterStringValue("flag1"));
        Assert.assertEquals(null, (String)new CommandlineArguments(new String[]{"-flag1", "-flag2"}).getParameterStringValue("flag1"));
    }

    public void testGetRequiredArgumentStringValue() throws IllegalCommandlineParametersException {
        Assert.assertEquals((String)"value", (String)new CommandlineArguments(new String[]{"-flag1", "value"}).getRequiredParameterStringValue("flag1"));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.java2html.commandline.IllegalCommandlineParametersException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertThrowsException(clazz, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1"}).getRequiredParameterStringValue("flag1");
            }
        });
    }

    public void testGetArgumentStringValueWithDefault() throws IllegalCommandlineParametersException {
        Assert.assertEquals((String)"default", (String)new CommandlineArguments(new String[]{"-flag1", "value"}).getParameterStringValue("undefinedFlag", "default"));
        Assert.assertEquals((String)"value", (String)new CommandlineArguments(new String[]{"-definedflag", "value"}).getParameterStringValue("definedflag", "default"));
    }

    public void testGetArgumentIntValueWithDefault() throws IllegalCommandlineParametersException {
        Assert.assertEquals((int)42, (int)new CommandlineArguments(new String[]{"-flag1", "42"}).getParameterPositiveIntValue("flag1", 1));
        Assert.assertEquals((int)1, (int)new CommandlineArguments(new String[0]).getParameterPositiveIntValue("flag1", 1));
    }

    public void testGetArgumentIntValueWithIllegalValue() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.java2html.commandline.IllegalCommandlineParametersException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertThrowsException(clazz, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1", "abc"}).getParameterPositiveIntValue("flag1", 1);
            }
        });
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("de.java2html.commandline.IllegalCommandlineParametersException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertThrowsException(clazz2, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1", "-10"}).getParameterPositiveIntValue("flag1", 1);
            }
        });
    }

    public void testUnsupportedParameterThrowsException() throws IllegalCommandlineParametersException {
        new CommandlineArguments(new String[]{"-flag1", "value1", "-flag2"}).assertContainsNoUnsupportedParameters(new String[]{"flag1"});
        new CommandlineArguments(new String[]{"-flag1", "value1", "-flag2"}).assertContainsNoUnsupportedParameters(new String[]{"FLag1"});
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.java2html.commandline.IllegalCommandlineParametersException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertThrowsException(clazz, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1", "value1", "-flag2", "value2"}).assertContainsNoUnsupportedParameters(new String[]{"flag1"});
            }
        });
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("de.java2html.commandline.IllegalCommandlineParametersException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertThrowsException(clazz2, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1", "value1", "-flag2"}).assertContainsNoUnsupportedParameters(new String[]{"flag2"});
            }
        });
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("de.java2html.commandline.IllegalCommandlineParametersException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertThrowsException(clazz3, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag", "value"}).assertContainsNoUnsupportedParameters(new String[0]);
            }
        });
    }

    public void testUnsupportedFlagThrowsException() throws IllegalCommandlineParametersException {
        new CommandlineArguments(new String[]{"-flag1", "value1", "-flag2"}).assertContainsNoUnsupportedFlags(new String[]{"flag1", "flag2"});
        new CommandlineArguments(new String[]{"-flag1", "value1", "-flag2"}).assertContainsNoUnsupportedFlags(new String[]{"FLag1", "FLag2"});
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.java2html.commandline.IllegalCommandlineParametersException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertThrowsException(clazz, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1", "-flag2"}).assertContainsNoUnsupportedFlags(new String[]{"flag1"});
            }
        });
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("de.java2html.commandline.IllegalCommandlineParametersException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertThrowsException(clazz2, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag1", "-flag2"}).assertContainsNoUnsupportedFlags(new String[]{"flag2"});
            }
        });
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("de.java2html.commandline.IllegalCommandlineParametersException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BasicTestCase.assertThrowsException(clazz3, new BasicTestCase.IBlock(){

            public void execute() throws Exception {
                new CommandlineArguments(new String[]{"-flag"}).assertContainsNoUnsupportedFlags(new String[0]);
            }
        });
    }
}

