/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSFontManager;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    boolean disposed;
    boolean warnings;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    Font systemFont;
    NSMutableParagraphStyle paragraphStyle;
    Point dpi;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;
    static /* synthetic */ Class class$0;

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData deviceData) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (deviceData != null) {
                this.debug = deviceData.debug;
                this.tracking = deviceData.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            if (NSThread.isMainThread()) {
                NSString nSString;
                NSAutoreleasePool nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                NSThread nSThread = NSThread.currentThread();
                NSMutableDictionary nSMutableDictionary = nSThread.threadDictionary();
                id id2 = nSMutableDictionary.objectForKey(nSString = NSString.stringWith("SWT_NSAutoreleasePool"));
                if (id2 == null) {
                    NSNumber nSNumber = NSNumber.numberWithInteger(nSAutoreleasePool.id);
                    nSMutableDictionary.setObject(nSNumber, nSString);
                } else {
                    nSAutoreleasePool.release();
                }
            }
            this.create(deviceData);
            this.init();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData deviceData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.printErrors();
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int n = 0;
            while (n < this.objects.length) {
                if (this.objects[n] == object) {
                    this.objects[n] = null;
                    this.errors[n] = null;
                    return;
                }
                ++n;
            }
        }
    }

    protected void destroy() {
    }

    public Rectangle getBounds() {
        this.checkDevice();
        NSScreen nSScreen = this.getPrimaryScreen();
        NSRect nSRect = nSScreen.frame();
        float f = nSScreen.userSpaceScaleFactor();
        nSRect.x /= f;
        nSRect.y /= f;
        nSRect.width /= f;
        nSRect.height /= f;
        return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData deviceData = new DeviceData();
        deviceData.debug = this.debug;
        deviceData.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int n = 0;
                int n2 = this.objects.length;
                int n3 = 0;
                while (n3 < n2) {
                    if (this.objects[n3] != null) {
                        ++n;
                    }
                    ++n3;
                }
                n3 = 0;
                deviceData.objects = new Object[n];
                deviceData.errors = new Error[n];
                int n4 = 0;
                while (n4 < n2) {
                    if (this.objects[n4] != null) {
                        deviceData.objects[n3] = this.objects[n4];
                        deviceData.errors[n3] = this.errors[n4];
                        ++n3;
                    }
                    ++n4;
                }
            }
        } else {
            deviceData.objects = new Object[0];
            deviceData.errors = new Error[0];
        }
        return deviceData;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        return OS.NSBitsPerPixelFromDepth(this.getPrimaryScreen().depth());
    }

    public Point getDPI() {
        this.checkDevice();
        return this.getScreenDPI();
    }

    NSScreen getPrimaryScreen() {
        NSArray nSArray = NSScreen.screens();
        return new NSScreen(nSArray.objectAtIndex(0));
    }

    public FontData[] getFontList(String string, boolean bl) {
        this.checkDevice();
        if (!bl) {
            return new FontData[0];
        }
        int n = 0;
        NSArray nSArray = NSFontManager.sharedFontManager().availableFontFamilies();
        FontData[] fontDataArray = new FontData[100];
        if (nSArray != null) {
            int n2 = nSArray.count();
            int n3 = 0;
            while (n3 < n2) {
                NSString nSString = new NSString(nSArray.objectAtIndex(n3));
                String string2 = nSString.getString();
                NSArray nSArray2 = NSFontManager.sharedFontManager().availableMembersOfFontFamily(nSString);
                if (nSArray2 != null) {
                    int n4 = nSArray2.count();
                    int n5 = 0;
                    while (n5 < n4) {
                        NSArray nSArray3 = new NSArray(nSArray2.objectAtIndex(n5));
                        String string3 = new NSString(nSArray3.objectAtIndex(0)).getString();
                        int n6 = new NSNumber(nSArray3.objectAtIndex(2)).integerValue();
                        int n7 = new NSNumber(nSArray3.objectAtIndex(3)).integerValue();
                        int n8 = 0;
                        if ((n7 & 1) != 0) {
                            n8 |= 2;
                        }
                        if (n6 == 9) {
                            n8 |= 1;
                        }
                        if (string == null || Compatibility.equalsIgnoreCase(string, string2)) {
                            FontData fontData = new FontData(string2, 0, n8);
                            fontData.nsName = string3;
                            if (n == fontDataArray.length) {
                                FontData[] fontDataArray2 = new FontData[fontDataArray.length + 100];
                                System.arraycopy(fontDataArray, 0, fontDataArray2, 0, fontDataArray.length);
                                fontDataArray = fontDataArray2;
                            }
                            fontDataArray[n++] = fontData;
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
        }
        if (n == fontDataArray.length) {
            return fontDataArray;
        }
        FontData[] fontDataArray3 = new FontData[n];
        System.arraycopy(fontDataArray, 0, fontDataArray3, 0, n);
        return fontDataArray3;
    }

    Point getScreenDPI() {
        NSDictionary nSDictionary = this.getPrimaryScreen().deviceDescription();
        NSValue nSValue = new NSValue(nSDictionary.objectForKey((id)new id((int)OS.NSDeviceResolution())).id);
        NSSize nSSize = nSValue.sizeValue();
        return new Point((int)nSSize.width, (int)nSSize.height);
    }

    public Color getSystemColor(int n) {
        this.checkDevice();
        switch (n) {
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        return this.COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return this.warnings;
    }

    protected void init() {
        this.COLOR_BLACK = new Color(this, 0, 0, 0);
        this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
        this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
        this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
        this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
        this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
        this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
        this.COLOR_GRAY = new Color(this, 192, 192, 192);
        this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
        this.COLOR_RED = new Color(this, 255, 0, 0);
        this.COLOR_GREEN = new Color(this, 0, 255, 0);
        this.COLOR_YELLOW = new Color(this, 255, 255, 0);
        this.COLOR_BLUE = new Color(this, 0, 0, 255);
        this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
        this.COLOR_CYAN = new Color(this, 0, 255, 255);
        this.COLOR_WHITE = new Color(this, 255, 255, 255);
        this.paragraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
        this.paragraphStyle.setAlignment(0);
        this.paragraphStyle.setLineBreakMode(2);
        NSArray nSArray = new NSArray(new NSArray().alloc().init());
        this.paragraphStyle.setTabStops(nSArray);
        nSArray.release();
        boolean bl = System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null;
        float f = bl ? NSFont.smallSystemFontSize() : NSFont.systemFontSize();
        Point point = this.dpi = this.getDPI();
        Point point2 = this.getScreenDPI();
        NSFont nSFont = NSFont.systemFontOfSize(f * (float)point.y / (float)point2.y);
        nSFont.retain();
        this.systemFont = Font.cocoa_new(this, nSFont);
    }

    public abstract int internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(int var1, GCData var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    public boolean loadFont(String string) {
        boolean[] blArray;
        byte[] byArray;
        this.checkDevice();
        if (string == null) {
            SWT.error(4);
        }
        boolean bl = false;
        NSString nSString = NSString.stringWith(string);
        int n = nSString.fileSystemRepresentation();
        if (n != 0 && OS.FSPathMakeRef(n, byArray = new byte[80], blArray = new boolean[1]) == 0) {
            bl = OS.ATSFontActivateFromFileReference(byArray, 2, 0, 0, 0, null) == 0;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int n = 0;
            while (n < this.objects.length) {
                if (this.objects[n] == null) {
                    this.objects[n] = object;
                    this.errors[n] = new Error();
                    return;
                }
                ++n;
            }
            Object[] objectArray = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
            objectArray[this.objects.length] = object;
            this.objects = objectArray;
            Error[] errorArray = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, errorArray, 0, this.errors.length);
            errorArray[this.errors.length] = new Error();
            this.errors = errorArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printErrors() {
        if (!DEBUG) {
            return;
        }
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                if (this.objects == null || this.errors == null) {
                    return;
                }
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                while (n12 < this.objects.length) {
                    Object object2 = this.objects[n12];
                    if (object2 != null) {
                        ++n;
                        if (object2 instanceof Color) {
                            ++n2;
                        }
                        if (object2 instanceof Cursor) {
                            ++n3;
                        }
                        if (object2 instanceof Font) {
                            ++n4;
                        }
                        if (object2 instanceof GC) {
                            ++n5;
                        }
                        if (object2 instanceof Image) {
                            ++n6;
                        }
                        if (object2 instanceof Path) {
                            ++n7;
                        }
                        if (object2 instanceof Pattern) {
                            ++n8;
                        }
                        if (object2 instanceof Region) {
                            ++n9;
                        }
                        if (object2 instanceof TextLayout) {
                            ++n10;
                        }
                        if (object2 instanceof Transform) {
                            ++n11;
                        }
                    }
                    ++n12;
                }
                if (n != 0) {
                    String string = "Summary: ";
                    if (n2 != 0) {
                        string = String.valueOf(string) + n2 + " Color(s), ";
                    }
                    if (n3 != 0) {
                        string = String.valueOf(string) + n3 + " Cursor(s), ";
                    }
                    if (n4 != 0) {
                        string = String.valueOf(string) + n4 + " Font(s), ";
                    }
                    if (n5 != 0) {
                        string = String.valueOf(string) + n5 + " GC(s), ";
                    }
                    if (n6 != 0) {
                        string = String.valueOf(string) + n6 + " Image(s), ";
                    }
                    if (n7 != 0) {
                        string = String.valueOf(string) + n7 + " Path(s), ";
                    }
                    if (n8 != 0) {
                        string = String.valueOf(string) + n8 + " Pattern(s), ";
                    }
                    if (n9 != 0) {
                        string = String.valueOf(string) + n9 + " Region(s), ";
                    }
                    if (n10 != 0) {
                        string = String.valueOf(string) + n10 + " TextLayout(s), ";
                    }
                    if (n11 != 0) {
                        string = String.valueOf(string) + n11 + " Transforms(s), ";
                    }
                    if (string.length() != 0) {
                        string = string.substring(0, string.length() - 2);
                        System.out.println(string);
                    }
                    int n13 = 0;
                    while (n13 < this.errors.length) {
                        if (this.errors[n13] != null) {
                            this.errors[n13].printStackTrace(System.out);
                        }
                        ++n13;
                    }
                }
            }
        }
    }

    protected void release() {
        if (this.paragraphStyle != null) {
            this.paragraphStyle.release();
        }
        this.paragraphStyle = null;
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
        this.systemFont = null;
        if (this.COLOR_BLACK != null) {
            this.COLOR_BLACK.dispose();
        }
        if (this.COLOR_DARK_RED != null) {
            this.COLOR_DARK_RED.dispose();
        }
        if (this.COLOR_DARK_GREEN != null) {
            this.COLOR_DARK_GREEN.dispose();
        }
        if (this.COLOR_DARK_YELLOW != null) {
            this.COLOR_DARK_YELLOW.dispose();
        }
        if (this.COLOR_DARK_BLUE != null) {
            this.COLOR_DARK_BLUE.dispose();
        }
        if (this.COLOR_DARK_MAGENTA != null) {
            this.COLOR_DARK_MAGENTA.dispose();
        }
        if (this.COLOR_DARK_CYAN != null) {
            this.COLOR_DARK_CYAN.dispose();
        }
        if (this.COLOR_GRAY != null) {
            this.COLOR_GRAY.dispose();
        }
        if (this.COLOR_DARK_GRAY != null) {
            this.COLOR_DARK_GRAY.dispose();
        }
        if (this.COLOR_RED != null) {
            this.COLOR_RED.dispose();
        }
        if (this.COLOR_GREEN != null) {
            this.COLOR_GREEN.dispose();
        }
        if (this.COLOR_YELLOW != null) {
            this.COLOR_YELLOW.dispose();
        }
        if (this.COLOR_BLUE != null) {
            this.COLOR_BLUE.dispose();
        }
        if (this.COLOR_MAGENTA != null) {
            this.COLOR_MAGENTA.dispose();
        }
        if (this.COLOR_CYAN != null) {
            this.COLOR_CYAN.dispose();
        }
        if (this.COLOR_WHITE != null) {
            this.COLOR_WHITE.dispose();
        }
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
    }

    public void setWarnings(boolean bl) {
        this.checkDevice();
        this.warnings = bl;
    }
}

