/*
 * Decompiled with CFR 0.152.
 */
package javasrc.symtab;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import javasrc.symtab.ClassDef;
import javasrc.symtab.HTMLTag;
import javasrc.symtab.HTMLTagContainer;
import javasrc.symtab.JavaVector;
import javasrc.symtab.Occurrence;
import javasrc.symtab.PackageDef;
import javasrc.symtab.ScopedDef;
import javasrc.symtab.SymbolTable;
import javasrc.symtab.Taggable;
import javasrc.symtab.Visitor;

public abstract class Definition
implements Taggable,
Serializable {
    private Occurrence definition;
    private ScopedDef parentScope;
    private JavaVector references = new JavaVector();
    private String name;
    private String _sourceName;
    private String _refName;

    public String getSourceName() {
        return this._sourceName;
    }

    public String getRefName() {
        return this._refName;
    }

    protected void setupFileNames() {
        this.setupFileNames(this.definition);
    }

    private void setupFileNames(Occurrence occurrence) {
        if (occurrence != null && occurrence.getFile() != null) {
            String string = occurrence.getFile().toString();
            String string2 = string.substring(string.lastIndexOf(File.separatorChar) + 1, string.length());
            string2 = string2.replace('.', '_');
            this._refName = string2 + "_ref.html";
            this._sourceName = string2 + ".html";
            this._refName = this._refName.intern();
            this._sourceName = this._sourceName.intern();
        }
    }

    void addReference(Occurrence occurrence) {
        if (occurrence != null) {
            occurrence.setDefinition(this);
            this.references.addElement(occurrence);
            SymbolTable.addFileReference(occurrence);
        }
    }

    public abstract HTMLTag getOccurrenceTag(Occurrence var1);

    String getDef() {
        if (this.definition != null) {
            return this.definition.getLocation();
        }
        return "";
    }

    protected void setName(String string) {
        this.name = string;
    }

    public String getName() {
        if (this.name == null) {
            return "~NO NAME~";
        }
        return this.name;
    }

    public Occurrence getOccurrence() {
        if (this.definition != null && this.definition.getPackageName() == null) {
            this.definition.setPackageName(this.getPackageName());
        }
        return this.definition;
    }

    protected void setOccurrence(Occurrence occurrence) {
        this.definition = occurrence;
    }

    public ScopedDef getParentScope() {
        return this.parentScope;
    }

    public String getQualifiedName() {
        String string = this.name;
        if (this.name == null) {
            string = "~NO NAME~";
        }
        if (this.getParentScope() != null && !this.getParentScope().isDefaultOrBaseScope()) {
            return this.getParentScope().getQualifiedName() + "." + string;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    String getPackageName() {
        var1_1 = this.getParentScope();
        if (var1_1 != null) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.getParentScope();
lbl5:
            // 2 sources

            ** while (!(var1_1 instanceof PackageDef) && var1_1.getParentScope() != null)
        }
lbl6:
        // 1 sources

        return var1_1.getName();
    }

    String getScopedClassName() {
        ScopedDef scopedDef = this.getParentScope();
        if (!(scopedDef instanceof ClassDef)) {
            return this.getName();
        }
        String string = scopedDef.getScopedClassName() + "." + this.getName();
        return string;
    }

    public String getPackagePath() {
        String string = this.getPackageName();
        if (string != null) {
            string = string.replace('.', File.separatorChar);
        }
        return string;
    }

    String getRelativePath(Occurrence occurrence) {
        String string = "";
        String string2 = null;
        if (occurrence != null) {
            string2 = occurrence.getPackageName();
        }
        if (this.getPackageName() != null && string2 != null && !this.getPackageName().equals(string2)) {
            String string3 = this.getPackagePath();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            String string4 = "";
            int n = 0;
            n = stringTokenizer.countTokens();
            int n2 = 0;
            while (n2 < n) {
                string4 = string4 + ".." + File.separatorChar;
                ++n2;
            }
            string = string4 + string3 + File.separatorChar;
        }
        return string;
    }

    String getOccurrencePath(Occurrence occurrence) {
        String string = occurrence.getPackageName();
        String string2 = "";
        if (this.getPackageName() != null && string != null && !this.getPackageName().equals(string)) {
            String string3 = occurrence.getPackageName().replace('.', File.separatorChar);
            String string4 = this.getPackageName();
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ".");
            String string5 = "";
            int n = 0;
            n = stringTokenizer.countTokens();
            int n2 = 0;
            while (n2 < n) {
                string5 = string5 + ".." + File.separatorChar;
                ++n2;
            }
            string2 = string5 + string3 + File.separatorChar;
        }
        return string2;
    }

    boolean isSuperClassOf(Definition definition) {
        return false;
    }

    public JavaVector getReferences() {
        return this.references;
    }

    Definition lookup(String string, Class clazz) {
        return this.lookup(string, -1, clazz);
    }

    Definition lookup(String string, int n, Class clazz) {
        throw new IllegalArgumentException("Can't lookup in a " + this.getClass());
    }

    public abstract void generateTags(HTMLTagContainer var1);

    public void accept(Visitor visitor) {
    }

    public void generateReferences(FileWriter fileWriter) {
    }

    void resolveTypes(SymbolTable symbolTable) {
    }

    void resolveRefs(SymbolTable symbolTable) {
    }

    void setParentScope(ScopedDef scopedDef) {
        this.parentScope = scopedDef;
    }

    String getClassScopeName() {
        return this.getName();
    }

    protected boolean isA(Class clazz) {
        if (clazz == null) {
            return true;
        }
        return this.getClass() == clazz;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        JavaVector javaVector = this.references;
        this.references = null;
        objectOutputStream.defaultWriteObject();
        this.references = javaVector;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.getQualifiedName() + "]";
    }

    public Definition() {
    }

    Definition(String string, Occurrence occurrence, ScopedDef scopedDef) {
        this();
        this.definition = occurrence;
        this.parentScope = scopedDef;
        this.name = string != null ? string.intern() : string;
        this.setupFileNames(occurrence);
    }
}

