/*
 * Decompiled with CFR 0.152.
 */
package javasrc.symtab;

import java.io.File;
import java.util.StringTokenizer;
import javasrc.symtab.Occurrence;
import javasrc.util.JSComparable;

public class HTMLTag
implements JSComparable {
    private File file;
    private int line;
    private int startColumn;
    private int endColumn;
    private int charNum = 0;
    private String replaceText;
    private String packageName;
    private int length;
    private boolean isComment = false;
    private int numBreaks;
    private int origLength;

    public int getLine() {
        return this.line;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public File getFile() {
        return this.file;
    }

    public String getText() {
        return this.replaceText;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isComment() {
        return this.isComment;
    }

    public int getNumBreaks() {
        return this.numBreaks;
    }

    public int getOrigLength() {
        return this.origLength;
    }

    public String toString() {
        return "HTMLTag [" + this.file + "," + this.line + "," + this.startColumn + "-" + this.endColumn + "," + this.replaceText + "]";
    }

    public int compareTo(Object object) {
        HTMLTag hTMLTag = (HTMLTag)object;
        if (this.getLine() < hTMLTag.getLine()) {
            return -1;
        }
        if (this.getLine() > hTMLTag.getLine()) {
            return 1;
        }
        if (this.getStartColumn() < hTMLTag.getStartColumn()) {
            return -1;
        }
        if (this.getStartColumn() > hTMLTag.getStartColumn()) {
            return 1;
        }
        return 0;
    }

    HTMLTag(Occurrence occurrence, String string, String string2) {
        this.file = occurrence.getFile();
        this.line = occurrence.getLine();
        this.startColumn = occurrence.getColumn();
        this.endColumn = this.startColumn + string.length() - 1;
        this.replaceText = string2;
        this.packageName = occurrence.getPackageName();
        this.numBreaks = 0;
        if (string.indexOf("\r\n") > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
            this.numBreaks = Math.max(stringTokenizer.countTokens() - 1, 1);
        }
        this.origLength = string.length();
    }

    HTMLTag(File file, int n, int n2, String string, String string2, String string3) {
        this.file = file;
        this.line = n;
        this.startColumn = n2;
        this.charNum = this.charNum;
        this.endColumn = this.startColumn + string2.length() - 1;
        this.replaceText = string3;
        this.packageName = string;
        this.numBreaks = 0;
        if (string2.indexOf("\r\n") > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\r\n");
            this.numBreaks = Math.max(stringTokenizer.countTokens() - 1, 1);
        }
        this.origLength = string2.length();
    }

    HTMLTag(File file, int n, int n2, String string, int n3) {
        this.file = file;
        this.line = n;
        this.startColumn = n2;
        this.charNum = this.charNum;
        this.length = n3;
        this.packageName = string;
        this.isComment = true;
    }
}

