/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import com.centeredwork.xilize.CatalogListener;
import com.centeredwork.xilize.Key;
import com.centeredwork.xilize.TaskDir;
import com.centeredwork.xilize.TaskFile;
import java.util.ArrayList;

public class Catalog
implements CatalogListener {
    private ArrayList<CatalogListener> listeners = new ArrayList();
    private String idPrefix;
    private int idCount;

    public Catalog(TaskFile taskFile) {
        TaskDir taskDir;
        this.idPrefix = taskFile.value(Key._IdPrefix_);
        if (this.idPrefix.equals("") && taskFile.parentDir() != null) {
            taskFile.error("key _IdPrefix_ has been undefined, catalog broken");
        }
        if ((taskDir = taskFile.parentDir()) != null) {
            this.addListener(taskDir.getCatalog());
        }
    }

    public void register(TaskFile taskFile, Item item) {
        for (CatalogListener catalogListener : this.listeners) {
            catalogListener.entry(taskFile, item);
        }
    }

    public boolean hasListener(TaskFile taskFile, Item item) {
        for (CatalogListener catalogListener : this.listeners) {
            if (!catalogListener.hasInterest(taskFile, item)) continue;
            return true;
        }
        return false;
    }

    public void addListener(CatalogListener catalogListener) {
        if (catalogListener != null) {
            this.listeners.add(catalogListener);
        }
    }

    public void removeListener(CatalogListener catalogListener) {
        this.listeners.remove(catalogListener);
    }

    public String uniqueId() {
        ++this.idCount;
        return this.idPrefix + this.idCount;
    }

    public void entry(TaskFile taskFile, Item item) {
        this.register(taskFile, item);
    }

    public boolean hasInterest(TaskFile taskFile, Item item) {
        return this.hasListener(taskFile, item);
    }

    public static interface Item {
        public String getId();

        public String getText();

        public String getExtra();

        public int getLevel();
    }
}

