/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import com.centeredwork.xilize.Block;
import com.centeredwork.xilize.Catalog;
import com.centeredwork.xilize.CatalogListener;
import com.centeredwork.xilize.Signature;
import com.centeredwork.xilize.Task;
import com.centeredwork.xilize.TaskFile;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SigToc
extends Signature
implements CatalogListener {
    private static final String HEADER_ID = "toc_entry";
    private static final String TOC_CLASS = "toc";
    private int minlevel = 1;
    private int maxlevel = 6;
    private String listtype = "*";
    private boolean open = true;
    private ArrayList<String> entries;
    private static final Pattern PATTERN = Pattern.compile(" *(?:(\\d)(?: +(\\d)(?: +(\\*|#))?)?)? *");

    public SigToc() {
        super(TOC_CLASS);
    }

    public String translate(Task task, Block block) {
        this.entries = new ArrayList();
        task.addCatalogListener(this);
        Matcher matcher = PATTERN.matcher(block.linesAsString());
        if (matcher.matches()) {
            if (matcher.group(1) != null) {
                this.minlevel = new Integer(matcher.group(1));
                if (matcher.group(2) != null) {
                    this.maxlevel = new Integer(matcher.group(2));
                    if (matcher.group(3) != null) {
                        this.listtype = matcher.group(3);
                    }
                }
            }
        } else {
            task.error(block.getLineNumber(), "invalid TOC specification, using defaults");
        }
        return null;
    }

    public String translateLast(Task task, Block block) {
        if (this.entries.size() == 0) {
            task.warning(block.getLineNumber(), "TOC is empty");
            return "";
        }
        int n = block.getLineNumber();
        Block block2 = new Block(task, n, this.entries.get(0));
        for (int i = 1; i < this.entries.size(); ++i) {
            block2.addLine(n + i, this.entries.get(i));
        }
        block2.translate();
        this.getMods().setDefaultCssClass(TOC_CLASS);
        block2.setTranslation(this.insertAttributes(block2.getTranslation()));
        return block2.getTranslation();
    }

    private boolean isInteresting(int n) {
        if (!this.open) {
            return false;
        }
        if (n < this.minlevel) {
            this.open = false;
            return false;
        }
        return n <= this.maxlevel;
    }

    public boolean hasInterest(TaskFile taskFile, Catalog.Item item) {
        return this.isInteresting(item.getLevel());
    }

    public void entry(TaskFile taskFile, Catalog.Item item) {
        int n = item.getLevel();
        if (!this.isInteresting(n)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = this.minlevel - 1; i < n; ++i) {
            stringBuilder.append(this.listtype);
        }
        stringBuilder.append(' ');
        stringBuilder.append("<a href=\"#" + item.getId() + "\">");
        stringBuilder.append(item.getText());
        stringBuilder.append("</a>");
        this.entries.add(stringBuilder.toString());
    }
}

