/*
 * Decompiled with CFR 0.152.
 */
package com.centeredwork.xilize;

import com.centeredwork.xilize.CatalogListener;
import com.centeredwork.xilize.Files;
import com.centeredwork.xilize.Key;
import com.centeredwork.xilize.Task;
import com.centeredwork.xilize.TaskFile;
import com.centeredwork.xilize.Xilize2;
import com.centeredwork.xilize.XilizeException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDir
extends TaskFile {
    public static final int ALL = -1;
    protected String relProjectRoot = "";
    private ArrayList<TaskFile> sources = new ArrayList();
    private ArrayList<TaskDir> subdirs;
    private ArrayList<String> ordering;
    private int depth;
    private boolean root;
    private static Pattern outfilePattern = Pattern.compile("^(.*\\.)xil$");

    public TaskDir(Task task, File file) {
        super(task, file);
        Object object;
        Object object2;
        Object object3;
        if (task instanceof Xilize2 || this.getLocalFile("root.xilconfig") != null) {
            this.root = true;
        }
        this.report(this.file.toString());
        if (this.isNatural()) {
            this.naturalInit();
        }
        this.define(Key._DirLabel_, this.file.getName());
        File file2 = this.getLocalFile("dir.xilconfig");
        if (file2 != null) {
            try {
                this.include(0, file2);
            }
            catch (XilizeException xilizeException) {
                this.error("problem in dir.xilconfig", xilizeException);
            }
        }
        this.define(Key._DirPath_, this.file.getAbsolutePath());
        this.define(Key._DirName_, this.file.getName());
        if (!this.isRoot()) {
            object3 = this.value(Key._DirLabelSeparator_);
            object2 = this.value(Key._DirLabel_);
            object = this.value(Key._DirLabelList_);
            String[] stringArray = ((String)object).split(Pattern.quote((String)object3));
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.value("_ProjectRoot_");
            stringBuilder.append("[\"" + stringArray[0] + "\":" + string + "index.html]");
            for (int i = 1; i < stringArray.length; ++i) {
                string = string.substring(3);
                stringBuilder.append((String)object3);
                stringBuilder.append("[\"" + stringArray[i] + "\":" + string + "index.html]");
            }
            stringBuilder.append((String)object3);
            stringBuilder.append(this.value(Key._DirLabel_));
            this.define(Key._DirLabelListLinked_, stringBuilder.toString());
            this.defineAppend(Key._DirLabelList_, (String)object3 + (String)object2);
        } else {
            this.define(Key._DirLabelList_, this.value(Key._DirLabel_));
            this.define(Key._DirLabelListLinked_, this.value(Key._DirLabel_));
        }
        object3 = Files.listFiles(this.file, ".*\\.bsh$");
        object2 = ((ArrayList)object3).iterator();
        while (object2.hasNext()) {
            object = (File)object2.next();
            this.getBsh().source(this, (File)object);
        }
    }

    public boolean isRoot() {
        return this.root;
    }

    private void naturalInit() {
        if (this.isRoot()) {
            this.define(Key._ProjectRoot_, "./");
        } else {
            this.defineAppend(Key._ProjectRoot_, "../");
        }
        this.natIncDef(Key.commoninc, "common.xilinc");
        this.natIncDef(Key.headerinc, "header.xilinc");
        this.natIncDef(Key.footerinc, "footer.xilinc");
        ArrayList<File> arrayList = Files.listFiles(this.file, ".*\\.css");
        File file = new File(this.file, "default.css");
        if (arrayList.contains(file)) {
            this.define(Key.css, "default.css");
        } else if (arrayList.size() == 1) {
            this.define(Key.css, arrayList.get(0).getName());
        } else {
            this.defineNaturally(Key.css);
        }
    }

    protected void defineNaturally(Key key) {
        if (this.parentHasDefined(key)) {
            this.define(key, "../" + this.value(key));
        }
    }

    private void natIncDef(Key key, String string) {
        File file = this.getLocalFile(string);
        if (file == null) {
            this.defineNaturally(key);
        } else {
            this.define(key, file.getName());
        }
    }

    @Override
    public void xilize() throws XilizeException {
        if (this.getSources() != null) {
            File file = this.getLocalFile("page.xilconfig");
            if (file == null) {
                ArrayList<File> object2 = Files.listFiles(this.file, ".*\\.xil$");
                this.ordering = new ArrayList(object2.size());
                for (Object object : object2) {
                    this.getOrdering().add(((File)object).getName());
                }
            } else {
                try {
                    String[] iOException = Files.read(file).replaceAll("[ \t]+", "").split("\\s+");
                    this.ordering = new ArrayList<String>(Arrays.asList(iOException));
                }
                catch (IOException iOException) {
                    this.error("reading page order file", iOException);
                }
            }
            for (TaskFile taskFile : this.sources) {
                Object object;
                object = this.value(Key._OutputExtension_);
                String string = taskFile.file.getName();
                int n = this.getOrdering().indexOf(string);
                this.define(Key._PagesTotal_, String.valueOf(this.getOrdering().size()));
                if (n != -1) {
                    this.define(Key._PageNumber_, String.valueOf(n + 1));
                    if (this.getOrdering().size() != 1) {
                        if (this.getOrdering().size() == 2) {
                            if (n == 0) {
                                taskFile.define(Key._Prev_, this.in2out(this.getOrdering().get(1), (String)object));
                                taskFile.define(Key._Next_, this.in2out(this.getOrdering().get(1), (String)object));
                            } else {
                                taskFile.define(Key._Prev_, this.in2out(this.getOrdering().get(0), (String)object));
                                taskFile.define(Key._Next_, this.in2out(this.getOrdering().get(0), (String)object));
                            }
                        } else if (n == 0) {
                            taskFile.define(Key._Prev_, this.in2out(this.getOrdering().get(this.getOrdering().size() - 1), (String)object));
                            taskFile.define(Key._Next_, this.in2out(this.getOrdering().get(1), (String)object));
                        } else if (n == this.getOrdering().size() - 1) {
                            taskFile.define(Key._Prev_, this.in2out(this.getOrdering().get(this.getOrdering().size() - 2), (String)object));
                            taskFile.define(Key._Next_, this.in2out(this.getOrdering().get(0), (String)object));
                        } else {
                            taskFile.define(Key._Prev_, this.in2out(this.getOrdering().get(n - 1), (String)object));
                            taskFile.define(Key._Next_, this.in2out(this.getOrdering().get(n + 1), (String)object));
                        }
                    }
                }
                taskFile.xilize();
            }
        }
        if (this.getSubdirs() != null) {
            for (TaskDir taskDir : this.subdirs) {
                taskDir.xilize();
            }
        }
    }

    private String in2out(String string, String string2) {
        return outfilePattern.matcher(string).replaceAll("$1" + string2);
    }

    void makeTree(int n, int n2, String[] stringArray) {
        String string;
        int file;
        Object object;
        ArrayList<File> arrayList;
        this.depth = n;
        if (stringArray == null || n >= stringArray.length) {
            arrayList = Files.listFiles(this.file, ".*\\.xil$");
            for (File object22 : arrayList) {
                this.getSources().add(new TaskFile(this, object22));
            }
        }
        arrayList = null;
        arrayList = stringArray == null || n >= stringArray.length ? Files.listDirs(this.file, ".*") : Files.listDirs(this.file, Pattern.quote(stringArray[n]));
        if (arrayList.size() == 0) {
            return;
        }
        String string2 = this.value(Key._DirInclude_);
        String string3 = this.value(Key._DirExclude_);
        if (!string2.equals("")) {
            object = string2.split("\\s*,+\\s*");
            file = 0;
            while (file < arrayList.size()) {
                string = arrayList.get(file).getName();
                if (!this.contains((String[])object, arrayList.get(file).getName())) {
                    arrayList.remove(file);
                    continue;
                }
                ++file;
            }
        }
        if (!string3.equals("")) {
            object = string3.split("\\s*,+\\s*");
            file = 0;
            while (file < arrayList.size()) {
                string = arrayList.get(file).getName();
                if (this.contains((String[])object, arrayList.get(file).getName())) {
                    arrayList.remove(file);
                    continue;
                }
                ++file;
            }
        }
        this.subdirs = new ArrayList(arrayList.size());
        for (File stringBuilder : arrayList) {
            this.getSubdirs().add(new TaskDir(this, stringBuilder));
        }
        object = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        string = this.value(Key._SubDirListSeparator_);
        for (TaskDir taskDir : this.subdirs) {
            ((StringBuilder)object).append(taskDir.value(Key._DirLabel_) + string);
            stringBuilder.append("[\"" + taskDir.value(Key._DirLabel_) + "\":" + taskDir.value(Key._DirName_) + "/index.html]" + string);
        }
        this.define(Key._SubDirList_, ((StringBuilder)object).toString().trim());
        this.define(Key._SubDirListLinked_, stringBuilder.substring(0, stringBuilder.length() - string.length() + 1));
        if (n2 != 0 && (n2 <= 0 || n < n2)) {
            for (TaskDir taskDir : this.subdirs) {
                taskDir.makeTree(n + 1, n2, stringArray);
            }
        }
    }

    @Override
    public String getDescription() {
        return "directory " + this.getPath();
    }

    public File getLocalFile(String string) {
        File file = new File(this.file, string);
        return file.exists() ? file : null;
    }

    public ArrayList<TaskFile> getSources() {
        return this.sources;
    }

    public int pageCount() {
        return this.sources == null ? 0 : this.sources.size();
    }

    public ArrayList<TaskDir> getSubdirs() {
        return this.subdirs;
    }

    public boolean hasSubDirs() {
        return this.subdirs == null ? false : this.subdirs.size() != 0;
    }

    public ArrayList<String> getOrdering() {
        return this.ordering;
    }

    public String pageListLinked(Task task) {
        int n = new Integer(task.value(Key._PageNumber_));
        String string = this.value(Key._OutputExtension_);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i <= this.ordering.size(); ++i) {
            if (i == n) {
                stringBuilder.append("%(curpage) " + i + "%");
            } else {
                stringBuilder.append("\"" + i + "\":" + this.in2out(this.ordering.get(i - 1), string));
            }
            stringBuilder.append(' ');
        }
        return stringBuilder.toString().trim();
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    TaskDir getSubDirTask(File file) {
        if (this.file.equals(file)) {
            return this;
        }
        for (TaskDir taskDir : this.subdirs) {
            TaskDir taskDir2 = taskDir.getSubDirTask(file);
            if (taskDir2 == null) continue;
            return taskDir2;
        }
        return null;
    }

    void oneFile(File file) {
        this.sources = new ArrayList();
        this.sources.add(new TaskFile(this, file));
    }

    CatalogListener getCatalog() {
        return this.catalog;
    }

    private boolean contains(String[] stringArray, Object object) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(object)) continue;
            return true;
        }
        return false;
    }
}

