/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class PDFPrintPage
implements Printable {
    private PDFFile file;
    private PrinterJob pjob;
    private JDialog pd;
    private JLabel pagenumlabel;
    private JButton cancel;

    public PDFPrintPage(PDFFile file) {
        this.file = file;
    }

    private void createPrintDialog() {
        this.pd = new JDialog((Frame)null, "Printing...", false);
        Container top = this.pd.getContentPane();
        Box lines = Box.createVerticalBox();
        Box line = Box.createHorizontalBox();
        line.add(new JLabel("Now printing: "));
        JLabel title = new JLabel("file.pdf");
        line.add(title);
        lines.add(line);
        line = Box.createHorizontalBox();
        line.add(Box.createHorizontalStrut(10));
        line.add(new JLabel("page "));
        this.pagenumlabel = new JLabel("1");
        line.add(this.pagenumlabel);
        line.add(new JLabel(" of "));
        JLabel totalpages = new JLabel(String.valueOf(this.file.getNumPages()));
        line.add(totalpages);
        lines.add(line);
        top.add((Component)lines, "Center");
        Box cancelbox = Box.createHorizontalBox();
        cancelbox.add(Box.createHorizontalGlue());
        this.cancel = new JButton(new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent evt) {
                PDFPrintPage.this.doCancel();
            }
        });
        cancelbox.add(this.cancel);
        top.add((Component)cancelbox, "South");
    }

    public void show(PrinterJob pjob) {
        this.pjob = pjob;
        if (this.pd == null) {
            this.createPrintDialog();
        }
        this.pd.pack();
        this.pd.show();
    }

    public void hide() {
        this.pd.dispose();
    }

    public void doCancel() {
        this.cancel.setEnabled(false);
        this.pjob.cancel();
    }

    public int print(Graphics g, PageFormat format, int index) throws PrinterException {
        int pagenum = index + 1;
        if (pagenum >= 1 && pagenum <= this.file.getNumPages()) {
            Rectangle imgbounds;
            double paperaspect;
            if (this.pagenumlabel != null) {
                this.pagenumlabel.setText(String.valueOf(pagenum));
            }
            Graphics2D g2 = (Graphics2D)g;
            PDFPage page = this.file.getPage(pagenum);
            double pwidth = format.getImageableWidth();
            double pheight = format.getImageableHeight();
            double aspect = page.getAspectRatio();
            if (aspect > (paperaspect = pwidth / pheight)) {
                int height = (int)(pwidth / aspect);
                imgbounds = new Rectangle((int)format.getImageableX(), (int)(format.getImageableY() + (pheight - (double)height) / 2.0), (int)pwidth, height);
            } else {
                int width = (int)(pheight * aspect);
                imgbounds = new Rectangle((int)(format.getImageableX() + (pwidth - (double)width) / 2.0), (int)format.getImageableY(), width, (int)pheight);
            }
            PDFRenderer pgs = new PDFRenderer(page, g2, imgbounds, null, null);
            try {
                page.waitForFinish();
                pgs.run();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            return 0;
        }
        return 1;
    }
}

