/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.utilities;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.higgins.sts.utilities.LogHelper;

public class ExceptionHelper {
    public static void Log(LogHelper log, Exception exception) {
        if (exception instanceof InvocationTargetException) {
            log.error("InvocationTargetException Cause is:");
            InvocationTargetException outer = (InvocationTargetException)exception;
            Throwable nested = outer.getCause();
            ExceptionHelper.Log(log, nested);
        } else {
            String strMessage = exception.getLocalizedMessage();
            if (null != strMessage) {
                log.error(strMessage);
            }
            log.error(exception);
            StackTraceElement[] ste = exception.getStackTrace();
            for (int i = 0; i < ste.length; ++i) {
                String strLine = ste[i].getClassName() + "::" + ste[i].getMethodName() + " " + ste[i].getFileName() + ":" + ste[i].getLineNumber();
                log.error(strLine);
            }
        }
    }

    public static void Log(LogHelper log, Throwable throwable) {
        if (null == throwable) {
            log.error("ExceptionHelper::Log throwable is null");
        } else if (throwable instanceof InvocationTargetException) {
            log.error("InvocationTargetException Cause is:");
            InvocationTargetException outer = (InvocationTargetException)throwable;
            Throwable nested = outer.getCause();
            ExceptionHelper.Log(log, nested);
        } else {
            String strMessage = throwable.getLocalizedMessage();
            if (null != strMessage) {
                log.error(strMessage);
            }
            log.error(throwable);
            StackTraceElement[] ste = throwable.getStackTrace();
            for (int i = 0; i < ste.length; ++i) {
                String strLine = ste[i].getClassName() + "::" + ste[i].getMethodName() + " " + ste[i].getFileName() + ":" + ste[i].getLineNumber();
                log.error(strLine);
            }
        }
    }
}

