/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.threerings.getdown.tools.Digester;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class DigesterTask
extends Task {
    protected File _appdir;
    protected File _storepath;
    protected String _storepass;
    protected String _storealias;

    public void setAppdir(File appdir) {
        this._appdir = appdir;
    }

    public void setKeystore(File path) {
        this._storepath = path;
    }

    public void setStorepass(String password) {
        this._storepass = password;
    }

    public void setAlias(String alias) {
        this._storealias = alias;
    }

    public void execute() throws BuildException {
        if (this._appdir == null) {
            throw new BuildException("Must specify the path to the application directory via the 'appdir' attribute.");
        }
        if (this._storepath != null && (this._storepass == null || this._storealias == null)) {
            throw new BuildException("Must specify both a keystore password and a private key alias.");
        }
        try {
            Digester.createDigests((File)this._appdir, (File)this._storepath, (String)this._storepass, (String)this._storealias);
        }
        catch (IOException ioe) {
            throw new BuildException("Error creating digest: " + ioe.getMessage(), (Throwable)ioe);
        }
        catch (GeneralSecurityException gse) {
            throw new BuildException("Error creating signature: " + gse.getMessage(), (Throwable)gse);
        }
    }
}

