/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.typesafe.config.ConfigFactory;
import helpers.EntryHelper;
import java.util.List;
import models.openfire.LogEntry;
import models.openfire.Room;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Controller;
import play.mvc.Result;
import play.twirl.api.Content;
import views.html.Application.index;
import views.html.Application.show;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Application
extends Controller {
    public static final String ISSUES_URL = ConfigFactory.load().getString("issues.url");
    public static final String DOCS_URL = ConfigFactory.load().getString("docs.url");
    public static final boolean REQUEST_SECURE = Application.getRequestSecure();

    public static Result index() {
        List<LogEntry> entries = LogEntry.getEntries(1, "desc");
        return Application.ok((Content)index.render(entries, new EntryHelper()));
    }

    public static Result show(String id) {
        String[] parts = id.split("_");
        if (parts.length < 3) {
            return Application.notFound((String)("Entry with id " + id + " not found!"));
        }
        Room room = (Room)((Object)Room.Finder.where().eq("roomId", (Object)parts[1]).findUnique());
        LogEntry entry = LogEntry.findEntry(room, parts[0], parts[2]);
        if (room == null || entry == null) {
            return Application.notFound((String)("Entry with id " + id + " not found!"));
        }
        return Application.ok((Content)show.render(room, entry));
    }

    protected static Integer getPageFromRequest() {
        Integer page = 1;
        try {
            if (Application.request().getQueryString("page") != null) {
                page = Integer.parseInt(Application.request().getQueryString("page"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return page;
    }

    protected static String getQueryValue(String key, String defaultValue) {
        return Application.request().getQueryString(key) != null ? Application.request().getQueryString(key) : defaultValue;
    }

    private static Boolean getRequestSecure() {
        if (ConfigFactory.load().hasPath("request.secure")) {
            return Boolean.parseBoolean(ConfigFactory.load().getString("request.secure"));
        }
        return false;
    }
}

