/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.Application;
import controllers.routes;
import helpers.DateHelper;
import helpers.EntryHelper;
import java.util.List;
import models.openfire.LogEntry;
import models.openfire.Room;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import play.Logger;
import play.cache.Cache;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Json;
import play.mvc.Result;
import play.twirl.api.Content;
import play.twirl.api.Html;
import views.html.Rooms.browse;
import views.html.Rooms.index;
import views.html.Rooms.show;
import views.xml.Rooms.feed;
import views.xml.Rooms.feed_all;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Rooms
extends Application {
    public static Result index() {
        List<Room> rooms = Room.listByDate();
        return Rooms.ok((Content)index.render(rooms));
    }

    public static Result feedAll() {
        List<LogEntry> entries = LogEntry.getEntries(1, "desc");
        LogEntry lastEntry = LogEntry.getLastEntry();
        return Rooms.ok((Content)feed_all.render(lastEntry, entries, Rooms.request()));
    }

    public static Result jsonIndex() {
        List<Room> rooms = Room.listByDate();
        ObjectNode result = Json.newObject();
        ArrayNode roomsJson = result.arrayNode();
        for (Room room : rooms) {
            roomsJson.add((JsonNode)room.toJson(Rooms.request()));
        }
        result.put("rooms", (JsonNode)roomsJson);
        return Rooms.ok((JsonNode)result);
    }

    public static Result browse(Long id) {
        Room room = (Room)((Object)Room.Finder.byId((Object)id));
        if (room == null) {
            return Rooms.notFound((String)("room with id " + id + " not found!"));
        }
        return Rooms.browseRoom(room);
    }

    public static Result browseWithName(String roomName) {
        Room room = (Room)((Object)Room.Finder.where().eq("name", (Object)roomName).findUnique());
        if (room == null) {
            return Rooms.notFound((String)("room with name " + roomName + " not found!"));
        }
        Room room2 = room;
        Long l = null;
        l = room2.getRoomId();
        return Rooms.redirect((String)routes.Rooms.browse(l).absoluteURL(Rooms.request(), Application.REQUEST_SECURE));
    }

    public static Result showWithName(String roomName, Integer year, Integer month, Integer day) {
        Room room = (Room)((Object)Room.Finder.where().eq("name", (Object)roomName).findUnique());
        if (room == null) {
            return Rooms.notFound((String)("room with name " + roomName + " not found!"));
        }
        Room room2 = room;
        Long l = null;
        l = room2.getRoomId();
        return Rooms.redirect((String)routes.Rooms.show(l, year, month, day).absoluteURL(Rooms.request(), Application.REQUEST_SECURE));
    }

    public static Result show(Long id, Integer year, Integer month, Integer day) {
        Room room = (Room)((Object)Room.Finder.byId((Object)id));
        if (room == null) {
            return Rooms.notFound((String)("room with id " + id + " not found!"));
        }
        return Rooms.showRoom(room, year, month, day);
    }

    private static Result showRoom(Room room, Integer year, Integer month, Integer day) {
        DateTime from = DateHelper.getLogTimeForYearMonthDay(year, month, day, false);
        DateTime to = DateHelper.getLogTimeForYearMonthDay(year, month, day, true);
        Object[] objectArray = new Object[4];
        Room room2 = room;
        Long l = null;
        l = room2.getRoomId();
        objectArray[0] = l;
        objectArray[1] = year;
        objectArray[2] = month;
        objectArray[3] = day;
        String cacheKey = "showRoom-" + String.format("%d-%d-%d-%d", objectArray);
        List<LogEntry> entries = room.getEntriesFromTo(from.getMillis(), to.getMillis());
        Html out = null;
        if (DateTime.now().isAfter((ReadableInstant)to)) {
            out = (Html)Cache.get((String)cacheKey);
            Logger.info((String)("laoding " + cacheKey + " from Cache!"));
        }
        if (out == null) {
            out = show.render(room, entries, from, to);
            if (DateTime.now().isAfter((ReadableInstant)to)) {
                Cache.set((String)cacheKey, (Object)out);
                Logger.info((String)(cacheKey + " saved to Cache!"));
            }
        }
        return Rooms.ok((Content)out);
    }

    public static Result feedWithName(String roomName) {
        Room room = (Room)((Object)Room.Finder.where().eq("name", (Object)roomName).findUnique());
        if (room == null) {
            return Rooms.notFound((String)("room with name " + roomName + " not found!"));
        }
        Integer page = Rooms.getPageFromRequest();
        Integer div = room.getEntryCount() / 200 + 1;
        Integer prev = page > 1 ? Integer.valueOf(page - 1) : null;
        Integer next = page < div ? Integer.valueOf(page + 1) : null;
        String order = Rooms.getQueryValue("order", "asc").equals("desc") ? "asc" : "desc";
        Logger.debug((String)("feed page: " + page + ", prev: " + prev + ", next: " + next + ", div: " + div));
        List<LogEntry> entries = room.getEntries(page, order);
        LogEntry lastEntry = room.getLastEntry();
        return Rooms.ok((Content)feed.render(room, lastEntry, entries, Rooms.request()));
    }

    public static Result jsonWithName(String roomName) {
        Room room = (Room)((Object)Room.Finder.where().eq("name", (Object)roomName).findUnique());
        ObjectNode result = Json.newObject();
        if (room == null) {
            result.put("error", "room with name " + roomName + " not found!");
            return Rooms.notFound((JsonNode)result);
        }
        Integer page = Rooms.getPageFromRequest();
        Integer div = room.getEntryCount() / 200 + 1;
        Logger.debug((String)("div: " + div + " room count: " + room.getEntryCount()));
        Integer prev = page > 1 ? page - 1 : page;
        Integer next = page < div ? page + 1 : page;
        String order = Rooms.getQueryValue("order", "asc").equals("desc") ? "asc" : "desc";
        ObjectNode links = Json.newObject();
        links.put("index", routes.Rooms.jsonIndex().absoluteURL(Rooms.request(), Application.REQUEST_SECURE).toString());
        Room room2 = room;
        Long l = null;
        l = room2.getRoomId();
        links.put("first", routes.Rooms.json(l).absoluteURL(Rooms.request(), Application.REQUEST_SECURE).toString());
        room2 = room;
        l = null;
        l = room2.getRoomId();
        links.put("next", routes.Rooms.json(l).absoluteURL(Rooms.request(), Application.REQUEST_SECURE).toString() + "?page=" + next);
        room2 = room;
        l = null;
        l = room2.getRoomId();
        links.put("current", routes.Rooms.json(l).absoluteURL(Rooms.request(), Application.REQUEST_SECURE).toString() + "?page=" + page);
        room2 = room;
        l = null;
        l = room2.getRoomId();
        links.put("prev", routes.Rooms.json(l).absoluteURL(Rooms.request(), Application.REQUEST_SECURE).toString() + "?page=" + prev);
        room2 = room;
        l = null;
        l = room2.getRoomId();
        links.put("last", routes.Rooms.json(l).absoluteURL(Rooms.request(), Application.REQUEST_SECURE).toString() + "?page=" + div);
        result.put("links", (JsonNode)links);
        List<LogEntry> entries = room.getEntries(page, order);
        return Rooms.ok((JsonNode)Rooms.entriesAsJson(result, room, entries));
    }

    public static Result json(Long id) {
        Room room = (Room)((Object)Room.Finder.byId((Object)id));
        ObjectNode result = Json.newObject();
        if (room == null) {
            result.put("error", "room with id " + id + " not found!");
            return Rooms.notFound((JsonNode)result);
        }
        Integer page = Rooms.getPageFromRequest();
        Integer div = room.getEntryCount() / 200 + 1;
        Logger.debug((String)("div: " + div + " room count: " + room.getEntryCount()));
        Integer prev = page > 1 ? page - 1 : page;
        Integer next = page < div ? page + 1 : page;
        String order = Rooms.getQueryValue("order", "asc").equals("desc") ? "asc" : "desc";
        ObjectNode links = Json.newObject();
        links.put("index", routes.Rooms.jsonIndex().absoluteURL(Rooms.request(), Application.REQUEST_SECURE).toString());
        Room room2 = room;
        Long l = null;
        l = room2.getRoomId();
        links.put("first", routes.Rooms.json(l).absoluteURL(Rooms.request(), Application.REQUEST_SECURE).toString());
        room2 = room;
        l = null;
        l = room2.getRoomId();
        links.put("next", routes.Rooms.json(l).absoluteURL(Rooms.request(), Application.REQUEST_SECURE).toString() + "?page=" + next);
        room2 = room;
        l = null;
        l = room2.getRoomId();
        links.put("current", routes.Rooms.json(l).absoluteURL(Rooms.request(), Application.REQUEST_SECURE).toString() + "?page=" + page);
        room2 = room;
        l = null;
        l = room2.getRoomId();
        links.put("prev", routes.Rooms.json(l).absoluteURL(Rooms.request(), Application.REQUEST_SECURE).toString() + "?page=" + prev);
        room2 = room;
        l = null;
        l = room2.getRoomId();
        links.put("last", routes.Rooms.json(l).absoluteURL(Rooms.request(), Application.REQUEST_SECURE).toString() + "?page=" + div);
        result.put("links", (JsonNode)links);
        List<LogEntry> entries = room.getEntries(page, order);
        return Rooms.ok((JsonNode)Rooms.entriesAsJson(result, room, entries));
    }

    public static Result jsonWithNameAndDate(String roomName, Integer year, Integer month, Integer day) {
        Room room = (Room)((Object)Room.Finder.where().eq("name", (Object)roomName).findUnique());
        ObjectNode result = Json.newObject();
        if (room == null) {
            result.put("error", "room with name " + roomName + " not found!");
            return Rooms.notFound((JsonNode)result);
        }
        Room room2 = room;
        Long l = null;
        l = room2.getRoomId();
        return Rooms.redirect((String)routes.Rooms.jsonWithDate(l, year, month, day).absoluteURL(Rooms.request(), Application.REQUEST_SECURE));
    }

    public static Result jsonWithDate(Long id, Integer year, Integer month, Integer day) {
        Room room = (Room)((Object)Room.Finder.byId((Object)id));
        ObjectNode result = Json.newObject();
        if (room == null) {
            result.put("error", "room with id " + id + " not found!");
            return Rooms.notFound((JsonNode)result);
        }
        DateTime from = DateHelper.getLogTimeForYearMonthDay(year, month, day, false);
        DateTime to = DateHelper.getLogTimeForYearMonthDay(year, month, day, true);
        List<LogEntry> entries = room.getEntriesFromTo(from.getMillis(), to.getMillis());
        return Rooms.ok((JsonNode)Rooms.entriesAsJson(result, room, entries));
    }

    public static Result feed(Long id) {
        Room room = (Room)((Object)Room.Finder.byId((Object)id));
        if (room == null) {
            return Rooms.notFound((String)("room with id " + id + " not found!"));
        }
        Integer page = Rooms.getPageFromRequest();
        Integer div = room.getEntryCount() / 200 + 1;
        Integer prev = page > 1 ? Integer.valueOf(page - 1) : null;
        Integer next = page < div ? Integer.valueOf(page + 1) : null;
        String order = Rooms.getQueryValue("order", "asc").equals("desc") ? "asc" : "desc";
        Logger.debug((String)("feed page: " + page + ", prev: " + prev + ", next: " + next + ", div: " + div));
        List<LogEntry> entries = room.getEntries(page, order);
        LogEntry lastEntry = room.getLastEntry();
        return Rooms.ok((Content)feed.render(room, lastEntry, entries, Rooms.request()));
    }

    private static ObjectNode entriesAsJson(ObjectNode result, Room room, List<LogEntry> entries) {
        ArrayNode entriesJson = result.arrayNode();
        for (LogEntry entry : entries) {
            entriesJson.add((JsonNode)EntryHelper.getJson(room, entry, Rooms.request()));
        }
        result.put("entries", (JsonNode)entriesJson);
        return result;
    }

    private static Result browseRoom(Room room) {
        Integer page = Rooms.getPageFromRequest();
        Integer div = room.getEntryCount() / 200 + 1;
        Integer prev = page > 1 ? Integer.valueOf(page - 1) : null;
        Integer next = page < div ? Integer.valueOf(page + 1) : null;
        String order = Rooms.getQueryValue("order", "asc").equals("desc") ? "asc" : "desc";
        Logger.debug((String)("browse page: " + page + ", prev: " + prev + ", next: " + next + ", div: " + div));
        List<LogEntry> entries = room.getEntries(page, order);
        return Rooms.ok((Content)browse.render(room, entries, new EntryHelper(), prev, next, page, order));
    }
}

