/*
 * Decompiled with CFR 0.152.
 */
package helpers;

import com.typesafe.config.ConfigFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import models.openfire.User;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.libs.ws.WS;
import play.libs.ws.WSResponse;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ContentHelper {
    private static final String HTTP_YOUTU_BE = "http://youtu.be";
    private static final String HTTPS_YOUTU_BE = "https://youtu.be";
    private static final String HTTP_WWW_YOUTUBE_COM = "http://www.youtube.com";
    private static final String HTTPS_WWW_YOUTUBE_COM = "https://www.youtube.com";
    private static final String HTTPS_WWW_YOUTUBE_COM_EMBED = "https://www.youtube.com/embed";
    private String content;
    private static final Pattern URL_PATTERN = Pattern.compile("\\b(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");
    private static final int MAX_GET_TIMEOUT = 2500;
    private static final String USER_URL_TEMPLATE = ConfigFactory.load().getString("user.url.template");
    private static final String[] INVALID_USERNAME_PARTS = new String[]{":", ","};

    public ContentHelper(String content) {
        this.content = content;
    }

    public static String prepare(String content) {
        if (content == null) {
            return content;
        }
        ContentHelper ch = new ContentHelper(content.trim());
        return ch.renderHtml().detectUsers().sanitize().detectLinks().normalize().toString();
    }

    public ContentHelper normalize() {
        this.content = this.content.replace("\n", "<br />\n");
        return this;
    }

    public ContentHelper renderHtml() {
        this.content = this.content.replace("<", "&lt;").replace(">", "&gt;");
        return this;
    }

    public ContentHelper sanitize() {
        PolicyFactory policy = new HtmlPolicyBuilder().allowUrlProtocols(new String[]{"http"}).allowUrlProtocols(new String[]{"https"}).allowElements(new String[]{"a"}).allowElements(new String[]{"img"}).allowElements(new String[]{"br"}).allowAttributes(new String[]{"href"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"target"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"src"}).onElements(new String[]{"img"}).requireRelNofollowOnLinks().toFactory();
        this.content = policy.sanitize(this.content);
        return this;
    }

    public ContentHelper detectLinks() {
        StringBuilder contentBuilder = new StringBuilder();
        for (String line : this.content.split("\n")) {
            String oldLine = line.trim();
            Matcher m = URL_PATTERN.matcher(line);
            while (m.find()) {
                String urlStr = m.group();
                Logger.debug((String)("found link |" + urlStr + "|"));
                line = line.replace(urlStr, this.embedLink(this.getUrl(urlStr)));
                if (urlStr.startsWith(HTTP_WWW_YOUTUBE_COM) || urlStr.startsWith(HTTPS_WWW_YOUTUBE_COM)) {
                    Logger.debug((String)("YOUTUBE_COM: " + line));
                    line = line + "<br />" + this.embedYT(this.getUrl(urlStr));
                }
                if (urlStr.startsWith(HTTP_YOUTU_BE) || urlStr.startsWith(HTTPS_YOUTU_BE)) {
                    Logger.debug((String)("YOUTU_BE: " + line));
                    line = line + "<br />" + this.embedYT(ContentHelper.convertShortYTUrl(urlStr));
                }
                if (!this.getUrl(oldLine).equals(urlStr)) continue;
                line = line + "<br />" + this.embedImage(this.getUrl(urlStr));
            }
            contentBuilder.append(line.trim());
            contentBuilder.append("\n");
        }
        this.content = contentBuilder.toString();
        return this;
    }

    public ContentHelper detectUsers() {
        StringBuilder contentBuilder = new StringBuilder();
        for (String line : this.content.split("\n")) {
            contentBuilder = this.detectUser(contentBuilder, line);
        }
        this.content = contentBuilder.toString();
        return this;
    }

    private String getUrl(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (IllegalArgumentException ex) {
            Logger.warn((String)ex.getLocalizedMessage(), (Throwable)ex);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.warn((String)ex.getLocalizedMessage(), (Throwable)ex);
        }
        String[] find = new String[]{"&#61;", "%3A", "%2F"};
        String[] replace = new String[]{"=", ":", "/"};
        for (int i = 0; i < find.length; ++i) {
            url.replace(find[i], replace[i]);
        }
        return url;
    }

    private StringBuilder detectUser(StringBuilder contentBuilder, String line) {
        if (line.contains(" @") || line.startsWith("@")) {
            int end;
            int start = line.indexOf(" @") + 1;
            if (start < 0 || line.startsWith("@")) {
                start = 0;
            }
            if ((end = Math.min(line.substring(start).indexOf(" ") + start, line.length())) < start) {
                end = line.length();
            }
            if (end > start) {
                String user = line.substring(start + 1, end);
                String cleanuser = user.trim().toLowerCase();
                for (String part : INVALID_USERNAME_PARTS) {
                    cleanuser = cleanuser.replace(part, "");
                }
                Logger.debug((String)("found user |" + user + "| " + start + "-" + end));
                if (User.exists(cleanuser)) {
                    contentBuilder.append(line.substring(0, start)).append("<a href=\"" + USER_URL_TEMPLATE.replace(":uid", cleanuser)).append("\">@" + user + "</a> ");
                } else {
                    contentBuilder.append(line.trim());
                }
            } else {
                Logger.warn((String)("false user in: " + line.trim()));
                contentBuilder.append(line.trim());
            }
            return this.detectUser(contentBuilder, line.substring(Math.min(end + 1, line.length())));
        }
        contentBuilder.append(line.trim());
        return contentBuilder;
    }

    public String toString() {
        return this.content;
    }

    private String embedLink(String urlStr) {
        return "<a href=\"" + urlStr + "\" target=\"_new\">" + urlStr + "</a>";
    }

    private String embedYT(String urlStr) {
        Map<String, String> paras = ContentHelper.getParametersFromUrl(urlStr);
        if (paras.containsKey("v")) {
            return "<iframe id=\"ytplayer\" type=\"text/html\" width=\"640\" height=\"390\" src=\"" + ContentHelper.buildEmbeddedYTUrl(paras) + "\" frameborder=\"0\"></iframe>";
        }
        return "";
    }

    private String embedImage(String urlStr) {
        try {
            F.Promise response = WS.url((String)urlStr).get();
            try {
                if (((WSResponse)response.get(2500L)).getHeader("Content-Type").startsWith("image")) {
                    return "<img src=\"" + urlStr + "\" />";
                }
            }
            catch (Exception ex) {
                Logger.warn((String)ex.getLocalizedMessage());
            }
        }
        catch (Exception ex) {
            Logger.warn((String)ex.getLocalizedMessage());
        }
        return "";
    }

    private static String buildEmbeddedYTUrl(Map<String, String> paras) {
        StringBuilder sb = new StringBuilder(HTTPS_WWW_YOUTUBE_COM_EMBED);
        if (paras.containsKey("v")) {
            sb.append("/" + paras.get("v"));
        }
        if (paras.containsKey("t")) {
            sb.append("?start=" + paras.get("t").replace("s", ""));
        }
        return sb.toString();
    }

    private static String convertShortYTUrl(String shortYTUrl) {
        String[] params;
        HashMap<String, String> map = new HashMap<String, String>();
        shortYTUrl = shortYTUrl.replace(HTTPS_YOUTU_BE, "").replace(HTTP_YOUTU_BE, "").replace("&#61;", "=").trim();
        for (String param : params = shortYTUrl.split("[/,?]")) {
            try {
                if (param.split("=").length == 2) {
                    map.put(param.split("=")[0], param.split("=")[1]);
                    continue;
                }
                if (param.isEmpty()) continue;
                map.put("v", param);
            }
            catch (Exception e) {
                Logger.warn((String)("No value for parameter " + param + " in shortYTUrl " + shortYTUrl));
            }
        }
        return "https://www.youtube.com/watch?v=" + (String)map.get("v") + "&t=" + (String)map.get("t");
    }

    private static Map<String, String> getParametersFromUrl(String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (url != null) {
            String[] params;
            for (String param : params = url.trim().split("[&,?]")) {
                try {
                    String name = param.split("=")[0];
                    String value = param.split("=")[1];
                    map.put(name, value);
                }
                catch (Exception e) {
                    Logger.warn((String)("No value for parameter " + param + " in " + url));
                }
            }
        }
        return map;
    }
}

