/*
 * Decompiled with CFR 0.152.
 */
package helpers;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.typesafe.config.ConfigFactory;
import controllers.Application;
import controllers.routes;
import helpers.ContentHelper;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import models.openfire.LogEntry;
import models.openfire.Room;
import models.openfire.User;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.Json;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class EntryHelper {
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final TimeZone TIMEZONE = TimeZone.getTimeZone("UTC");
    private static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.GERMAN);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy", Locale.GERMAN);
    private static final String USER_AVATAR_URL_TEMPLATE;
    private static final String USER_URL_TEMPLATE;
    private String lastDay = "";
    private String lastRoom = "";

    public static ObjectNode getJson(Room room, LogEntry entry, Http.Request request) {
        ObjectNode entryJson = Json.newObject();
        entryJson.put("id", entry.getEntryId());
        entryJson.put("sender", entry.getSenderName());
        LogEntry logEntry = entry;
        String string = null;
        string = logEntry.getSubject();
        entryJson.put("subject", string);
        logEntry = entry;
        string = null;
        string = logEntry.getBody();
        entryJson.put("content", string);
        entryJson.put("date", DATE_TIME_FORMAT.format(entry.getDate()));
        entryJson.put("link", routes.Application.show(entry.getEntryId()).absoluteURL(request, Application.REQUEST_SECURE));
        return entryJson;
    }

    public String checkDayChange(LogEntry entry, int columns) {
        if (this.lastDay.isEmpty() || !this.lastDay.equals(DATE_FORMAT.format(entry.getDate()))) {
            this.lastDay = DATE_FORMAT.format(entry.getDate());
            this.lastRoom = "";
            return "<tr><th class=\"day-header\" colspan=\"" + columns + "\"><h3>" + this.lastDay + "</h3></th></tr>";
        }
        return "";
    }

    public String checkRoomChange(LogEntry entry, int columns, String link) {
        if (this.lastRoom.isEmpty() || !this.lastRoom.equals(entry.getRoomName())) {
            this.lastRoom = entry.getRoomName();
            return link != null ? "<tr><th class=\"room-header\" colspan=\"" + columns + "\"><h4><a href=\"" + link + "\">" + this.lastRoom + "</a></h4></th></tr>" : "<tr><th class=\"room-header\" colspan=\"" + columns + "\"><h4>" + this.lastRoom + "</h4></th></tr>";
        }
        return "";
    }

    public static String getTableRows(Room room, LogEntry entry) {
        StringBuilder sb = new StringBuilder();
        Model model = entry;
        String string = null;
        string = model.getBody();
        if (string != null) {
            model = entry;
            string = null;
            string = model.getBody();
            String[] parts = string.split("\n");
            for (int i = 0; i < parts.length; ++i) {
                model = room;
                int n = 0;
                n = model.getLineCount();
                int line = n + i + 1;
                sb.append("<tr data-line=\"" + line + "\" class=\"entry");
                if (i == 0) {
                    sb.append(" head\" id=\"" + entry.getEntryId());
                }
                sb.append("\">");
                sb.append("<th class=\"tiny\">");
                sb.append("<a data-link=\"line-link\" id=\"L" + line + "\" name=\"L" + line + "\" href=\"#L" + line + "\">#" + line + "</a>");
                sb.append("</th>");
                if (i == 0) {
                    sb.append("<td class=\"top narrow\">");
                    sb.append(EntryHelper.decorateIcon(entry.getSenderName()));
                    sb.append("</td>");
                    sb.append("<td>");
                    sb.append("<div class=\"content\">");
                    model = entry;
                    String string2 = null;
                    string2 = model.getSubject();
                    if (string2 != null) {
                        model = entry;
                        string2 = null;
                        string2 = model.getSubject();
                        sb.append("changed topic to <h4>" + string2 + "</h4>");
                    } else {
                        sb.append(ContentHelper.prepare(parts[i]));
                    }
                    sb.append("</div>");
                    sb.append("</td>");
                    sb.append("<td class=\"top narrow\">" + TIME_FORMAT.format(entry.getDate()) + "</td>");
                } else {
                    sb.append("<td></td>");
                    sb.append("<td>");
                    sb.append(ContentHelper.prepare(parts[i]));
                    sb.append("</td>");
                    sb.append("<td></td>");
                }
                sb.append("</tr>");
            }
            room.updatedLineCount(parts.length);
        } else {
            model = room;
            int n = 0;
            n = model.getLineCount();
            int line = n + 1;
            sb.append("<tr data-line=\"" + line + "\" class=\"entry head \">");
            sb.append("<th class=\"tiny\">");
            sb.append("<a data-link=\"line-link\" id=\"L" + line + "\" name=\"L" + line + "\" href=\"#L" + line + "\">#" + line + "</a>");
            sb.append("</th>");
            sb.append("<td class=\"top narrow\">");
            sb.append(EntryHelper.decorateIcon(entry.getSenderName()));
            sb.append("</td>");
            sb.append("<td>");
            model = entry;
            String string3 = null;
            string3 = model.getSubject();
            sb.append("changed topic to <b>" + string3 + "</b>");
            sb.append("</td>");
            sb.append("<td class=\"top narrow\">" + TIME_FORMAT.format(entry.getDate()) + "</td>");
            sb.append("</tr>");
            room.updatedLineCount(1);
        }
        return sb.toString();
    }

    public static String decorateIcon(String senderName) {
        return EntryHelper.addAvatarToUser(senderName, "64x64", false);
    }

    public static String decorateAvatar(String senderName) {
        return EntryHelper.addAvatarToUser(senderName, "128x128", true);
    }

    private static String addAvatarToUser(String senderName, String size, boolean lineBreak) {
        StringBuilder sb = new StringBuilder();
        if (USER_AVATAR_URL_TEMPLATE != null && User.exists(senderName)) {
            sb.append("<img class=\"avatar" + size + "\" src=\"" + USER_AVATAR_URL_TEMPLATE.replace(":uid", senderName).replace(":size", size) + "\"/>");
            if (USER_URL_TEMPLATE != null) {
                sb.append("<a href=\"" + USER_URL_TEMPLATE.replace(":uid", senderName)).append("\">");
                if (lineBreak) {
                    sb.append("<br />");
                }
                sb.append(senderName + "</a>");
            } else {
                sb.append(senderName);
            }
        } else {
            sb.append(senderName);
        }
        return sb.toString();
    }

    static {
        DATE_TIME_FORMAT.setTimeZone(TIMEZONE);
        DATE_FORMAT.setTimeZone(TIMEZONE);
        USER_AVATAR_URL_TEMPLATE = ConfigFactory.load().getString("user.avatar.url.template");
        USER_URL_TEMPLATE = ConfigFactory.load().getString("user.url.template");
    }
}

