/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.Application;
import models.openfire.LogEntry;
import models.openfire.Room;
import org.joda.time.DateTime;
import play.cache.Cache;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Json;
import play.mvc.Result;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class RoomStatistics
extends Application {
    private static final int CACHE_TTL_IN_MINUTES = 10;
    private static final int CACHE_TTL_IN_SECONDS = 600;
    private static final Room ALL_ROOMS = null;

    public static Result jsonShow(Long id, Integer days) {
        Room room = (Room)((Object)Room.Finder.byId((Object)id));
        if (room == null) {
            return RoomStatistics.notFound((String)("room with id " + id + " not found!"));
        }
        String cacheKey = "roomStats-" + id + "-" + days;
        ObjectNode result = Json.newObject();
        ArrayNode results = (ArrayNode)Cache.get((String)cacheKey);
        if (results == null) {
            results = RoomStatistics.collectEntries(room, days, result.arrayNode());
            Cache.set((String)cacheKey, (Object)results, (int)10);
        }
        result.put("entries", (JsonNode)results);
        RoomStatistics.response().setHeader("Cache-Control", "max-age=600, public");
        RoomStatistics.response().setHeader("Etag", String.valueOf(results.hashCode()));
        return RoomStatistics.ok((JsonNode)result);
    }

    public static Result jsonIndex(Integer days) {
        ObjectNode result = Json.newObject();
        String cacheKey = "roomsStats-" + days;
        ArrayNode results = (ArrayNode)Cache.get((String)cacheKey);
        if (results == null) {
            results = RoomStatistics.collectEntries(ALL_ROOMS, days, result.arrayNode());
            Cache.set((String)cacheKey, (Object)results, (int)10);
        }
        result.put("entries", (JsonNode)results);
        RoomStatistics.response().setHeader("Cache-Control", "max-age=600, public");
        RoomStatistics.response().setHeader("Etag", String.valueOf(results.hashCode()));
        return RoomStatistics.ok((JsonNode)result);
    }

    private static ArrayNode collectEntries(Room room, Integer days, ArrayNode roomsJson) {
        DateTime to = DateTime.now();
        DateTime from = DateTime.now().minusDays(7);
        if (room == null) {
            for (int i = days.intValue(); i >= 0; --i) {
                to = DateTime.now().minusDays(i);
                from = DateTime.now().minusDays(i + 1);
                roomsJson.add(LogEntry.getAllEntriesFromTo(from.getMillis(), to.getMillis()).size());
            }
        } else {
            for (int i = days.intValue(); i >= 0; --i) {
                to = DateTime.now().minusDays(i);
                from = DateTime.now().minusDays(i + 1);
                roomsJson.add(room.getEntriesFromTo(from.getMillis(), to.getMillis()).size());
            }
        }
        return roomsJson;
    }
}

