/*
 * Decompiled with CFR 0.152.
 */
package models.openfire;

import com.avaje.ebean.RawSql;
import com.avaje.ebean.RawSqlBuilder;
import com.avaje.ebean.bean.EntityBean;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.Application;
import controllers.routes;
import helpers.openfire.OpenFireHelper;
import java.beans.PropertyChangeEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import models.openfire.LogEntry;
import models.openfire.RoomService;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.F;
import play.libs.Json;
import play.mvc.Http;

@Entity
@Table(name="ofMucRoom")
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Room
extends Model
implements EntityBean {
    @Id
    @Column(name="roomID", columnDefinition="bigint(20) NULL")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long roomId;
    @Column(name="serviceID", columnDefinition="bigint(20) NULL")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long serviceId;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String name;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String description;
    @Column(name="naturalName")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String title;
    @Column(name="roomPassword")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String roomPassword;
    public static final int PAGE_SIZE = 200;
    private static final TimeZone TIMEZONE = TimeZone.getTimeZone("UTC");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.GERMAN);
    private static String LIST_RAW_SQL;
    private static RawSql LIST_RAW_SQL_QUERY;
    @Transient
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public int lineCount;
    public static Model.Finder<Long, Room> Finder;
    private static String _EBEAN_MARKER = "models.openfire.Room";

    public Room() {
        int n = 0;
        Room room = this;
        room.setLineCount(n);
    }

    public Date getLastEntryDate() {
        Date date = null;
        LogEntry entry = this.getLastEntry();
        if (entry != null) {
            LogEntry logEntry = entry;
            String string = null;
            string = logEntry.getLogTimeString();
            date = OpenFireHelper.getDateFormLogTime(string);
        }
        return date;
    }

    public LogEntry getLastEntry() {
        Room room = this;
        Long l = null;
        l = room.getRoomId();
        return (LogEntry)((Object)LogEntry.Finder.setMaxRows(1).where().eq("roomId", (Object)l).order("logTimeString DESC").findUnique());
    }

    public Integer getEntryCount() {
        Room room = this;
        Long l = null;
        l = room.getRoomId();
        return LogEntry.Finder.where().eq("roomId", (Object)l).findRowCount();
    }

    public List<LogEntry> getEntries(Integer page, String order) {
        int p = page != null ? page : 1;
        Room room = this;
        Long l = null;
        l = room.getRoomId();
        List entries = LogEntry.Finder.where().eq("roomId", (Object)l).order("logTimeString " + order).findPagingList(200).getPage(p - 1).getList();
        return entries;
    }

    public List<LogEntry> getEntriesFromTo(Long from, Long to) {
        String fromStr = OpenFireHelper.getLogTimeFromMillis(from);
        String toStr = OpenFireHelper.getLogTimeFromMillis(to);
        Room room = this;
        Long l = null;
        l = room.getRoomId();
        List entries = LogEntry.Finder.where("logTimeString > :fromStr AND logTimeString < :toStr AND roomId = :roomId").setParameter("fromStr", (Object)fromStr).setParameter("toStr", (Object)toStr).setParameter("roomId", (Object)l).order("logTimeString ASC").findList();
        return entries;
    }

    public String getJabberId() {
        Room room = this;
        Object object = null;
        object = room.getServiceId();
        RoomService service = (RoomService)((Object)RoomService.Finder.byId(object));
        if (service != null) {
            room = this;
            object = null;
            object = room.getName();
            return (String)object + "@" + service.getDomain();
        }
        return "";
    }

    public String getUUID() {
        Room room = this;
        String string = null;
        string = room.getName();
        return UUID.nameUUIDFromBytes(string.getBytes()).toString();
    }

    public Integer updatedLineCount(int lineCount) {
        Room room = this;
        int n = 0;
        n = room.getLineCount();
        room.setLineCount(n += lineCount);
        room = this;
        n = 0;
        n = room.getLineCount();
        return n;
    }

    public static List<Room> listByDate() {
        return Finder.setRawSql(LIST_RAW_SQL_QUERY).setDistinct(true).findList();
    }

    public ObjectNode toJson(Http.Request request) {
        ObjectNode jsonRoom = Json.newObject();
        Room room = this;
        Object object = null;
        object = room.getRoomId();
        jsonRoom.put("id", (Long)object);
        room = this;
        object = null;
        object = room.getTitle();
        jsonRoom.put("name", (String)object);
        jsonRoom.put("lastEntryDate", DATE_FORMAT.format(this.getLastEntryDate()));
        jsonRoom.put("entryCount", this.getEntryCount());
        jsonRoom.put("jabberId", this.getJabberId());
        room = this;
        object = null;
        object = room.getName();
        jsonRoom.put("url", routes.Rooms.jsonWithName((String)object).absoluteURL(request, Application.REQUEST_SECURE).toString());
        return jsonRoom;
    }

    static {
        DATE_FORMAT.setTimeZone(TIMEZONE);
        LIST_RAW_SQL = "SELECT ofMucConversationLog.roomID, max(logTime) as mTime, ofMucRoom.roomID, ofMucRoom.serviceID, ofMucRoom.name, ofMucRoom.description, ofMucRoom.naturalName, ofMucRoom.roomPassword FROM ofMucConversationLog, ofMucRoom WHERE ofMucRoom.roomID = ofMucConversationLog.roomID GROUP BY ofMucConversationLog.roomID ORDER BY mTime DESC";
        LIST_RAW_SQL_QUERY = RawSqlBuilder.parse((String)LIST_RAW_SQL).columnMapping("ofMucRoom.roomID", "roomId").columnMapping("ofMucRoom.serviceID", "serviceId").columnMapping("ofMucRoom.name", "name").columnMapping("ofMucRoom.description", "description").columnMapping("ofMucRoom.naturalName", "title").columnMapping("ofMucRoom.roomPassword", "roomPassword").columnMappingIgnore("ofMucConversationLog.roomID").columnMappingIgnore("max(logTime)").create();
        Finder = new Model.Finder("openfire", Long.class, Room.class);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getRoomId() {
        return this._ebean_get_roomId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setRoomId(Long l) {
        this._ebean_set_roomId(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getServiceId() {
        return this._ebean_get_serviceId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setServiceId(Long l) {
        this._ebean_set_serviceId(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getName() {
        return this._ebean_get_name();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setName(String string) {
        this._ebean_set_name(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getDescription() {
        return this._ebean_get_description();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setDescription(String string) {
        this._ebean_set_description(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getTitle() {
        return this._ebean_get_title();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setTitle(String string) {
        this._ebean_set_title(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getRoomPassword() {
        return this._ebean_get_roomPassword();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setRoomPassword(String string) {
        this._ebean_set_roomPassword(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public int getLineCount() {
        return this.lineCount;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setLineCount(int n) {
        this.lineCount = n;
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected Long _ebean_get_roomId() {
        return this.roomId;
    }

    protected void _ebean_set_roomId(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "roomId", (Object)this._ebean_get_roomId(), (Object)newValue);
        this.roomId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_roomId() {
        return this.roomId;
    }

    protected void _ebean_setni_roomId(Long _newValue) {
        this.roomId = _newValue;
    }

    protected Long _ebean_get_serviceId() {
        this._ebean_intercept.preGetter("serviceId");
        return this.serviceId;
    }

    protected void _ebean_set_serviceId(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "serviceId", (Object)this._ebean_get_serviceId(), (Object)newValue);
        this.serviceId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_serviceId() {
        return this.serviceId;
    }

    protected void _ebean_setni_serviceId(Long _newValue) {
        this.serviceId = _newValue;
    }

    protected String _ebean_get_name() {
        this._ebean_intercept.preGetter("name");
        return this.name;
    }

    protected void _ebean_set_name(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "name", (Object)this._ebean_get_name(), (Object)newValue);
        this.name = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_name() {
        return this.name;
    }

    protected void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
    }

    protected String _ebean_get_description() {
        this._ebean_intercept.preGetter("description");
        return this.description;
    }

    protected void _ebean_set_description(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "description", (Object)this._ebean_get_description(), (Object)newValue);
        this.description = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_description() {
        return this.description;
    }

    protected void _ebean_setni_description(String _newValue) {
        this.description = _newValue;
    }

    protected String _ebean_get_title() {
        this._ebean_intercept.preGetter("title");
        return this.title;
    }

    protected void _ebean_set_title(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "title", (Object)this._ebean_get_title(), (Object)newValue);
        this.title = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_title() {
        return this.title;
    }

    protected void _ebean_setni_title(String _newValue) {
        this.title = _newValue;
    }

    protected String _ebean_get_roomPassword() {
        this._ebean_intercept.preGetter("roomPassword");
        return this.roomPassword;
    }

    protected void _ebean_set_roomPassword(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "roomPassword", (Object)this._ebean_get_roomPassword(), (Object)newValue);
        this.roomPassword = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_roomPassword() {
        return this.roomPassword;
    }

    protected void _ebean_setni_roomPassword(String _newValue) {
        this.roomPassword = _newValue;
    }

    protected int _ebean_get_lineCount() {
        return this.lineCount;
    }

    protected void _ebean_set_lineCount(int newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "lineCount", this._ebean_get_lineCount(), newValue);
        this.lineCount = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected int _ebean_getni_lineCount() {
        return this.lineCount;
    }

    protected void _ebean_setni_lineCount(int _newValue) {
        this.lineCount = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        Room room = new Room();
        room.roomId = this.roomId;
        room.serviceId = this.serviceId;
        room.name = this.name;
        room.description = this.description;
        room.title = this.title;
        room.roomPassword = this.roomPassword;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        Room p = (Room)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.roomId;
            }
            case 2: {
                return p.serviceId;
            }
            case 3: {
                return p.name;
            }
            case 4: {
                return p.description;
            }
            case 5: {
                return p.title;
            }
            case 6: {
                return p.roomPassword;
            }
            case 7: {
                return p.lineCount;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        Room p = (Room)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_roomId();
            }
            case 2: {
                return p._ebean_get_serviceId();
            }
            case 3: {
                return p._ebean_get_name();
            }
            case 4: {
                return p._ebean_get_description();
            }
            case 5: {
                return p._ebean_get_title();
            }
            case 6: {
                return p._ebean_get_roomPassword();
            }
            case 7: {
                return p._ebean_get_lineCount();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        Room p = (Room)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.roomId = (Long)arg;
                return;
            }
            case 2: {
                p.serviceId = (Long)arg;
                return;
            }
            case 3: {
                p.name = (String)arg;
                return;
            }
            case 4: {
                p.description = (String)arg;
                return;
            }
            case 5: {
                p.title = (String)arg;
                return;
            }
            case 6: {
                p.roomPassword = (String)arg;
                return;
            }
            case 7: {
                p.lineCount = (Integer)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        Room p = (Room)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_roomId((Long)arg);
                return;
            }
            case 2: {
                p._ebean_set_serviceId((Long)arg);
                return;
            }
            case 3: {
                p._ebean_set_name((String)arg);
                return;
            }
            case 4: {
                p._ebean_set_description((String)arg);
                return;
            }
            case 5: {
                p._ebean_set_title((String)arg);
                return;
            }
            case 6: {
                p._ebean_set_roomPassword((String)arg);
                return;
            }
            case 7: {
                p._ebean_set_lineCount((Integer)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "roomId", "serviceId", "name", "description", "title", "roomPassword", "lineCount"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        Room room = this;
        synchronized (room) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, (Object)this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((Room)((Object)obj))._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new Room();
    }
}

