// @SOURCE:/home/javastream.de/jenkins/jobs/de.consolving.chatlogserver/workspace/conf/routes
// @HASH:4579328d03dfd919eaca7f6e39d0241aeb7cc956
// @DATE:Sat Jul 25 02:14:23 CEST 2015

import Routes.{prefix => _prefix, defaultPrefix => _defaultPrefix}
import play.core._
import play.core.Router._
import play.core.Router.HandlerInvokerFactory._
import play.core.j._

import play.api.mvc._
import _root_.controllers.Assets.Asset
import _root_.play.libs.F

import Router.queryString


// @LINE:31
// @LINE:28
// @LINE:26
// @LINE:25
// @LINE:24
// @LINE:23
// @LINE:22
// @LINE:21
// @LINE:20
// @LINE:19
// @LINE:18
// @LINE:17
// @LINE:16
// @LINE:15
// @LINE:14
// @LINE:13
// @LINE:12
// @LINE:11
// @LINE:10
// @LINE:9
// @LINE:8
// @LINE:7
package controllers {

// @LINE:31
class ReverseAssets {


// @LINE:31
def versioned(file:Asset): Call = {
   implicit val _rrc = new ReverseRouteContext(Map(("path", "/public")))
   Call("GET", _prefix + { _defaultPrefix } + "assets/" + implicitly[PathBindable[Asset]].unbind("file", file))
}
                        

}
                          

// @LINE:11
// @LINE:10
class ReverseUsers {


// @LINE:11
def browse(uid:String): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix + { _defaultPrefix } + "users/" + implicitly[PathBindable[String]].unbind("uid", dynamicString(uid)))
}
                        

// @LINE:10
def index(): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix + { _defaultPrefix } + "users")
}
                        

}
                          

// @LINE:28
class ReverseMetrics {


// @LINE:28
def metrics(): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix + { _defaultPrefix } + "metrics")
}
                        

}
                          

// @LINE:18
// @LINE:17
class ReverseRoomStatistics {


// @LINE:18
def jsonShow(roomId:Long, days:Integer): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix + { _defaultPrefix } + "rooms/" + implicitly[PathBindable[Long]].unbind("roomId", roomId) + "/stats/" + implicitly[PathBindable[Integer]].unbind("days", days) + "/days.json")
}
                        

// @LINE:17
def jsonIndex(days:Integer): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix + { _defaultPrefix } + "rooms/stats/" + implicitly[PathBindable[Integer]].unbind("days", days) + "/days.json")
}
                        

}
                          

// @LINE:9
// @LINE:7
class ReverseApplication {


// @LINE:9
def show(id:String): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix + { _defaultPrefix } + "entries/" + implicitly[PathBindable[String]].unbind("id", dynamicString(id)))
}
                        

// @LINE:7
def index(): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix)
}
                        

}
                          

// @LINE:26
// @LINE:25
// @LINE:24
// @LINE:23
// @LINE:22
// @LINE:21
// @LINE:20
// @LINE:19
// @LINE:16
// @LINE:15
// @LINE:14
// @LINE:13
// @LINE:12
// @LINE:8
class ReverseRooms {


// @LINE:26
// @LINE:25
def showWithName(roomName:String, year:Integer, month:Integer, day:Integer): Call = {
   (roomName: @unchecked, year: @unchecked, month: @unchecked, day: @unchecked) match {
// @LINE:25
case (roomName, year, month, day)  =>
  import ReverseRouteContext.empty
  Call("GET", _prefix + { _defaultPrefix } + "rooms/" + implicitly[PathBindable[String]].unbind("roomName", dynamicString(roomName)) + "/" + implicitly[PathBindable[Integer]].unbind("year", year) + "/" + implicitly[PathBindable[Integer]].unbind("month", month) + "/" + implicitly[PathBindable[Integer]].unbind("day", day))
                                         
   }
}
                                                

// @LINE:19
def show(roomId:Long, year:Integer, month:Integer, day:Integer): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix + { _defaultPrefix } + "rooms/" + implicitly[PathBindable[Long]].unbind("roomId", roomId) + "/day/" + implicitly[PathBindable[Integer]].unbind("year", year) + "/" + implicitly[PathBindable[Integer]].unbind("month", month) + "/" + implicitly[PathBindable[Integer]].unbind("day", day))
}
                        

// @LINE:16
def json(roomId:Long): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix + { _defaultPrefix } + "rooms/" + implicitly[PathBindable[Long]].unbind("roomId", roomId) + ".json")
}
                        

// @LINE:22
def jsonWithName(roomName:String): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix + { _defaultPrefix } + "rooms/" + implicitly[PathBindable[String]].unbind("roomName", dynamicString(roomName)) + ".json")
}
                        

// @LINE:23
def jsonWithNameAndDate(roomName:String, year:Integer, month:Integer, day:Integer): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix + { _defaultPrefix } + "rooms/" + implicitly[PathBindable[String]].unbind("roomName", dynamicString(roomName)) + "/" + implicitly[PathBindable[Integer]].unbind("year", year) + "/" + implicitly[PathBindable[Integer]].unbind("month", month) + "/" + implicitly[PathBindable[Integer]].unbind("day", day) + ".json")
}
                        

// @LINE:12
def jsonIndex(): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix + { _defaultPrefix } + "rooms.json")
}
                        

// @LINE:15
def browse(roomId:Long): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix + { _defaultPrefix } + "rooms/" + implicitly[PathBindable[Long]].unbind("roomId", roomId))
}
                        

// @LINE:24
def browseWithName(roomName:String): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix + { _defaultPrefix } + "rooms/" + implicitly[PathBindable[String]].unbind("roomName", dynamicString(roomName)))
}
                        

// @LINE:14
def feed(roomId:Long): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix + { _defaultPrefix } + "rooms/" + implicitly[PathBindable[Long]].unbind("roomId", roomId) + ".atom")
}
                        

// @LINE:8
def feedAll(): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix + { _defaultPrefix } + "all.atom")
}
                        

// @LINE:13
def index(): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix + { _defaultPrefix } + "rooms")
}
                        

// @LINE:21
def feedWithName(roomName:String): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix + { _defaultPrefix } + "rooms/" + implicitly[PathBindable[String]].unbind("roomName", dynamicString(roomName)) + ".atom")
}
                        

// @LINE:20
def jsonWithDate(roomId:Long, year:Integer, month:Integer, day:Integer): Call = {
   import ReverseRouteContext.empty
   Call("GET", _prefix + { _defaultPrefix } + "rooms/" + implicitly[PathBindable[Long]].unbind("roomId", roomId) + "/" + implicitly[PathBindable[Integer]].unbind("year", year) + "/" + implicitly[PathBindable[Integer]].unbind("month", month) + "/" + implicitly[PathBindable[Integer]].unbind("day", day) + ".json")
}
                        

}
                          
}
                  


// @LINE:31
// @LINE:28
// @LINE:26
// @LINE:25
// @LINE:24
// @LINE:23
// @LINE:22
// @LINE:21
// @LINE:20
// @LINE:19
// @LINE:18
// @LINE:17
// @LINE:16
// @LINE:15
// @LINE:14
// @LINE:13
// @LINE:12
// @LINE:11
// @LINE:10
// @LINE:9
// @LINE:8
// @LINE:7
package controllers.javascript {
import ReverseRouteContext.empty

// @LINE:31
class ReverseAssets {


// @LINE:31
def versioned : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Assets.versioned",
   """
      function(file) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "assets/" + (""" + implicitly[PathBindable[Asset]].javascriptUnbind + """)("file", file)})
      }
   """
)
                        

}
              

// @LINE:11
// @LINE:10
class ReverseUsers {


// @LINE:11
def browse : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Users.browse",
   """
      function(uid) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "users/" + (""" + implicitly[PathBindable[String]].javascriptUnbind + """)("uid", encodeURIComponent(uid))})
      }
   """
)
                        

// @LINE:10
def index : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Users.index",
   """
      function() {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "users"})
      }
   """
)
                        

}
              

// @LINE:28
class ReverseMetrics {


// @LINE:28
def metrics : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Metrics.metrics",
   """
      function() {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "metrics"})
      }
   """
)
                        

}
              

// @LINE:18
// @LINE:17
class ReverseRoomStatistics {


// @LINE:18
def jsonShow : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.RoomStatistics.jsonShow",
   """
      function(roomId,days) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "rooms/" + (""" + implicitly[PathBindable[Long]].javascriptUnbind + """)("roomId", roomId) + "/stats/" + (""" + implicitly[PathBindable[Integer]].javascriptUnbind + """)("days", days) + "/days.json"})
      }
   """
)
                        

// @LINE:17
def jsonIndex : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.RoomStatistics.jsonIndex",
   """
      function(days) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "rooms/stats/" + (""" + implicitly[PathBindable[Integer]].javascriptUnbind + """)("days", days) + "/days.json"})
      }
   """
)
                        

}
              

// @LINE:9
// @LINE:7
class ReverseApplication {


// @LINE:9
def show : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Application.show",
   """
      function(id) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "entries/" + (""" + implicitly[PathBindable[String]].javascriptUnbind + """)("id", encodeURIComponent(id))})
      }
   """
)
                        

// @LINE:7
def index : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Application.index",
   """
      function() {
      return _wA({method:"GET", url:"""" + _prefix + """"})
      }
   """
)
                        

}
              

// @LINE:26
// @LINE:25
// @LINE:24
// @LINE:23
// @LINE:22
// @LINE:21
// @LINE:20
// @LINE:19
// @LINE:16
// @LINE:15
// @LINE:14
// @LINE:13
// @LINE:12
// @LINE:8
class ReverseRooms {


// @LINE:26
// @LINE:25
def showWithName : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Rooms.showWithName",
   """
      function(roomName, year, month, day) {
      if (true) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "rooms/" + (""" + implicitly[PathBindable[String]].javascriptUnbind + """)("roomName", encodeURIComponent(roomName)) + "/" + (""" + implicitly[PathBindable[Integer]].javascriptUnbind + """)("year", year) + "/" + (""" + implicitly[PathBindable[Integer]].javascriptUnbind + """)("month", month) + "/" + (""" + implicitly[PathBindable[Integer]].javascriptUnbind + """)("day", day)})
      }
      if (true) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "rooms/" + (""" + implicitly[PathBindable[String]].javascriptUnbind + """)("roomName", encodeURIComponent(roomName)) + "/day/" + (""" + implicitly[PathBindable[Integer]].javascriptUnbind + """)("year", year) + "/" + (""" + implicitly[PathBindable[Integer]].javascriptUnbind + """)("month", month) + "/" + (""" + implicitly[PathBindable[Integer]].javascriptUnbind + """)("day", day)})
      }
      }
   """
)
                        

// @LINE:19
def show : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Rooms.show",
   """
      function(roomId,year,month,day) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "rooms/" + (""" + implicitly[PathBindable[Long]].javascriptUnbind + """)("roomId", roomId) + "/day/" + (""" + implicitly[PathBindable[Integer]].javascriptUnbind + """)("year", year) + "/" + (""" + implicitly[PathBindable[Integer]].javascriptUnbind + """)("month", month) + "/" + (""" + implicitly[PathBindable[Integer]].javascriptUnbind + """)("day", day)})
      }
   """
)
                        

// @LINE:16
def json : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Rooms.json",
   """
      function(roomId) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "rooms/" + (""" + implicitly[PathBindable[Long]].javascriptUnbind + """)("roomId", roomId) + ".json"})
      }
   """
)
                        

// @LINE:22
def jsonWithName : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Rooms.jsonWithName",
   """
      function(roomName) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "rooms/" + (""" + implicitly[PathBindable[String]].javascriptUnbind + """)("roomName", encodeURIComponent(roomName)) + ".json"})
      }
   """
)
                        

// @LINE:23
def jsonWithNameAndDate : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Rooms.jsonWithNameAndDate",
   """
      function(roomName,year,month,day) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "rooms/" + (""" + implicitly[PathBindable[String]].javascriptUnbind + """)("roomName", encodeURIComponent(roomName)) + "/" + (""" + implicitly[PathBindable[Integer]].javascriptUnbind + """)("year", year) + "/" + (""" + implicitly[PathBindable[Integer]].javascriptUnbind + """)("month", month) + "/" + (""" + implicitly[PathBindable[Integer]].javascriptUnbind + """)("day", day) + ".json"})
      }
   """
)
                        

// @LINE:12
def jsonIndex : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Rooms.jsonIndex",
   """
      function() {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "rooms.json"})
      }
   """
)
                        

// @LINE:15
def browse : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Rooms.browse",
   """
      function(roomId) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "rooms/" + (""" + implicitly[PathBindable[Long]].javascriptUnbind + """)("roomId", roomId)})
      }
   """
)
                        

// @LINE:24
def browseWithName : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Rooms.browseWithName",
   """
      function(roomName) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "rooms/" + (""" + implicitly[PathBindable[String]].javascriptUnbind + """)("roomName", encodeURIComponent(roomName))})
      }
   """
)
                        

// @LINE:14
def feed : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Rooms.feed",
   """
      function(roomId) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "rooms/" + (""" + implicitly[PathBindable[Long]].javascriptUnbind + """)("roomId", roomId) + ".atom"})
      }
   """
)
                        

// @LINE:8
def feedAll : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Rooms.feedAll",
   """
      function() {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "all.atom"})
      }
   """
)
                        

// @LINE:13
def index : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Rooms.index",
   """
      function() {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "rooms"})
      }
   """
)
                        

// @LINE:21
def feedWithName : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Rooms.feedWithName",
   """
      function(roomName) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "rooms/" + (""" + implicitly[PathBindable[String]].javascriptUnbind + """)("roomName", encodeURIComponent(roomName)) + ".atom"})
      }
   """
)
                        

// @LINE:20
def jsonWithDate : JavascriptReverseRoute = JavascriptReverseRoute(
   "controllers.Rooms.jsonWithDate",
   """
      function(roomId,year,month,day) {
      return _wA({method:"GET", url:"""" + _prefix + { _defaultPrefix } + """" + "rooms/" + (""" + implicitly[PathBindable[Long]].javascriptUnbind + """)("roomId", roomId) + "/" + (""" + implicitly[PathBindable[Integer]].javascriptUnbind + """)("year", year) + "/" + (""" + implicitly[PathBindable[Integer]].javascriptUnbind + """)("month", month) + "/" + (""" + implicitly[PathBindable[Integer]].javascriptUnbind + """)("day", day) + ".json"})
      }
   """
)
                        

}
              
}
        


// @LINE:31
// @LINE:28
// @LINE:26
// @LINE:25
// @LINE:24
// @LINE:23
// @LINE:22
// @LINE:21
// @LINE:20
// @LINE:19
// @LINE:18
// @LINE:17
// @LINE:16
// @LINE:15
// @LINE:14
// @LINE:13
// @LINE:12
// @LINE:11
// @LINE:10
// @LINE:9
// @LINE:8
// @LINE:7
package controllers.ref {


// @LINE:31
class ReverseAssets {


// @LINE:31
def versioned(path:String, file:Asset): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Assets.versioned(path, file), HandlerDef(this.getClass.getClassLoader, "", "controllers.Assets", "versioned", Seq(classOf[String], classOf[Asset]), "GET", """ Map static resources from the /public folder to the /assets URL path""", _prefix + """assets/$file<.+>""")
)
                      

}
                          

// @LINE:11
// @LINE:10
class ReverseUsers {


// @LINE:11
def browse(uid:String): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Users.browse(uid), HandlerDef(this.getClass.getClassLoader, "", "controllers.Users", "browse", Seq(classOf[String]), "GET", """""", _prefix + """users/$uid<[^/]+>""")
)
                      

// @LINE:10
def index(): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Users.index(), HandlerDef(this.getClass.getClassLoader, "", "controllers.Users", "index", Seq(), "GET", """""", _prefix + """users""")
)
                      

}
                          

// @LINE:28
class ReverseMetrics {


// @LINE:28
def metrics(): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Metrics.metrics(), HandlerDef(this.getClass.getClassLoader, "", "controllers.Metrics", "metrics", Seq(), "GET", """""", _prefix + """metrics""")
)
                      

}
                          

// @LINE:18
// @LINE:17
class ReverseRoomStatistics {


// @LINE:18
def jsonShow(roomId:Long, days:Integer): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.RoomStatistics.jsonShow(roomId, days), HandlerDef(this.getClass.getClassLoader, "", "controllers.RoomStatistics", "jsonShow", Seq(classOf[Long], classOf[Integer]), "GET", """""", _prefix + """rooms/$roomId<[0-9]+>/stats/$days<[^/]+>/days.json""")
)
                      

// @LINE:17
def jsonIndex(days:Integer): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.RoomStatistics.jsonIndex(days), HandlerDef(this.getClass.getClassLoader, "", "controllers.RoomStatistics", "jsonIndex", Seq(classOf[Integer]), "GET", """""", _prefix + """rooms/stats/$days<[^/]+>/days.json""")
)
                      

}
                          

// @LINE:9
// @LINE:7
class ReverseApplication {


// @LINE:9
def show(id:String): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Application.show(id), HandlerDef(this.getClass.getClassLoader, "", "controllers.Application", "show", Seq(classOf[String]), "GET", """""", _prefix + """entries/$id<[^/]+>""")
)
                      

// @LINE:7
def index(): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Application.index(), HandlerDef(this.getClass.getClassLoader, "", "controllers.Application", "index", Seq(), "GET", """""", _prefix + """""")
)
                      

}
                          

// @LINE:26
// @LINE:25
// @LINE:24
// @LINE:23
// @LINE:22
// @LINE:21
// @LINE:20
// @LINE:19
// @LINE:16
// @LINE:15
// @LINE:14
// @LINE:13
// @LINE:12
// @LINE:8
class ReverseRooms {


// @LINE:25
def showWithName(roomName:String, year:Integer, month:Integer, day:Integer): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Rooms.showWithName(roomName, year, month, day), HandlerDef(this.getClass.getClassLoader, "", "controllers.Rooms", "showWithName", Seq(classOf[String], classOf[Integer], classOf[Integer], classOf[Integer]), "GET", """""", _prefix + """rooms/$roomName<[^/]+>/$year<[^/]+>/$month<[^/]+>/$day<[^/]+>""")
)
                      

// @LINE:19
def show(roomId:Long, year:Integer, month:Integer, day:Integer): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Rooms.show(roomId, year, month, day), HandlerDef(this.getClass.getClassLoader, "", "controllers.Rooms", "show", Seq(classOf[Long], classOf[Integer], classOf[Integer], classOf[Integer]), "GET", """""", _prefix + """rooms/$roomId<[0-9]+>/day/$year<[^/]+>/$month<[^/]+>/$day<[^/]+>""")
)
                      

// @LINE:16
def json(roomId:Long): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Rooms.json(roomId), HandlerDef(this.getClass.getClassLoader, "", "controllers.Rooms", "json", Seq(classOf[Long]), "GET", """""", _prefix + """rooms/$roomId<[0-9]+>.json""")
)
                      

// @LINE:22
def jsonWithName(roomName:String): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Rooms.jsonWithName(roomName), HandlerDef(this.getClass.getClassLoader, "", "controllers.Rooms", "jsonWithName", Seq(classOf[String]), "GET", """""", _prefix + """rooms/$roomName<[^/]+>.json""")
)
                      

// @LINE:23
def jsonWithNameAndDate(roomName:String, year:Integer, month:Integer, day:Integer): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Rooms.jsonWithNameAndDate(roomName, year, month, day), HandlerDef(this.getClass.getClassLoader, "", "controllers.Rooms", "jsonWithNameAndDate", Seq(classOf[String], classOf[Integer], classOf[Integer], classOf[Integer]), "GET", """""", _prefix + """rooms/$roomName<[^/]+>/$year<[^/]+>/$month<[^/]+>/$day<[^/]+>.json""")
)
                      

// @LINE:12
def jsonIndex(): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Rooms.jsonIndex(), HandlerDef(this.getClass.getClassLoader, "", "controllers.Rooms", "jsonIndex", Seq(), "GET", """""", _prefix + """rooms.json""")
)
                      

// @LINE:15
def browse(roomId:Long): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Rooms.browse(roomId), HandlerDef(this.getClass.getClassLoader, "", "controllers.Rooms", "browse", Seq(classOf[Long]), "GET", """""", _prefix + """rooms/$roomId<[0-9]+>""")
)
                      

// @LINE:24
def browseWithName(roomName:String): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Rooms.browseWithName(roomName), HandlerDef(this.getClass.getClassLoader, "", "controllers.Rooms", "browseWithName", Seq(classOf[String]), "GET", """""", _prefix + """rooms/$roomName<[^/]+>""")
)
                      

// @LINE:14
def feed(roomId:Long): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Rooms.feed(roomId), HandlerDef(this.getClass.getClassLoader, "", "controllers.Rooms", "feed", Seq(classOf[Long]), "GET", """""", _prefix + """rooms/$roomId<[0-9]+>.atom""")
)
                      

// @LINE:8
def feedAll(): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Rooms.feedAll(), HandlerDef(this.getClass.getClassLoader, "", "controllers.Rooms", "feedAll", Seq(), "GET", """""", _prefix + """all.atom""")
)
                      

// @LINE:13
def index(): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Rooms.index(), HandlerDef(this.getClass.getClassLoader, "", "controllers.Rooms", "index", Seq(), "GET", """""", _prefix + """rooms""")
)
                      

// @LINE:21
def feedWithName(roomName:String): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Rooms.feedWithName(roomName), HandlerDef(this.getClass.getClassLoader, "", "controllers.Rooms", "feedWithName", Seq(classOf[String]), "GET", """""", _prefix + """rooms/$roomName<[^/]+>.atom""")
)
                      

// @LINE:20
def jsonWithDate(roomId:Long, year:Integer, month:Integer, day:Integer): play.api.mvc.HandlerRef[_] = new play.api.mvc.HandlerRef(
   controllers.Rooms.jsonWithDate(roomId, year, month, day), HandlerDef(this.getClass.getClassLoader, "", "controllers.Rooms", "jsonWithDate", Seq(classOf[Long], classOf[Integer], classOf[Integer], classOf[Integer]), "GET", """""", _prefix + """rooms/$roomId<[0-9]+>/$year<[^/]+>/$month<[^/]+>/$day<[^/]+>.json""")
)
                      

}
                          
}
        
    