/*
 * Decompiled with CFR 0.152.
 */
package models.openfire;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import helpers.DateHelper;
import helpers.openfire.OpenFireHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import models.openfire.Room;
import org.joda.time.DateTime;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.F;

@Entity
@Table(name="ofMucConversationLog")
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class LogEntry
extends Model
implements EntityBean {
    @EmbeddedId
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public LogEntryId id;
    @Column(name="roomID", columnDefinition="bigint(20) NULL")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public Long roomId;
    @Column(name="logTime")
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String logTimeString;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String sender;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String nickname;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String subject;
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public String body;
    public static final int PAGE_SIZE = 200;
    @Transient
    @PropertiesEnhancer.GeneratedGetAccessor
    @PropertiesEnhancer.GeneratedSetAccessor
    public DateTime logTime;
    public static Model.Finder<Long, LogEntry> Finder = new Model.Finder("openfire", Long.class, LogEntry.class);
    private static String _EBEAN_MARKER = "models.openfire.LogEntry";

    public LogEntry() {
        DateTime dateTime = null;
        LogEntry logEntry = this;
        logEntry.setLogTime(dateTime);
    }

    public String getSenderName() {
        String string;
        String[] parts;
        String[] stringArray;
        LogEntry logEntry = this;
        String string2 = null;
        string2 = logEntry.getSender();
        if (string2 != null) {
            logEntry = this;
            string2 = null;
            string2 = logEntry.getSender();
            stringArray = string2.split("@", 2);
        } else {
            stringArray = parts = null;
        }
        if (parts != null && parts.length > 0) {
            string = parts[0].trim();
        } else {
            logEntry = this;
            string2 = null;
            string = string2 = logEntry.getSender();
        }
        return string;
    }

    public String getTitle() {
        LogEntry logEntry = this;
        String string = null;
        string = logEntry.getSubject();
        if (string != null) {
            logEntry = this;
            string = null;
            string = logEntry.getSubject();
            return string;
        }
        logEntry = this;
        string = null;
        string = logEntry.getBody();
        return this.getWords(string, 10);
    }

    public String getUpdated() {
        return DateHelper.getIsoDate(this.getDate());
    }

    public String getRoomName() {
        Object object;
        Model model = this;
        Object object2 = null;
        object2 = model.getRoomId();
        Room room = (Room)((Object)Room.Finder.byId(object2));
        if (room != null) {
            model = room;
            object2 = null;
            object = object2 = model.getName();
        } else {
            model = this;
            object2 = null;
            object2 = model.getRoomId();
            object = String.valueOf(object2);
        }
        return object;
    }

    public String getEntryId() {
        LogEntry logEntry = this;
        LogEntryId logEntryId = null;
        logEntryId = logEntry.getId();
        return this.getSenderName() + "_" + logEntryId;
    }

    public int getLineCount() {
        int n;
        LogEntry logEntry = this;
        String string = null;
        string = logEntry.getBody();
        if (string == null) {
            n = 1;
        } else {
            logEntry = this;
            string = null;
            string = logEntry.getBody();
            n = string.split("\n").length;
        }
        return n;
    }

    public List<String> getLines() {
        List<String> list;
        LogEntry logEntry = this;
        String string = null;
        string = logEntry.getBody();
        if (string == null) {
            list = new LinkedList<String>();
        } else {
            logEntry = this;
            string = null;
            string = logEntry.getBody();
            list = Arrays.asList(string.split("\n"));
        }
        return list;
    }

    public DateTime getDateTime() {
        LogEntry logEntry = this;
        Object object = null;
        object = logEntry.getLogTime();
        if (object == null) {
            logEntry = this;
            object = null;
            object = logEntry.getLogTimeString();
            object = new DateTime((Object)OpenFireHelper.getDateFormLogTime((String)object));
            logEntry = this;
            logEntry.setLogTime((DateTime)object);
        }
        logEntry = this;
        object = null;
        object = logEntry.getLogTime();
        return object;
    }

    public Date getDate() {
        return this.getDateTime().toDate();
    }

    public int getYear() {
        return this.getDateTime().getYear();
    }

    public int getMonth() {
        return this.getDateTime().getMonthOfYear();
    }

    public int getDay() {
        return this.getDateTime().getDayOfMonth();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getDateTime().toString());
        LogEntry logEntry = this;
        String string = null;
        string = logEntry.getNickname();
        sb.append(" ").append(string).append(": ");
        logEntry = this;
        string = null;
        string = logEntry.getSubject();
        if (string != null) {
            logEntry = this;
            string = null;
            string = logEntry.getSubject();
            sb.append("[" + string + "]");
        }
        logEntry = this;
        string = null;
        string = logEntry.getBody();
        if (string != null) {
            logEntry = this;
            string = null;
            string = logEntry.getBody();
            sb.append(" ").append(string);
        }
        return sb.toString();
    }

    public static LogEntry findEntry(Room room, String sender, String logTimeString) {
        Room room2 = room;
        Long l = null;
        l = room2.getRoomId();
        return (LogEntry)((Object)Finder.where().eq("roomId", (Object)l).eq("logTimeString", (Object)logTimeString).findUnique());
    }

    public static List<LogEntry> getEntries(Integer page, String order) {
        int p = page != null ? page : 1;
        List entries = Finder.where().order("logTimeString " + order).findPagingList(200).getPage(p - 1).getList();
        return entries;
    }

    public static LogEntry getLastEntry() {
        return (LogEntry)((Object)Finder.setMaxRows(1).where().order("logTimeString DESC").findUnique());
    }

    public static List<LogEntry> getAllEntriesFromTo(Long from, Long to) {
        String fromStr = OpenFireHelper.getLogTimeFromMillis(from);
        String toStr = OpenFireHelper.getLogTimeFromMillis(to);
        List entries = Finder.where("logTimeString > :fromStr AND logTimeString < :toStr ").setParameter("fromStr", (Object)fromStr).setParameter("toStr", (Object)toStr).order("logTimeString ASC").findList();
        return entries;
    }

    private String getWords(String content, int count) {
        StringBuilder sb = new StringBuilder();
        if (content != null) {
            String[] parts = content.split(" ");
            for (int i = 0; i < Math.min(parts.length, count); ++i) {
                sb.append(parts[i]).append(" ");
            }
        }
        return sb.toString();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public LogEntryId getId() {
        return this._ebean_get_id();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setId(LogEntryId logEntryId) {
        this._ebean_set_id(logEntryId);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public Long getRoomId() {
        return this._ebean_get_roomId();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setRoomId(Long l) {
        this._ebean_set_roomId(l);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getLogTimeString() {
        return this._ebean_get_logTimeString();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setLogTimeString(String string) {
        this._ebean_set_logTimeString(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getSender() {
        return this._ebean_get_sender();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setSender(String string) {
        this._ebean_set_sender(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getNickname() {
        return this._ebean_get_nickname();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setNickname(String string) {
        this._ebean_set_nickname(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getSubject() {
        return this._ebean_get_subject();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setSubject(String string) {
        this._ebean_set_subject(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public String getBody() {
        return this._ebean_get_body();
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setBody(String string) {
        this._ebean_set_body(string);
    }

    @PropertiesEnhancer.GeneratedAccessor
    public DateTime getLogTime() {
        return this.logTime;
    }

    @PropertiesEnhancer.GeneratedAccessor
    public void setLogTime(DateTime dateTime) {
        this.logTime = dateTime;
    }

    public String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    protected LogEntryId _ebean_get_id() {
        return this.id;
    }

    protected void _ebean_set_id(LogEntryId newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "id", (Object)this._ebean_get_id(), (Object)newValue);
        this.id = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected LogEntryId _ebean_getni_id() {
        return this.id;
    }

    protected void _ebean_setni_id(LogEntryId _newValue) {
        this.id = _newValue;
    }

    protected Long _ebean_get_roomId() {
        this._ebean_intercept.preGetter("roomId");
        return this.roomId;
    }

    protected void _ebean_set_roomId(Long newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "roomId", (Object)this._ebean_get_roomId(), (Object)newValue);
        this.roomId = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected Long _ebean_getni_roomId() {
        return this.roomId;
    }

    protected void _ebean_setni_roomId(Long _newValue) {
        this.roomId = _newValue;
    }

    protected String _ebean_get_logTimeString() {
        this._ebean_intercept.preGetter("logTimeString");
        return this.logTimeString;
    }

    protected void _ebean_set_logTimeString(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "logTimeString", (Object)this._ebean_get_logTimeString(), (Object)newValue);
        this.logTimeString = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_logTimeString() {
        return this.logTimeString;
    }

    protected void _ebean_setni_logTimeString(String _newValue) {
        this.logTimeString = _newValue;
    }

    protected String _ebean_get_sender() {
        this._ebean_intercept.preGetter("sender");
        return this.sender;
    }

    protected void _ebean_set_sender(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "sender", (Object)this._ebean_get_sender(), (Object)newValue);
        this.sender = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_sender() {
        return this.sender;
    }

    protected void _ebean_setni_sender(String _newValue) {
        this.sender = _newValue;
    }

    protected String _ebean_get_nickname() {
        this._ebean_intercept.preGetter("nickname");
        return this.nickname;
    }

    protected void _ebean_set_nickname(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "nickname", (Object)this._ebean_get_nickname(), (Object)newValue);
        this.nickname = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_nickname() {
        return this.nickname;
    }

    protected void _ebean_setni_nickname(String _newValue) {
        this.nickname = _newValue;
    }

    protected String _ebean_get_subject() {
        this._ebean_intercept.preGetter("subject");
        return this.subject;
    }

    protected void _ebean_set_subject(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "subject", (Object)this._ebean_get_subject(), (Object)newValue);
        this.subject = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_subject() {
        return this.subject;
    }

    protected void _ebean_setni_subject(String _newValue) {
        this.subject = _newValue;
    }

    protected String _ebean_get_body() {
        this._ebean_intercept.preGetter("body");
        return this.body;
    }

    protected void _ebean_set_body(String newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "body", (Object)this._ebean_get_body(), (Object)newValue);
        this.body = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected String _ebean_getni_body() {
        return this.body;
    }

    protected void _ebean_setni_body(String _newValue) {
        this.body = _newValue;
    }

    protected DateTime _ebean_get_logTime() {
        return this.logTime;
    }

    protected void _ebean_set_logTime(DateTime newValue) {
        PropertyChangeEvent evt = this._ebean_intercept.preSetter(false, "logTime", (Object)this._ebean_get_logTime(), (Object)newValue);
        this.logTime = newValue;
        this._ebean_intercept.postSetter(evt);
    }

    protected DateTime _ebean_getni_logTime() {
        return this.logTime;
    }

    protected void _ebean_setni_logTime(DateTime _newValue) {
        this.logTime = _newValue;
    }

    /*
     * WARNING - void declaration
     */
    public Object _ebean_createCopy() {
        void p;
        LogEntry logEntry = new LogEntry();
        logEntry.id = this.id;
        logEntry.roomId = this.roomId;
        logEntry.logTimeString = this.logTimeString;
        logEntry.sender = this.sender;
        logEntry.nickname = this.nickname;
        logEntry.subject = this.subject;
        logEntry.body = this.body;
        return p;
    }

    public Object _ebean_getField(int index2, Object o) {
        LogEntry p = (LogEntry)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_getni__idGetSet();
            }
            case 1: {
                return p.id;
            }
            case 2: {
                return p.roomId;
            }
            case 3: {
                return p.logTimeString;
            }
            case 4: {
                return p.sender;
            }
            case 5: {
                return p.nickname;
            }
            case 6: {
                return p.subject;
            }
            case 7: {
                return p.body;
            }
            case 8: {
                return p.logTime;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public Object _ebean_getFieldIntercept(int index2, Object o) {
        LogEntry p = (LogEntry)((Object)o);
        switch (index2) {
            case 0: {
                return p._ebean_get__idGetSet();
            }
            case 1: {
                return p._ebean_get_id();
            }
            case 2: {
                return p._ebean_get_roomId();
            }
            case 3: {
                return p._ebean_get_logTimeString();
            }
            case 4: {
                return p._ebean_get_sender();
            }
            case 5: {
                return p._ebean_get_nickname();
            }
            case 6: {
                return p._ebean_get_subject();
            }
            case 7: {
                return p._ebean_get_body();
            }
            case 8: {
                return p._ebean_get_logTime();
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setField(int index2, Object o, Object arg) {
        LogEntry p = (LogEntry)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_setni__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p.id = (LogEntryId)arg;
                return;
            }
            case 2: {
                p.roomId = (Long)arg;
                return;
            }
            case 3: {
                p.logTimeString = (String)arg;
                return;
            }
            case 4: {
                p.sender = (String)arg;
                return;
            }
            case 5: {
                p.nickname = (String)arg;
                return;
            }
            case 6: {
                p.subject = (String)arg;
                return;
            }
            case 7: {
                p.body = (String)arg;
                return;
            }
            case 8: {
                p.logTime = (DateTime)arg;
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
        LogEntry p = (LogEntry)((Object)o);
        switch (index2) {
            case 0: {
                p._ebean_set__idGetSet((F.Tuple)arg);
                return;
            }
            case 1: {
                p._ebean_set_id((LogEntryId)arg);
                return;
            }
            case 2: {
                p._ebean_set_roomId((Long)arg);
                return;
            }
            case 3: {
                p._ebean_set_logTimeString((String)arg);
                return;
            }
            case 4: {
                p._ebean_set_sender((String)arg);
                return;
            }
            case 5: {
                p._ebean_set_nickname((String)arg);
                return;
            }
            case 6: {
                p._ebean_set_subject((String)arg);
                return;
            }
            case 7: {
                p._ebean_set_body((String)arg);
                return;
            }
            case 8: {
                p._ebean_set_logTime((DateTime)arg);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index2);
    }

    public String[] _ebean_getFieldNames() {
        return new String[]{"_idGetSet", "id", "roomId", "logTimeString", "sender", "nickname", "subject", "body", "logTime"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _ebean_getIdentity() {
        LogEntry logEntry = this;
        synchronized (logEntry) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(1, (Object)this);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((LogEntry)((Object)obj))._ebean_getIdentity());
    }

    public int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public void _ebean_setEmbeddedLoaded() {
    }

    public boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public Object _ebean_newInstance() {
        return new LogEntry();
    }

    @Embeddable
    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public class LogEntryId
    implements EntityBean {
        @Column(name="roomID", columnDefinition="bigint(20) NULL")
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public Long roomId;
        @Column(name="logTime")
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public String logTimeString;
        final /* synthetic */ LogEntry this$0;
        private static String _EBEAN_MARKER = "models.openfire.LogEntry$LogEntryId";
        protected EntityBeanIntercept _ebean_intercept;
        protected transient Object _ebean_identity;

        public LogEntryId(LogEntry this$0) {
            this.this$0 = this$0;
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }

        public int hashCode() {
            LogEntryId logEntryId = this;
            Object object = null;
            object = logEntryId.getLogTimeString();
            int n = 1013 * ((String)object).hashCode();
            logEntryId = this;
            object = null;
            object = logEntryId.getRoomId();
            return n ^ 1009 * ((Long)object).hashCode();
        }

        public String toString() {
            LogEntryId logEntryId = this;
            Object object = null;
            object = logEntryId.getRoomId();
            StringBuilder stringBuilder = new StringBuilder().append(object).append("_");
            logEntryId = this;
            object = null;
            object = logEntryId.getLogTimeString();
            return stringBuilder.append((String)object).toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof LogEntryId)) {
                return false;
            }
            LogEntryId other = (LogEntryId)obj;
            LogEntryId logEntryId = this;
            Object object = null;
            object = logEntryId.getRoomId();
            Long l = object;
            logEntryId = other;
            object = null;
            object = logEntryId.getRoomId();
            if (!l.equals(object)) return false;
            logEntryId = this;
            object = null;
            Object object2 = object = logEntryId.getLogTimeString();
            logEntryId = other;
            object = null;
            object = logEntryId.getLogTimeString();
            if (!((String)object2).equals(object)) return false;
            return true;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public Long getRoomId() {
            return this._ebean_get_roomId();
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setRoomId(Long l) {
            this._ebean_set_roomId(l);
        }

        @PropertiesEnhancer.GeneratedAccessor
        public String getLogTimeString() {
            return this._ebean_get_logTimeString();
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setLogTimeString(String string) {
            this._ebean_set_logTimeString(string);
        }

        public LogEntryId() {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }

        public String _ebean_getMarker() {
            return _EBEAN_MARKER;
        }

        public EntityBeanIntercept _ebean_getIntercept() {
            return this._ebean_intercept;
        }

        public EntityBeanIntercept _ebean_intercept() {
            if (this._ebean_intercept == null) {
                this._ebean_intercept = new EntityBeanIntercept((Object)this);
            }
            return this._ebean_intercept;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this._ebean_intercept.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
            this._ebean_intercept.addPropertyChangeListener(name, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this._ebean_intercept.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
            this._ebean_intercept.removePropertyChangeListener(name, listener);
        }

        protected Long _ebean_get_roomId() {
            this._ebean_intercept.preGetter("roomId");
            return this.roomId;
        }

        protected void _ebean_set_roomId(Long newValue) {
            PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "roomId", (Object)this._ebean_get_roomId(), (Object)newValue);
            this.roomId = newValue;
            this._ebean_intercept.postSetter(evt);
        }

        protected Long _ebean_getni_roomId() {
            return this.roomId;
        }

        protected void _ebean_setni_roomId(Long _newValue) {
            this.roomId = _newValue;
        }

        protected String _ebean_get_logTimeString() {
            this._ebean_intercept.preGetter("logTimeString");
            return this.logTimeString;
        }

        protected void _ebean_set_logTimeString(String newValue) {
            PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "logTimeString", (Object)this._ebean_get_logTimeString(), (Object)newValue);
            this.logTimeString = newValue;
            this._ebean_intercept.postSetter(evt);
        }

        protected String _ebean_getni_logTimeString() {
            return this.logTimeString;
        }

        protected void _ebean_setni_logTimeString(String _newValue) {
            this.logTimeString = _newValue;
        }

        protected LogEntry _ebean_get_this$0() {
            this._ebean_intercept.preGetter("this$0");
            return this.this$0;
        }

        protected void _ebean_set_this$0(LogEntry newValue) {
            PropertyChangeEvent evt = this._ebean_intercept.preSetter(true, "this$0", (Object)this._ebean_get_this$0(), (Object)newValue);
            this.this$0 = newValue;
            this._ebean_intercept.postSetter(evt);
        }

        protected LogEntry _ebean_getni_this$0() {
            return this.this$0;
        }

        protected void _ebean_setni_this$0(LogEntry _newValue) {
            this.this$0 = _newValue;
        }

        public Object _ebean_createCopy() {
            LogEntryId p = new LogEntryId();
            p.roomId = this.roomId;
            p.logTimeString = this.logTimeString;
            p.this$0 = this.this$0;
            return p;
        }

        public Object _ebean_getField(int index2, Object o) {
            LogEntryId p = (LogEntryId)o;
            switch (index2) {
                case 0: {
                    return p.roomId;
                }
                case 1: {
                    return p.logTimeString;
                }
                case 2: {
                    return p.this$0;
                }
            }
            throw new RuntimeException("Invalid index " + index2);
        }

        public Object _ebean_getFieldIntercept(int index2, Object o) {
            LogEntryId p = (LogEntryId)o;
            switch (index2) {
                case 0: {
                    return p._ebean_get_roomId();
                }
                case 1: {
                    return p._ebean_get_logTimeString();
                }
                case 2: {
                    return p._ebean_get_this$0();
                }
            }
            throw new RuntimeException("Invalid index " + index2);
        }

        public void _ebean_setField(int index2, Object o, Object arg) {
            LogEntryId p = (LogEntryId)o;
            switch (index2) {
                case 0: {
                    p.roomId = (Long)arg;
                    return;
                }
                case 1: {
                    p.logTimeString = (String)arg;
                    return;
                }
                case 2: {
                    p.this$0 = (LogEntry)((Object)arg);
                    return;
                }
            }
            throw new RuntimeException("Invalid index " + index2);
        }

        public void _ebean_setFieldIntercept(int index2, Object o, Object arg) {
            LogEntryId p = (LogEntryId)o;
            switch (index2) {
                case 0: {
                    p._ebean_set_roomId((Long)arg);
                    return;
                }
                case 1: {
                    p._ebean_set_logTimeString((String)arg);
                    return;
                }
                case 2: {
                    p._ebean_set_this$0((LogEntry)((Object)arg));
                    return;
                }
            }
            throw new RuntimeException("Invalid index " + index2);
        }

        public String[] _ebean_getFieldNames() {
            return new String[]{"roomId", "logTimeString", "this$0"};
        }

        public void _ebean_setEmbeddedLoaded() {
        }

        public boolean _ebean_isEmbeddedNewOrDirty() {
            return false;
        }

        public Object _ebean_newInstance() {
            return new LogEntryId();
        }
    }
}

