package models.contactix;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;

import com.avaje.ebean.Model;

/**
 * Created by philipp on 12.03.14.
 */
@Entity
@Table(name = "groups")
public class Group extends Model {
	@Id
	public Integer id;
	@Column(columnDefinition = "tinyint(1) NULL")
	public Integer disabled;
	@Column(columnDefinition = " int(11) NULL")
	public Integer gid;

	public String name;

	@Column(name = "created_at")
	public Date createdAt = new Date();
	@Column(name = "updated_at")
	public Date updatedAt = new Date();

	@ManyToMany()
	@JoinTable(name = "groups_users", 
	joinColumns = { 
			@JoinColumn(name = "group_id", referencedColumnName = "id") 
			}, 
	inverseJoinColumns = { 
			@JoinColumn(name = "user_id", referencedColumnName = "id") 
			}
	)
	public List<User> users = new ArrayList<User>();

	public static Finder<Integer, Group> find = new Finder<Integer, Group>(
			"contactix", Integer.class, Group.class);
}
