package models.contactix;

import javax.persistence.Column;
import javax.persistence.Embeddable;

/**
 * Created by philipp on 12.03.14.
 */
@Embeddable
public class GroupUserKey {
    @Column(name = "user_id", columnDefinition = "int(11)")
    public Integer userId;
    @Column(name = "group_id", columnDefinition = "int(11)")
    public Integer groupId;

    public int hashCode() {
        int hash = 1;
        hash = hash * 17 + userId;
        hash = hash * 31 + groupId;
        return hash;
    }

    public boolean equals(Object obj) {
        GroupUserKey otherKey = (GroupUserKey) obj;
        return groupId.equals(otherKey.groupId) && userId.equals(otherKey.userId);
    }
}
