package models.contactix;

import java.text.SimpleDateFormat;

/**
 * Created by philipp on 09.03.14.
 */

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import com.avaje.ebean.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;

import models.consum.Client;
import play.Logger;
import play.libs.Json;

@Entity
@Table(name = "users")
public class User extends Model {

	@Id
	public Integer id;
	@Column(columnDefinition = "tinyint(1) NULL")
	public Integer disabled;
	@Column(name = "access_to_concordia", columnDefinition = "tinyint(1) NULL")
	public Integer accessToConcordia;
	@Column(name = "access_to_cosima", columnDefinition = "tinyint(1) NULL")
	public Integer accessToCosima;
	@Column(name = "access_to_chaos", columnDefinition = "tinyint(1) NULL")
	public Integer accessToChaos;
	@Column(columnDefinition = "int(11) NULL")
	public Integer uid;
	@Column(columnDefinition = "int(11) NULL")
	public Integer gid;
	@Column(columnDefinition = "int(11) NULL")
	public Integer max;
	@Column(columnDefinition = "int(11) NULL")
	public Integer min;
	@Column(columnDefinition = "int(11) NULL")
	public Integer warn;
	@Column(name = "responsible_client_id", columnDefinition = "int(11)")
	public Integer responsibleClientId;

	public String name;
	public String forename;
	public String surname;
	@Column(name = "alt_name", columnDefinition = "varchar(40) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL")
	public String altName;
	@Column(name = "home_dir", columnDefinition = "varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL")
	public String homeDir;
	@Column(columnDefinition = "varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL")
	public String shell;
	@Column(columnDefinition = "varchar(1024) CHARACTER SET utf8 COLLATE utf8_unicode_ci NULL")
	public String annotations;
	@Column(name = "created_at")
	public Date createdAt = new Date();
	@Column(name = "updated_at")
	public Date updatedAt = new Date();

	@OneToMany(mappedBy = "user", cascade = CascadeType.ALL)
	public List<Address> addresses;

	@OneToMany(mappedBy = "user", cascade = CascadeType.ALL)
	public List<PhoneNumber> phoneNumbers;
	
	@ManyToMany()
	@JoinTable(name = "groups_users", 
	joinColumns = { 
			@JoinColumn(name = "user_id", referencedColumnName = "id") 
			}, 
			inverseJoinColumns = { @JoinColumn(name = "group_id", referencedColumnName = "id") 
			}
	)
	
	private final static SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
	
	public List<Group> groups = new ArrayList<Group>();

	public static Finder<Integer, User> find = new Finder<Integer, User>("contactix", Integer.class, User.class);
	
	public Address getPreferedAddress() {
		return Address.find.where().eq("user_id", id).eq("preferred", "1").findUnique();
	}
	
	public List<Address> getAddresses() {
		return Address.find.where().eq("user_id", id).order("preferred DESC").findList();
	}
	
	public PhoneNumber getPreferedPhoneNumber() {
		return PhoneNumber.find.where().eq("user_id", id).eq("preferred", "1").findUnique();
	}
	
	public Integer getClientNo() {
		Client client = Client.find.where().eq("user_id", id).findUnique();
		return client == null ? null : client.clientNo;
	}
	
	@Override
	public String toString() {
		return this.id+" "+this.name + " " + this.forename + " " + this.surname + " ("
				+ this.altName + ")";
	}
	
	public ObjectNode toJson() {
		ObjectNode result = Json.newObject();
		result.put("id", id);
		result.put("createdAt", DATETIME_FORMAT.format(createdAt));
		result.put("updatedAt", DATETIME_FORMAT.format(updatedAt));
		result.put("forename", forename);
		result.put("surname", surname);
		result.put("name", name);
		result.put("altName", altName);
		result.put("responsibleClientId", responsibleClientId);
		return result;
	}
}
