/**
 * IpCache 14.04.2013
 *
 * @author Philipp Haussleiter
 *
 */
package de.javastream.java.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IpCache {

    private final static Logger LOG = Logger.getLogger(IpCache.class.getSimpleName());
    private static IpCache instance = null;

    private IpCache() {
    }

    public static IpCache getInstance() {
        if (instance == null) {
            instance = new IpCache();
        }
        return instance;
    }

    public List<String> getLocalIpv4s() {
        String ip;
        List<String> ips = new ArrayList<String>();
        // is always local :-)
        ips.add("127.0.0.1");
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface current = interfaces.nextElement();
                if (!current.isUp() || current.isLoopback() || current.isVirtual()) {
                    continue;
                }
                Enumeration<InetAddress> addresses = current.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress current_addr = addresses.nextElement();
                    ip = current_addr.getHostAddress().trim();
                    // Filter LoopBack and ipv6
                    if (ip == null
                            || ip.startsWith("fe")
                            || ip.length() > 15
                            || current_addr.isLoopbackAddress()) {
                        continue;
                    } else {
                        ips.add(ip);
                    }
                }
            }
            LOG.log(Level.FINER, "found {0} local ips", ips.size());
        } catch (SocketException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        return ips;
    }
}
