/*
 * Decompiled with CFR 0.152.
 */
package de.javastream.java.net.jmac;

import de.javastream.java.net.IpCache;
import de.javastream.java.net.jmac.UnsupportedOperatingSystemException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MacCache {
    private static final Logger LOG = Logger.getLogger(MacCache.class.getSimpleName());
    private static MacCache instance = null;
    private static final String ETHER = "ether";
    private static final String INET = "inet";
    private List<String> localIps = IpCache.getInstance().getLocalIpv4s();

    private MacCache() {
    }

    public static MacCache getInstance() {
        if (instance == null) {
            instance = new MacCache();
        }
        return instance;
    }

    public String getMacFromAddress(String localAddress) throws UnsupportedOperatingSystemException {
        String[] arpCommand;
        String foundMacAddress = null;
        String operatingSystemName = System.getProperty("os.name");
        if (operatingSystemName.startsWith("Windows")) {
            arpCommand = new String[]{"arp", "-a", localAddress};
        } else if (operatingSystemName.startsWith("Linux") || operatingSystemName.startsWith("HP-UX")) {
            arpCommand = new String[]{"arp", "-n", "-a", localAddress};
        } else if (operatingSystemName.startsWith("Mac")) {
            if (this.localIps.contains(localAddress)) {
                return this.getMacAddressForMac(localAddress);
            }
            arpCommand = new String[]{"arp", "-n", localAddress};
        } else {
            throw new UnsupportedOperatingSystemException("The current operating system '" + operatingSystemName + "' is not supported.");
        }
        Pattern macAddressPattern = Pattern.compile("([a-fA-F0-9]{1,2}(-|:)){5}[a-fA-F0-9]{1,2}");
        try {
            String rawOutput;
            Process process = Runtime.getRuntime().exec(arpCommand);
            process.getOutputStream().close();
            BufferedReader inputBuffer = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((rawOutput = inputBuffer.readLine()) != null) {
                Matcher matcher = macAddressPattern.matcher(rawOutput);
                if (!matcher.find()) continue;
                foundMacAddress = matcher.group();
                break;
            }
        }
        catch (IOException e) {
            LOG.warning(e.getLocalizedMessage());
        }
        return this.normalize(foundMacAddress);
    }

    private String normalize(String foundMacAddress) {
        if (foundMacAddress != null && (foundMacAddress = foundMacAddress.replace(':', '-')).length() != 17) {
            String[] addressPortions = foundMacAddress.split("-");
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (true) {
                String currentPortion;
                if ((currentPortion = addressPortions[i]).length() == 1) {
                    buffer.append("0");
                }
                buffer.append(currentPortion);
                if (++i == addressPortions.length) break;
                buffer.append("-");
            }
            foundMacAddress = buffer.toString();
        }
        return foundMacAddress;
    }

    private String getMacAddressForMac(String localAddress) {
        String ether = null;
        String[] arpCommand = new String[]{"ifconfig", "-a"};
        try {
            String rawOutput;
            Process process = Runtime.getRuntime().exec(arpCommand);
            process.getOutputStream().close();
            BufferedReader inputBuffer = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((rawOutput = inputBuffer.readLine()) != null) {
                if (rawOutput.trim().startsWith(ETHER)) {
                    ether = rawOutput.replace(ETHER, "").trim();
                }
                if (!rawOutput.trim().startsWith(INET) || !rawOutput.replace(INET, "").trim().startsWith(localAddress)) continue;
                return this.normalize(ether);
            }
        }
        catch (IOException e) {
            LOG.warning(e.getLocalizedMessage());
        }
        return null;
    }

    public static String get(String localAddress) {
        try {
            return MacCache.getInstance().getMacFromAddress(localAddress);
        }
        catch (UnsupportedOperatingSystemException e) {
            return null;
        }
    }
}

