/**
 * @file Copyright (c) 2011 jdknight
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package de.javastream.java.net.utils;

import de.javastream.java.net.jmac.MacCache;

/**
 * jmac (Java MAC) main class.
 */
public final class JMac {

    /**
     * Private constructor.
     *
     */
    private JMac() {
    }

    /**
     * JMac line for jmac (Java MAC).
     *
     * @param arguments Arguments.
     */
    public static void main(String[] arguments) {
        if (arguments.length != 1) {
            System.out.println();
            System.out.println("Usage: jmac <address>");
            System.out.println();
        } else {
            System.out.println(MacCache.get(arguments[0]));
        }
    }
}
