/*
 * Decompiled with CFR 0.152.
 */
package gr.xe.conf;

import gr.xe.conf.lines.CommentLine;
import gr.xe.conf.lines.LineReader;
import gr.xe.conf.lines.PathLine;
import gr.xe.conf.lines.ValueLine;
import gr.xe.conf.tree.ConfNode;
import gr.xe.conf.tree.PathNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfReader {
    private static final Logger logger = LoggerFactory.getLogger(ConfReader.class);
    private ConfNode rootNode = new PathNode(null);
    private List<LineReader> readers = new ArrayList<LineReader>();

    public ConfReader() {
        this.readers.add(new CommentLine());
        this.readers.add(new PathLine());
        this.readers.add(new ValueLine());
    }

    public void readFile(InputStream in) throws IOException {
        List lines = IOUtils.readLines((InputStream)in);
        for (String line : lines) {
            boolean ok;
            if (StringUtils.isBlank((String)line) || (ok = this.process(line))) continue;
            logger.warn("Unknown line {}", (Object)line);
        }
    }

    private boolean process(String line) {
        for (LineReader reader : this.readers) {
            if (!reader.matches(line)) continue;
            this.rootNode = reader.process(this.rootNode, line);
            return true;
        }
        return false;
    }

    public String readValue(String path) {
        ConfNode node = this.followPath(path);
        if (node != null) {
            return node.getValue();
        }
        return null;
    }

    public Set<String> readKeys(String path) {
        ConfNode node = this.followPath(path);
        if (node != null) {
            return node.getChildren().keySet();
        }
        return new HashSet<String>();
    }

    public boolean keyExists(String path) {
        return this.followPath(path) != null;
    }

    private ConfNode followPath(String path) {
        String[] paths = path.split("\\.");
        ConfNode start = this.rootNode;
        for (String pathName : paths) {
            if (!start.getChildren().containsKey(pathName)) {
                return null;
            }
            start = start.getChildren().get(pathName);
        }
        return start;
    }
}

