/*
 * Decompiled with CFR 0.152.
 */
package gr.xe.conf.lines;

import gr.xe.conf.lines.LineReader;
import gr.xe.conf.tree.ConfNode;
import gr.xe.conf.tree.PathNode;
import org.apache.commons.lang.StringUtils;

public class PathLine
implements LineReader {
    private ConfNode now = null;
    private String line = null;

    @Override
    public boolean matches(String line) {
        return line.trim().startsWith("<");
    }

    @Override
    public ConfNode process(ConfNode where, String textline) {
        this.line = textline.trim();
        this.now = where;
        if (this.line.startsWith("</")) {
            return this.closeTag();
        }
        return this.openTag();
    }

    private ConfNode openTag() {
        String name = StringUtils.substringBetween((String)this.line, (String)"<", (String)">");
        if (this.now.getChildren().containsKey(name)) {
            return this.now.getChildren().get(name);
        }
        PathNode newNode = new PathNode(this.now);
        newNode.setName(name);
        this.now.getChildren().put(name, newNode);
        return newNode;
    }

    private ConfNode closeTag() {
        return this.now.getParent();
    }
}

