# --- Created by Ebean DDL
# To stop Ebean DDL generation, remove this comment and start using Evolutions

# --- !Ups

create table color (
  id                            bigint not null,
  r                             integer,
  g                             integer,
  b                             integer,
  hex                           varchar(255),
  constraint pk_color primary key (id)
);
create sequence color_seq;

create table image (
  id                            bigint not null,
  checksum                      varchar(255),
  name                          varchar(255),
  extension                     varchar(255),
  image_path                    varchar(255),
  thumbnail_path                varchar(255),
  ref_image_path                varchar(255),
  sobel_image_path              varchar(255),
  image_width                   integer,
  image_height                  integer,
  thumbnail_width               integer,
  thumbnail_height              integer,
  main_color                    varchar(255),
  avg_color                     varchar(255),
  med_color                     varchar(255),
  signature                     TEXT,
  created                       timestamp,
  constraint pk_image primary key (id)
);
create sequence image_seq;

create table image_color (
  id                            bigint not null,
  color_id                      bigint,
  image_id                      bigint,
  count                         integer,
  constraint pk_image_color primary key (id)
);
create sequence image_color_seq;

alter table image_color add constraint fk_image_color_color_id foreign key (color_id) references color (id) on delete restrict on update restrict;
create index ix_image_color_color_id on image_color (color_id);

alter table image_color add constraint fk_image_color_image_id foreign key (image_id) references image (id) on delete restrict on update restrict;
create index ix_image_color_image_id on image_color (image_id);


# --- !Downs

alter table image_color drop constraint if exists fk_image_color_color_id;
drop index if exists ix_image_color_color_id;

alter table image_color drop constraint if exists fk_image_color_image_id;
drop index if exists ix_image_color_image_id;

drop table if exists color;
drop sequence if exists color_seq;

drop table if exists image;
drop sequence if exists image_seq;

drop table if exists image_color;
drop sequence if exists image_color_seq;

