/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;

public class MessageInfo {
    private Message message;

    public String getBcc() throws MessagingException {
        return this.formatAddresses(this.message.getRecipients(Message.RecipientType.BCC));
    }

    public String getBody() throws MessagingException, IOException {
        Object content = this.message.getContent();
        if (this.message.isMimeType("text/plain")) {
            return (String)content;
        }
        if (this.message.isMimeType("multipart/alternative")) {
            Multipart mp = (Multipart)this.message.getContent();
            int numParts = mp.getCount();
            for (int i = 0; i < numParts; ++i) {
                if (!mp.getBodyPart(i).isMimeType("text/plain")) continue;
                return (String)mp.getBodyPart(i).getContent();
            }
            return "";
        }
        if (this.message.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)content;
            if (mp.getBodyPart(0).isMimeType("text/plain")) {
                return (String)mp.getBodyPart(0).getContent();
            }
            return "";
        }
        return "";
    }

    public String getCc() throws MessagingException {
        return this.formatAddresses(this.message.getRecipients(Message.RecipientType.CC));
    }

    public String getDate() throws MessagingException {
        SimpleDateFormat df = new SimpleDateFormat("EE M/d/yy");
        Date date = this.message.getSentDate();
        if (date != null) {
            return df.format(date);
        }
        date = this.message.getReceivedDate();
        if (date != null) {
            return df.format(date);
        }
        return "";
    }

    public String getFrom() throws MessagingException {
        return this.formatAddresses(this.message.getFrom());
    }

    public String getReplyTo() throws MessagingException {
        Address[] a = this.message.getReplyTo();
        if (a.length > 0) {
            return ((InternetAddress)a[0]).getAddress();
        }
        return "";
    }

    public Message getMessage() {
        return this.message;
    }

    public String getNum() {
        return Integer.toString(this.message.getMessageNumber());
    }

    public String getReceivedDate() throws MessagingException {
        if (this.hasReceivedDate()) {
            return this.message.getReceivedDate().toString();
        }
        return "";
    }

    public String getSentDate() throws MessagingException {
        if (this.hasSentDate()) {
            return this.message.getSentDate().toString();
        }
        return "";
    }

    public String getSubject() throws MessagingException {
        if (this.hasSubject()) {
            return this.message.getSubject();
        }
        return "";
    }

    public String getTo() throws MessagingException {
        return this.formatAddresses(this.message.getRecipients(Message.RecipientType.TO));
    }

    public boolean hasAttachments() throws IOException, MessagingException {
        Multipart mp;
        boolean hasAttachments = false;
        if (this.message.isMimeType("multipart/*") && (mp = (Multipart)this.message.getContent()).getCount() > 1) {
            hasAttachments = true;
        }
        return hasAttachments;
    }

    public boolean hasBcc() throws MessagingException {
        return this.message.getRecipients(Message.RecipientType.BCC) != null;
    }

    public boolean hasCc() throws MessagingException {
        return this.message.getRecipients(Message.RecipientType.CC) != null;
    }

    public boolean hasDate() throws MessagingException {
        return this.hasSentDate() || this.hasReceivedDate();
    }

    public boolean hasFrom() throws MessagingException {
        return this.message.getFrom() != null;
    }

    public boolean hasMimeType(String mimeType) throws MessagingException {
        return this.message.isMimeType(mimeType);
    }

    public boolean hasReceivedDate() throws MessagingException {
        return this.message.getReceivedDate() != null;
    }

    public boolean hasSentDate() throws MessagingException {
        return this.message.getSentDate() != null;
    }

    public boolean hasSubject() throws MessagingException {
        return this.message.getSubject() != null;
    }

    public boolean hasTo() throws MessagingException {
        return this.message.getRecipients(Message.RecipientType.TO) != null;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    private String formatAddresses(Address[] addrs) {
        if (addrs == null) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer(this.getDisplayAddress(addrs[0]));
        for (int i = 1; i < addrs.length; ++i) {
            strBuf.append(", ").append(this.getDisplayAddress(addrs[i]));
        }
        return strBuf.toString();
    }

    private String getDisplayAddress(Address a) {
        String pers = null;
        String addr = null;
        addr = a instanceof InternetAddress && (pers = ((InternetAddress)a).getPersonal()) != null ? pers + "  &lt;" + ((InternetAddress)a).getAddress() + "&gt;" : a.toString();
        return addr;
    }
}

