/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class SimpleClient {
    static Vector url = new Vector();
    static FolderViewer fv;
    static MessageViewer mv;

    public static void main(String[] argv) {
        boolean usage = false;
        for (int optind = 0; optind < argv.length; ++optind) {
            if (!argv[optind].equals("-L")) {
                if (argv[optind].startsWith("-")) {
                    usage = true;
                    break;
                }
                usage = true;
                break;
            }
            url.addElement(argv[++optind]);
        }
        if (usage || url.size() == 0) {
            System.out.println("Usage: SimpleClient -L url");
            System.out.println("   where url is protocol://username:password@hostname/");
            System.exit(1);
        }
        try {
            File capfile = new File("simple.mailcap");
            if (!capfile.isFile()) {
                System.out.println("Cannot locate the \"simple.mailcap\" file.");
                System.exit(1);
            }
            CommandMap.setDefaultCommandMap((CommandMap)new MailcapCommandMap((InputStream)new FileInputStream(capfile)));
            JFrame frame = new JFrame("Simple JavaMail Client");
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            SimpleAuthenticator auth = new SimpleAuthenticator(frame);
            Session session = Session.getDefaultInstance((Properties)System.getProperties(), (Authenticator)auth);
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
            Enumeration e = url.elements();
            while (e.hasMoreElements()) {
                String urlstring = (String)e.nextElement();
                URLName urln = new URLName(urlstring);
                Store store = session.getStore(urln);
                StoreTreeNode storenode = new StoreTreeNode(store);
                root.add(storenode);
            }
            DefaultTreeModel treeModel = new DefaultTreeModel(root);
            JTree tree = new JTree(treeModel);
            tree.addTreeSelectionListener(new TreePress());
            JScrollPane sp = new JScrollPane();
            sp.setPreferredSize(new Dimension(250, 300));
            sp.getViewport().add(tree);
            JPanel sv = new JPanel(new BorderLayout());
            sv.add("Center", sp);
            fv = new FolderViewer(null);
            JSplitPane jsp = new JSplitPane(1, sv, fv);
            jsp.setOneTouchExpandable(true);
            mv = new MessageViewer();
            JSplitPane jsp2 = new JSplitPane(0, jsp, mv);
            jsp2.setOneTouchExpandable(true);
            frame.getContentPane().add(jsp2);
            frame.pack();
            frame.show();
        }
        catch (Exception ex) {
            System.out.println("SimpletClient caught exception");
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

