/*
 * Decompiled with CFR 0.152.
 */
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.URLName;
import javax.swing.tree.DefaultMutableTreeNode;

public class StoreTreeNode
extends DefaultMutableTreeNode {
    protected Store store = null;
    protected Folder folder = null;
    protected String display = null;

    public StoreTreeNode(Store what) {
        super(what);
        this.store = what;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getChildCount() {
        if (this.folder == null) {
            this.loadChildren();
        }
        return super.getChildCount();
    }

    protected void loadChildren() {
        try {
            if (!this.store.isConnected()) {
                this.store.connect();
            }
            this.folder = this.store.getDefaultFolder();
            Folder[] sub = this.folder.list();
            int num = sub.length;
            for (int i = 0; i < num; ++i) {
                FolderTreeNode node = new FolderTreeNode(sub[i]);
                this.insert(node, i);
            }
        }
        catch (MessagingException me) {
            me.printStackTrace();
        }
    }

    @Override
    public String toString() {
        if (this.display == null) {
            URLName url = this.store.getURLName();
            if (url == null) {
                this.display = this.store.toString();
            } else {
                URLName too = new URLName(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), url.getUsername(), null);
                this.display = too.toString();
            }
        }
        return this.display;
    }
}

