/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.CommandObject;
import javax.activation.DataHandler;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextViewer
extends JPanel
implements CommandObject {
    private JTextArea text_area = new JTextArea();
    private DataHandler dh = null;
    private String verb = null;

    public TextViewer() {
        super(new GridLayout(1, 1));
        this.text_area.setEditable(false);
        this.text_area.setLineWrap(true);
        JScrollPane sp = new JScrollPane();
        sp.setPreferredSize(new Dimension(300, 300));
        sp.getViewport().add(this.text_area);
        this.add(sp);
    }

    public void setCommandContext(String verb, DataHandler dh) throws IOException {
        this.verb = verb;
        this.dh = dh;
        this.setInputStream(dh.getInputStream());
    }

    public void setInputStream(InputStream ins) {
        int bytes_read = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        try {
            while ((bytes_read = ins.read(data)) > 0) {
                baos.write(data, 0, bytes_read);
            }
            ins.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.text_area.setText(baos.toString());
    }
}

