/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.ErrorManager;
import java.util.logging.Level;
import java.util.logging.LogManager;

public class FileErrorManager
extends ErrorManager {
    private static final LogManager manager = LogManager.getLogManager();
    private final ErrorManager next = new ErrorManager();
    private final File emailStore;

    public FileErrorManager() {
        this.emailStore = this.getEmailStore();
        this.init();
    }

    public FileErrorManager(File dir) {
        this.emailStore = dir;
        this.init();
    }

    @Override
    public void error(String msg, Exception ex, int code) {
        if (this.isRawEmail(msg)) {
            try {
                this.storeEmail(msg);
            }
            catch (IOException | RuntimeException IOE) {
                this.next.error(msg, ex, code);
                super.error(this.emailStore.toString(), IOE, 0);
            }
        } else {
            this.next.error(msg, ex, code);
        }
    }

    private void init() {
        if (this.next == null) {
            throw new NullPointerException(ErrorManager.class.getName());
        }
        File dir = this.emailStore;
        if (dir.getClass() != File.class) {
            throw new IllegalArgumentException(dir.getClass().getName());
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("File must be a directory.");
        }
        if (!dir.canWrite()) {
            super.error(dir.getAbsolutePath(), new SecurityException("write"), 4);
        }
        if (!dir.isAbsolute()) {
            throw new IllegalArgumentException("Only absolute paths are allowed.");
        }
        if (!dir.canRead()) {
            super.error(dir.getAbsolutePath(), new SecurityException("read"), 4);
        }
    }

    private String prefixName() {
        return "FileErrorManager";
    }

    private String suffixName() {
        return ".eml";
    }

    private boolean isRawEmail(String msg) {
        if (msg != null && msg.length() > 0) {
            return !msg.startsWith(Level.SEVERE.getName());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeEmail(String email) throws IOException {
        File tmp = null;
        FileOutputStream out = null;
        while (true) {
            tmp = File.createTempFile(this.prefixName(), this.suffixName(), this.emailStore);
            try {
                out = new FileOutputStream(tmp);
            }
            catch (FileNotFoundException FNFE) {
                if (tmp.exists()) continue;
                throw FNFE;
            }
            break;
        }
        try (PrintStream ps = new PrintStream(this.wrap(out), false, "UTF-8");){
            ps.print(email);
            ps.flush();
            tmp = null;
        }
        finally {
            this.close(out);
            this.delete(tmp);
        }
    }

    private void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException IOE) {
                super.error(out.toString(), IOE, 3);
            }
        }
    }

    private void delete(File tmp) {
        block8: {
            if (tmp != null) {
                try {
                    if (tmp.delete() || !tmp.exists()) break block8;
                    try {
                        try {
                            tmp.deleteOnExit();
                        }
                        catch (LinkageError shutdown) {
                            throw new RuntimeException(shutdown);
                        }
                    }
                    catch (RuntimeException shutdown) {
                        if (!tmp.delete()) {
                            super.error(tmp.getAbsolutePath(), shutdown, 3);
                        }
                    }
                }
                catch (SecurityException SE) {
                    super.error(tmp.toString(), SE, 3);
                }
            }
        }
    }

    private File getEmailStore() {
        String dir = manager.getProperty(this.getClass().getName().concat(".pattern"));
        if (dir == null) {
            dir = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("java.io.tmpdir", ".");
                }
            });
        }
        return new File(dir);
    }

    private OutputStream wrap(OutputStream out) {
        assert (out != null);
        try {
            Class<?> k = Class.forName("NewlineOutputStream");
            if (OutputStream.class.isAssignableFrom(k)) {
                Constructor<?> c = k.getConstructor(OutputStream.class);
                return (OutputStream)c.newInstance(out);
            }
            super.error("Unable to switch newlines", new ClassNotFoundException(k.getName()), 0);
        }
        catch (RuntimeException re) {
            super.error("Unable to switch newlines", re, 0);
        }
        catch (Exception ex) {
            super.error("Unable to switch newlines", ex, 0);
        }
        catch (LinkageError le) {
            super.error("Unable to switch newlines", new ClassNotFoundException("", le), 0);
        }
        return out;
    }
}

