/*
 * Decompiled with CFR 0.152.
 */
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CRLFOutputStream
extends FilterOutputStream {
    protected int lastb = -1;
    protected static byte[] newline = new byte[2];

    public CRLFOutputStream(OutputStream os) {
        super(os);
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 13) {
            this.out.write(newline);
        } else if (b == 10) {
            if (this.lastb != 13) {
                this.out.write(newline);
            }
        } else {
            this.out.write(b);
        }
        this.lastb = b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int start = off;
        len += off;
        for (int i = start; i < len; ++i) {
            if (b[i] == 13) {
                this.out.write(b, start, i - start);
                this.out.write(newline);
                start = i + 1;
            } else if (b[i] == 10) {
                if (this.lastb != 13) {
                    this.out.write(b, start, i - start);
                    this.out.write(newline);
                }
                start = i + 1;
            }
            this.lastb = b[i];
        }
        if (len - start > 0) {
            this.out.write(b, start, len - start);
        }
    }

    static {
        CRLFOutputStream.newline[0] = 13;
        CRLFOutputStream.newline[1] = 10;
    }
}

