/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.event.StoreEvent;
import javax.mail.event.StoreListener;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;

public class msgshow {
    static String protocol;
    static String host;
    static String user;
    static String password;
    static String mbox;
    static String url;
    static int port;
    static boolean verbose;
    static boolean debug;
    static boolean showStructure;
    static boolean showMessage;
    static boolean showAlert;
    static boolean saveAttachments;
    static int attnum;
    static String indentStr;
    static int level;

    public static void main(String[] argv) {
        int optind;
        InputStream msgStream = System.in;
        for (optind = 0; optind < argv.length; ++optind) {
            if (argv[optind].equals("-T")) {
                protocol = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-H")) {
                host = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-U")) {
                user = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-P")) {
                password = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-v")) {
                verbose = true;
                continue;
            }
            if (argv[optind].equals("-D")) {
                debug = true;
                continue;
            }
            if (argv[optind].equals("-f")) {
                mbox = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-L")) {
                url = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-p")) {
                port = Integer.parseInt(argv[++optind]);
                continue;
            }
            if (argv[optind].equals("-s")) {
                showStructure = true;
                continue;
            }
            if (argv[optind].equals("-S")) {
                saveAttachments = true;
                continue;
            }
            if (argv[optind].equals("-m")) {
                showMessage = true;
                continue;
            }
            if (argv[optind].equals("-a")) {
                showAlert = true;
                continue;
            }
            if (argv[optind].equals("--")) {
                ++optind;
                break;
            }
            if (!argv[optind].startsWith("-")) break;
            System.out.println("Usage: msgshow [-L url] [-T protocol] [-H host] [-p port] [-U user]");
            System.out.println("\t[-P password] [-f mailbox] [msgnum ...] [-v] [-D] [-s] [-S] [-a]");
            System.out.println("or     msgshow -m [-v] [-D] [-s] [-S] [-f msg-file]");
            System.exit(1);
        }
        try {
            Properties props = System.getProperties();
            Session session = Session.getInstance((Properties)props, null);
            session.setDebug(debug);
            if (showMessage) {
                MimeMessage msg = mbox != null ? new MimeMessage(session, (InputStream)new BufferedInputStream(new FileInputStream(mbox))) : new MimeMessage(session, msgStream);
                msgshow.dumpPart((Part)msg);
                System.exit(0);
            }
            Store store = null;
            if (url != null) {
                URLName urln = new URLName(url);
                store = session.getStore(urln);
                if (showAlert) {
                    store.addStoreListener(new StoreListener(){

                        public void notification(StoreEvent e) {
                            String s = e.getMessageType() == 1 ? "ALERT: " : "NOTICE: ";
                            System.out.println(s + e.getMessage());
                        }
                    });
                }
                store.connect();
            } else {
                store = protocol != null ? session.getStore(protocol) : session.getStore();
                if (host != null || user != null || password != null) {
                    store.connect(host, port, user, password);
                } else {
                    store.connect();
                }
            }
            Folder folder = store.getDefaultFolder();
            if (folder == null) {
                System.out.println("No default folder");
                System.exit(1);
            }
            if (mbox == null) {
                mbox = "INBOX";
            }
            if ((folder = folder.getFolder(mbox)) == null) {
                System.out.println("Invalid folder");
                System.exit(1);
            }
            try {
                folder.open(2);
            }
            catch (MessagingException ex) {
                folder.open(1);
            }
            int totalMessages = folder.getMessageCount();
            if (totalMessages == 0) {
                System.out.println("Empty folder");
                folder.close(false);
                store.close();
                System.exit(1);
            }
            if (verbose) {
                int newMessages = folder.getNewMessageCount();
                System.out.println("Total messages = " + totalMessages);
                System.out.println("New messages = " + newMessages);
                System.out.println("-------------------------------");
            }
            if (optind >= argv.length) {
                Message[] msgs = folder.getMessages();
                FetchProfile fp = new FetchProfile();
                fp.add(FetchProfile.Item.ENVELOPE);
                fp.add(FetchProfile.Item.FLAGS);
                fp.add("X-Mailer");
                folder.fetch(msgs, fp);
                for (int i = 0; i < msgs.length; ++i) {
                    System.out.println("--------------------------");
                    System.out.println("MESSAGE #" + (i + 1) + ":");
                    msgshow.dumpEnvelope(msgs[i]);
                }
            } else {
                while (optind < argv.length) {
                    int msgnum = Integer.parseInt(argv[optind++]);
                    System.out.println("Getting message number: " + msgnum);
                    Message m = null;
                    try {
                        m = folder.getMessage(msgnum);
                        msgshow.dumpPart((Part)m);
                    }
                    catch (IndexOutOfBoundsException iex) {
                        System.out.println("Message number out of range");
                    }
                }
            }
            folder.close(false);
            store.close();
        }
        catch (Exception ex) {
            System.out.println("Oops, got exception! " + ex.getMessage());
            ex.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static void dumpPart(Part p) throws Exception {
        String disp;
        if (p instanceof Message) {
            msgshow.dumpEnvelope((Message)p);
        }
        String ct = p.getContentType();
        try {
            msgshow.pr("CONTENT-TYPE: " + new ContentType(ct).toString());
        }
        catch (ParseException pex) {
            msgshow.pr("BAD CONTENT-TYPE: " + ct);
        }
        String filename = p.getFileName();
        if (filename != null) {
            msgshow.pr("FILENAME: " + filename);
        }
        if (p.isMimeType("text/plain")) {
            msgshow.pr("This is plain text");
            msgshow.pr("---------------------------");
            if (!showStructure && !saveAttachments) {
                System.out.println((String)p.getContent());
            }
        } else if (p.isMimeType("multipart/*")) {
            msgshow.pr("This is a Multipart");
            msgshow.pr("---------------------------");
            Multipart mp = (Multipart)p.getContent();
            ++level;
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                msgshow.dumpPart((Part)mp.getBodyPart(i));
            }
            --level;
        } else if (p.isMimeType("message/rfc822")) {
            msgshow.pr("This is a Nested Message");
            msgshow.pr("---------------------------");
            ++level;
            msgshow.dumpPart((Part)p.getContent());
            --level;
        } else if (!showStructure && !saveAttachments) {
            Object o = p.getContent();
            if (o instanceof String) {
                msgshow.pr("This is a string");
                msgshow.pr("---------------------------");
                System.out.println((String)o);
            } else if (o instanceof InputStream) {
                int c;
                msgshow.pr("This is just an input stream");
                msgshow.pr("---------------------------");
                InputStream is = (InputStream)o;
                while ((c = is.read()) != -1) {
                    System.out.write(c);
                }
            } else {
                msgshow.pr("This is an unknown type");
                msgshow.pr("---------------------------");
                msgshow.pr(o.toString());
            }
        } else {
            msgshow.pr("---------------------------");
        }
        if (saveAttachments && level != 0 && p instanceof MimeBodyPart && !p.isMimeType("multipart/*") && ((disp = p.getDisposition()) == null || disp.equalsIgnoreCase("attachment"))) {
            if (filename == null) {
                filename = "Attachment" + attnum++;
            }
            msgshow.pr("Saving attachment to file " + filename);
            try {
                File f = new File(filename);
                if (f.exists()) {
                    throw new IOException("file exists");
                }
                ((MimeBodyPart)p).saveFile(f);
            }
            catch (IOException ex) {
                msgshow.pr("Failed to save attachment: " + ex);
            }
            msgshow.pr("---------------------------");
        }
    }

    public static void dumpEnvelope(Message m) throws Exception {
        int j;
        msgshow.pr("This is the message envelope");
        msgshow.pr("---------------------------");
        Address[] a = m.getFrom();
        if (a != null) {
            for (j = 0; j < a.length; ++j) {
                msgshow.pr("FROM: " + a[j].toString());
            }
        }
        if ((a = m.getReplyTo()) != null) {
            for (j = 0; j < a.length; ++j) {
                msgshow.pr("REPLY TO: " + a[j].toString());
            }
        }
        if ((a = m.getRecipients(Message.RecipientType.TO)) != null) {
            for (j = 0; j < a.length; ++j) {
                msgshow.pr("TO: " + a[j].toString());
                InternetAddress ia = (InternetAddress)a[j];
                if (!ia.isGroup()) continue;
                InternetAddress[] aa = ia.getGroup(false);
                for (int k = 0; k < aa.length; ++k) {
                    msgshow.pr("  GROUP: " + aa[k].toString());
                }
            }
        }
        msgshow.pr("SUBJECT: " + m.getSubject());
        Date d = m.getSentDate();
        msgshow.pr("SendDate: " + (d != null ? d.toString() : "UNKNOWN"));
        Flags flags = m.getFlags();
        StringBuffer sb = new StringBuffer();
        Flags.Flag[] sf = flags.getSystemFlags();
        boolean first = true;
        for (int i = 0; i < sf.length; ++i) {
            String s;
            Flags.Flag f = sf[i];
            if (f == Flags.Flag.ANSWERED) {
                s = "\\Answered";
            } else if (f == Flags.Flag.DELETED) {
                s = "\\Deleted";
            } else if (f == Flags.Flag.DRAFT) {
                s = "\\Draft";
            } else if (f == Flags.Flag.FLAGGED) {
                s = "\\Flagged";
            } else if (f == Flags.Flag.RECENT) {
                s = "\\Recent";
            } else {
                if (f != Flags.Flag.SEEN) continue;
                s = "\\Seen";
            }
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(s);
        }
        String[] uf = flags.getUserFlags();
        for (int i = 0; i < uf.length; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(uf[i]);
        }
        msgshow.pr("FLAGS: " + sb.toString());
        String[] hdrs = m.getHeader("X-Mailer");
        if (hdrs != null) {
            msgshow.pr("X-Mailer: " + hdrs[0]);
        } else {
            msgshow.pr("X-Mailer NOT available");
        }
    }

    public static void pr(String s) {
        if (showStructure) {
            System.out.print(indentStr.substring(0, level * 2));
        }
        System.out.println(s);
    }

    static {
        host = null;
        user = null;
        password = null;
        mbox = null;
        url = null;
        port = -1;
        verbose = false;
        debug = false;
        showStructure = false;
        showMessage = false;
        showAlert = false;
        saveAttachments = false;
        attnum = 1;
        indentStr = "                                               ";
        level = 0;
    }
}

