/*
 * Decompiled with CFR 0.152.
 */
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;

public class namespace {
    static String protocol;
    static String host;
    static String user;
    static String password;
    static String url;
    static int port;
    static boolean debug;
    static String suser;

    public static void main(String[] argv) {
        int msgnum = -1;
        for (int optind = 0; optind < argv.length; ++optind) {
            if (argv[optind].equals("-T")) {
                protocol = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-H")) {
                host = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-U")) {
                user = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-P")) {
                password = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-D")) {
                debug = true;
                continue;
            }
            if (argv[optind].equals("-L")) {
                url = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-p")) {
                port = Integer.parseInt(argv[++optind]);
                continue;
            }
            if (argv[optind].equals("-u")) {
                suser = argv[++optind];
                continue;
            }
            if (argv[optind].equals("--")) {
                ++optind;
                break;
            }
            if (!argv[optind].startsWith("-")) break;
            System.out.println("Usage: namespace [-L url] [-T protocol] [-H host] [-p port] [-U user]");
            System.out.println("\t[-P password] [-u other-user] [-D]");
            System.exit(1);
        }
        try {
            Properties props = System.getProperties();
            Session session = Session.getInstance((Properties)props, null);
            session.setDebug(debug);
            Store store = null;
            if (url != null) {
                URLName urln = new URLName(url);
                store = session.getStore(urln);
                store.connect();
            } else {
                store = protocol != null ? session.getStore(protocol) : session.getStore();
                if (host != null || user != null || password != null) {
                    store.connect(host, port, user, password);
                } else {
                    store.connect();
                }
            }
            namespace.printFolders("Personal", store.getPersonalNamespaces());
            namespace.printFolders("User \"" + suser + "\"", store.getUserNamespaces(suser));
            namespace.printFolders("Shared", store.getSharedNamespaces());
            store.close();
        }
        catch (Exception ex) {
            System.out.println("Oops, got exception! " + ex.getMessage());
            ex.printStackTrace();
        }
        System.exit(0);
    }

    private static void printFolders(String name, Folder[] folders) throws MessagingException {
        System.out.println(name + " Namespace:");
        if (folders == null || folders.length == 0) {
            System.out.println("  <none>");
            return;
        }
        for (int i = 0; i < folders.length; ++i) {
            String fn = folders[i].getFullName();
            if (fn.length() == 0) {
                fn = "<default folder>";
            }
            try {
                System.out.println("  " + fn + ", delimiter \"" + folders[i].getSeparator() + "\"");
                Folder[] fl = folders[i].list();
                if (fl.length <= 0) continue;
                System.out.println("  Subfolders:");
                for (int j = 0; j < fl.length; ++j) {
                    System.out.println("    " + fl[j].getFullName());
                }
                continue;
            }
            catch (FolderNotFoundException folderNotFoundException) {
                // empty catch block
            }
        }
    }

    static {
        host = null;
        user = null;
        password = null;
        url = null;
        port = -1;
        debug = false;
        suser = "other";
    }
}

