/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.search.AndTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.ReceivedDateTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SizeTerm;
import javax.mail.search.SubjectTerm;

public class search {
    static String protocol = "imap";
    static String host = null;
    static String user = null;
    static String password = null;
    static String mbox = "INBOX";
    static String url = null;
    static boolean debug = false;

    public static void main(String[] argv) {
        String subject = null;
        String from = null;
        boolean or = false;
        boolean today = false;
        int size = -1;
        for (int optind = 0; optind < argv.length; ++optind) {
            if (argv[optind].equals("-T")) {
                protocol = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-H")) {
                host = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-U")) {
                user = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-P")) {
                password = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-or")) {
                or = true;
                continue;
            }
            if (argv[optind].equals("-D")) {
                debug = true;
                continue;
            }
            if (argv[optind].equals("-f")) {
                mbox = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-L")) {
                url = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-subject")) {
                subject = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-from")) {
                from = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-today")) {
                today = true;
                continue;
            }
            if (argv[optind].equals("-size")) {
                size = Integer.parseInt(argv[++optind]);
                continue;
            }
            if (argv[optind].equals("--")) {
                ++optind;
                break;
            }
            if (!argv[optind].startsWith("-")) break;
            System.out.println("Usage: search [-D] [-L url] [-T protocol] [-H host] [-U user] [-P password] [-f mailbox] [-subject subject] [-from from] [-or] [-today]");
            System.exit(1);
        }
        try {
            if (subject == null && from == null && !today && size < 0) {
                System.out.println("Specify either -subject, -from, -today, or -size");
                System.exit(1);
            }
            Properties props = System.getProperties();
            Session session = Session.getInstance((Properties)props, null);
            session.setDebug(debug);
            Store store = null;
            if (url != null) {
                URLName urln = new URLName(url);
                store = session.getStore(urln);
                store.connect();
            } else {
                store = protocol != null ? session.getStore(protocol) : session.getStore();
                if (host != null || user != null || password != null) {
                    store.connect(host, user, password);
                } else {
                    store.connect();
                }
            }
            Folder folder = store.getDefaultFolder();
            if (folder == null) {
                System.out.println("Cant find default namespace");
                System.exit(1);
            }
            if ((folder = folder.getFolder(mbox)) == null) {
                System.out.println("Invalid folder");
                System.exit(1);
            }
            folder.open(1);
            Object term = null;
            if (subject != null) {
                term = new SubjectTerm(subject);
            }
            if (from != null) {
                FromStringTerm fromTerm = new FromStringTerm(from);
                term = term != null ? (or ? new OrTerm((SearchTerm)term, (SearchTerm)fromTerm) : new AndTerm((SearchTerm)term, (SearchTerm)fromTerm)) : fromTerm;
            }
            if (today) {
                Calendar c = Calendar.getInstance();
                c.set(10, 0);
                c.set(12, 0);
                c.set(13, 0);
                c.set(14, 0);
                c.set(9, 0);
                ReceivedDateTerm startDateTerm = new ReceivedDateTerm(6, c.getTime());
                c.add(5, 1);
                ReceivedDateTerm endDateTerm = new ReceivedDateTerm(2, c.getTime());
                AndTerm dateTerm = new AndTerm((SearchTerm)startDateTerm, (SearchTerm)endDateTerm);
                term = term != null ? (or ? new OrTerm((SearchTerm)term, (SearchTerm)dateTerm) : new AndTerm((SearchTerm)term, (SearchTerm)dateTerm)) : dateTerm;
            }
            if (size >= 0) {
                SizeTerm sizeTerm = new SizeTerm(5, size);
                term = term != null ? (or ? new OrTerm((SearchTerm)term, (SearchTerm)sizeTerm) : new AndTerm((SearchTerm)term, (SearchTerm)sizeTerm)) : sizeTerm;
            }
            Message[] msgs = folder.search((SearchTerm)term);
            System.out.println("FOUND " + msgs.length + " MESSAGES");
            if (msgs.length == 0) {
                System.exit(1);
            }
            FetchProfile fp = new FetchProfile();
            fp.add(FetchProfile.Item.ENVELOPE);
            folder.fetch(msgs, fp);
            for (int i = 0; i < msgs.length; ++i) {
                System.out.println("--------------------------");
                System.out.println("MESSAGE #" + (i + 1) + ":");
                search.dumpPart((Part)msgs[i]);
            }
            folder.close(false);
            store.close();
        }
        catch (Exception ex) {
            System.out.println("Oops, got exception! " + ex.getMessage());
            ex.printStackTrace();
        }
        System.exit(1);
    }

    public static void dumpPart(Part p) throws Exception {
        block24: {
            int c;
            Object o;
            block25: {
                block23: {
                    if (p instanceof Message) {
                        int j;
                        Message m = (Message)p;
                        Address[] a = m.getFrom();
                        if (a != null) {
                            for (j = 0; j < a.length; ++j) {
                                System.out.println("FROM: " + a[j].toString());
                            }
                        }
                        if ((a = m.getRecipients(Message.RecipientType.TO)) != null) {
                            for (j = 0; j < a.length; ++j) {
                                System.out.println("TO: " + a[j].toString());
                            }
                        }
                        System.out.println("SUBJECT: " + m.getSubject());
                        Date d = m.getSentDate();
                        System.out.println("SendDate: " + (d != null ? d.toLocaleString() : "UNKNOWN"));
                        Flags flags = m.getFlags();
                        StringBuffer sb = new StringBuffer();
                        Flags.Flag[] sf = flags.getSystemFlags();
                        boolean first = true;
                        for (int i = 0; i < sf.length; ++i) {
                            String s;
                            Flags.Flag f = sf[i];
                            if (f == Flags.Flag.ANSWERED) {
                                s = "\\Answered";
                            } else if (f == Flags.Flag.DELETED) {
                                s = "\\Deleted";
                            } else if (f == Flags.Flag.DRAFT) {
                                s = "\\Draft";
                            } else if (f == Flags.Flag.FLAGGED) {
                                s = "\\Flagged";
                            } else if (f == Flags.Flag.RECENT) {
                                s = "\\Recent";
                            } else {
                                if (f != Flags.Flag.SEEN) continue;
                                s = "\\Seen";
                            }
                            if (first) {
                                first = false;
                            } else {
                                sb.append(' ');
                            }
                            sb.append(s);
                        }
                        String[] uf = flags.getUserFlags();
                        for (int i = 0; i < uf.length; ++i) {
                            if (first) {
                                first = false;
                            } else {
                                sb.append(' ');
                            }
                            sb.append(uf[i]);
                        }
                        System.out.println("FLAGS = " + sb.toString());
                    }
                    System.out.println("CONTENT-TYPE: " + p.getContentType());
                    o = p.getContent();
                    if (!(o instanceof String)) break block23;
                    System.out.println("This is a String");
                    System.out.println((String)o);
                    break block24;
                }
                if (!(o instanceof Multipart)) break block25;
                System.out.println("This is a Multipart");
                Multipart mp = (Multipart)o;
                int count = mp.getCount();
                for (int i = 0; i < count; ++i) {
                    search.dumpPart((Part)mp.getBodyPart(i));
                }
                break block24;
            }
            if (!(o instanceof InputStream)) break block24;
            System.out.println("This is just an input stream");
            InputStream is = (InputStream)o;
            while ((c = is.read()) != -1) {
                System.out.write(c);
            }
        }
    }
}

