/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class transport
implements ConnectionListener,
TransportListener {
    static String msgText = "This is a message body.\nHere's the second line.";
    static String msgText2 = "\nThis was sent by transport.java demo program.";

    public static void main(String[] args) {
        InternetAddress from;
        Properties props = System.getProperties();
        InternetAddress[] addrs = null;
        boolean debug = false;
        if (args.length != 4) {
            transport.usage();
            return;
        }
        props.put("mail.smtp.host", args[2]);
        if (args[3].equals("true")) {
            debug = true;
        } else if (args[3].equals("false")) {
            debug = false;
        } else {
            transport.usage();
            return;
        }
        try {
            addrs = InternetAddress.parse((String)args[0], (boolean)false);
            from = new InternetAddress(args[1]);
        }
        catch (AddressException aex) {
            System.out.println("Invalid Address");
            aex.printStackTrace();
            return;
        }
        Session session = Session.getInstance((Properties)props, null);
        session.setDebug(debug);
        transport t = new transport();
        t.go(session, addrs, from);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go(Session session, InternetAddress[] toAddr, InternetAddress from) {
        Transport trans = null;
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)from);
            msg.setRecipients(Message.RecipientType.TO, (Address[])toAddr);
            msg.setSubject("JavaMail APIs transport.java Test");
            msg.setSentDate(new Date());
            msg.setContent((Object)(msgText + msgText2), "text/plain");
            msg.saveChanges();
            trans = session.getTransport((Address)toAddr[0]);
            trans.addConnectionListener((ConnectionListener)this);
            trans.addTransportListener((TransportListener)this);
            trans.connect();
            trans.sendMessage((Message)msg, (Address[])toAddr);
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        catch (MessagingException mex) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("Sending failed with exception:");
            mex.printStackTrace();
            System.out.println();
            Throwable ex = mex;
            do {
                if (ex instanceof SendFailedException) {
                    Address[] validSent;
                    Address[] validUnsent;
                    SendFailedException sfex = (SendFailedException)ex;
                    Address[] invalid = sfex.getInvalidAddresses();
                    if (invalid != null) {
                        System.out.println("    ** Invalid Addresses");
                        for (int i = 0; i < invalid.length; ++i) {
                            System.out.println("         " + invalid[i]);
                        }
                    }
                    if ((validUnsent = sfex.getValidUnsentAddresses()) != null) {
                        System.out.println("    ** ValidUnsent Addresses");
                        for (int i = 0; i < validUnsent.length; ++i) {
                            System.out.println("         " + validUnsent[i]);
                        }
                    }
                    if ((validSent = sfex.getValidSentAddresses()) != null) {
                        System.out.println("    ** ValidSent Addresses");
                        for (int i = 0; i < validSent.length; ++i) {
                            System.out.println("         " + validSent[i]);
                        }
                    }
                }
                System.out.println();
            } while ((ex = ex instanceof MessagingException ? ex.getNextException() : null) != null);
        }
        finally {
            try {
                if (trans != null) {
                    trans.close();
                }
            }
            catch (MessagingException messagingException) {}
        }
    }

    public void opened(ConnectionEvent e) {
        System.out.println(">>> ConnectionListener.opened()");
    }

    public void disconnected(ConnectionEvent e) {
    }

    public void closed(ConnectionEvent e) {
        System.out.println(">>> ConnectionListener.closed()");
    }

    public void messageDelivered(TransportEvent e) {
        System.out.println(">>> TransportListener.messageDelivered().");
        System.out.println(" Valid Addresses:");
        Address[] valid = e.getValidSentAddresses();
        if (valid != null) {
            for (int i = 0; i < valid.length; ++i) {
                System.out.println("    " + valid[i]);
            }
        }
    }

    public void messageNotDelivered(TransportEvent e) {
        System.out.println(">>> TransportListener.messageNotDelivered().");
        System.out.println(" Invalid Addresses:");
        Address[] invalid = e.getInvalidAddresses();
        if (invalid != null) {
            for (int i = 0; i < invalid.length; ++i) {
                System.out.println("    " + invalid[i]);
            }
        }
    }

    public void messagePartiallyDelivered(TransportEvent e) {
        System.out.println(">>> TransportListener.messagePartiallyDelivered().");
        System.out.println(" Valid Addresses:");
        Address[] valid = e.getValidSentAddresses();
        if (valid != null) {
            for (int i = 0; i < valid.length; ++i) {
                System.out.println("    " + valid[i]);
            }
        }
        System.out.println(" Valid Unsent Addresses:");
        Address[] unsent = e.getValidUnsentAddresses();
        if (unsent != null) {
            for (int i = 0; i < unsent.length; ++i) {
                System.out.println("    " + unsent[i]);
            }
        }
        System.out.println(" Invalid Addresses:");
        Address[] invalid = e.getInvalidAddresses();
        if (invalid != null) {
            for (int i = 0; i < invalid.length; ++i) {
                System.out.println("    " + invalid[i]);
            }
        }
    }

    private static void usage() {
        System.out.println("usage: java transport \"<to1>[, <to2>]*\" <from> <smtp> true|false");
        System.out.println("example: java transport \"joe@machine, jane\" senderaddr smtphost false");
    }
}

