/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.mbox;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class NewlineOutputStream
extends FilterOutputStream {
    private int lastb = -1;
    private int bol = 1;
    private final boolean endWithBlankLine;
    private static final byte[] newline;

    public NewlineOutputStream(OutputStream os) {
        this(os, false);
    }

    public NewlineOutputStream(OutputStream os, boolean endWithBlankLine) {
        super(os);
        this.endWithBlankLine = endWithBlankLine;
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 13) {
            this.out.write(newline);
            ++this.bol;
        } else if (b == 10) {
            if (this.lastb != 13) {
                this.out.write(newline);
                ++this.bol;
            }
        } else {
            this.out.write(b);
            this.bol = 0;
        }
        this.lastb = b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.endWithBlankLine) {
            if (this.bol == 0) {
                this.out.write(newline);
                this.out.write(newline);
            } else if (this.bol == 1) {
                this.out.write(newline);
            }
        }
        this.bol = 2;
        this.out.flush();
    }

    static {
        String s = null;
        try {
            s = System.getProperty("line.separator");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (s == null || s.length() <= 0) {
            s = "\n";
        }
        newline = new byte[s.length()];
        s.getBytes(0, s.length(), newline, 0);
    }
}

