/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.remote;

import com.sun.mail.mbox.MboxStore;
import com.sun.mail.remote.RemoteDefaultFolder;
import com.sun.mail.remote.RemoteInbox;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;

public abstract class RemoteStore
extends MboxStore {
    protected Store remoteStore;
    protected Folder remoteInbox;
    protected Folder inbox;
    protected String host;
    protected String user;
    protected String password;
    protected int port;
    protected long lastUpdate = 0L;

    public RemoteStore(Session session, URLName url) {
        super(session, url);
        this.remoteStore = this.getRemoteStore(session, url);
    }

    protected abstract Store getRemoteStore(Session var1, URLName var2);

    public void connect(String host, int port, String user, String password) throws MessagingException {
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.updateInbox();
    }

    protected void updateInbox() throws MessagingException {
        if (System.currentTimeMillis() < this.lastUpdate + 5000L) {
            return;
        }
        try {
            this.remoteStore.connect(this.host, this.port, this.user, this.password);
            if (!this.isConnected()) {
                super.connect(this.host, this.port, this.user, this.password);
            }
            if (this.remoteInbox == null) {
                this.remoteInbox = this.remoteStore.getFolder("INBOX");
            }
            if (this.inbox == null) {
                this.inbox = this.getFolder("INBOX");
            }
            this.remoteInbox.open(2);
            Message[] msgs = this.remoteInbox.getMessages();
            this.inbox.appendMessages(msgs);
            this.remoteInbox.setFlags(msgs, new Flags(Flags.Flag.DELETED), true);
            this.remoteInbox.close(true);
            this.remoteStore.close();
        }
        catch (MessagingException ex) {
            try {
                if (this.remoteInbox != null && this.remoteInbox.isOpen()) {
                    this.remoteInbox.close(false);
                }
            }
            finally {
                if (this.remoteStore != null && this.remoteStore.isConnected()) {
                    this.remoteStore.close();
                }
            }
            throw ex;
        }
    }

    @Override
    public Folder getDefaultFolder() throws MessagingException {
        this.checkConnected();
        return new RemoteDefaultFolder(this, null);
    }

    @Override
    public Folder getFolder(String name) throws MessagingException {
        this.checkConnected();
        if (name.equalsIgnoreCase("INBOX")) {
            return new RemoteInbox(this, name);
        }
        return super.getFolder(name);
    }

    @Override
    public Folder getFolder(URLName url) throws MessagingException {
        this.checkConnected();
        return this.getFolder(url.getFile());
    }

    private void checkConnected() throws MessagingException {
        if (!this.isConnected()) {
            throw new MessagingException("Not connected");
        }
    }
}

