/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.MultipartDataSource;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;

public class MSMultipartDataSource
extends MimePartDataSource
implements MultipartDataSource {
    private List parts = new ArrayList();

    public MSMultipartDataSource(MimePart part, byte[] content) throws MessagingException {
        super(part);
        int start;
        int pos = this.startsWith(content, 0, "begin");
        if (pos == -1) {
            throw new MessagingException("invalid multipart");
        }
        if (pos > 0) {
            this.parts.add(new MSBodyPart(content, 0, pos, "inline", "7bit"));
        } else {
            pos = 0;
        }
        while ((start = this.startsWith(content, pos, "begin")) != -1 && (pos = this.startsWith(content, start, "end")) != -1) {
            this.parts.add(new MSBodyPart(content, start, pos += 3, "attachment", "uuencode"));
        }
    }

    public int getCount() {
        return this.parts.size();
    }

    public BodyPart getBodyPart(int index) throws MessagingException {
        return (BodyPart)this.parts.get(index);
    }

    private int startsWith(byte[] content, int start, String seq) {
        int slen = seq.length();
        boolean bol = true;
        for (int i = start; i < content.length; ++i) {
            String s;
            if (bol && i + slen < content.length && (s = MSMessage.toString(content, i, i + slen)).equalsIgnoreCase(seq)) {
                return i;
            }
            int b = content[i] & 0xFF;
            bol = b == 13 || b == 10;
        }
        return -1;
    }
}

